;+
; FUNCTION bzrpatch, bzr
;
; This function takes a bezier surface and creates the individual 
; patches, returned as an array of structures. 
;
; 
;-

FUNCTION bzrpatch, bzr

p=bzr.p
q=bzr.q

npx = (bzr.dim[0])/(p+1) ;number of patches in x direction
npy = (bzr.dim[1])/(q+1) ;number of patches in y direction

temp=nrbstruct(dblarr(p+1,4,q+1,/nozero),dblarr(2*(p+1)),dblarr(2*(q+1)))

temp=replicate(temp,npy,npx)

FOR ii=0,npy-1 DO BEGIN
    FOR jj=0,npx-1 DO BEGIN

       coefs=bzr.coefs((p+1)*jj:(p+1)*(jj+1)-1,*,(q+1)*ii:(q+1)*(ii+1)-1)
       uknots=bzr.uknots((p+1)*jj:(p+1)*(jj+2)-1)
       vknots=bzr.vknots((q+1)*ii:(q+1)*(ii+2)-1)
       temp[ii,jj]=nrbstruct(coefs,uknots,vknots)


    ENDFOR
ENDFOR

return,temp

END
