;
;transform e 3D grid matrix  in 3 separated grid (see surface.pro)
;
;ARGUMENTS
;   GRID = 3D grid in the form m-by-3-by-n (see function indgen[m1,m2,m3...])
;KEYWORDS
;   V = int number for x(0) or y(1) or z(2) grid (default V=2)
;

FUNCTION __nrbgrid2mat, grid, v=v

IF n_elements(v) EQ 0 THEN v=2


;//reshaping of the grid//;
CASE v OF

0: mat=transpose(reform(grid(*,0,*)))
1: mat=transpose(reform(grid(*,1,*)))
2: mat=transpose(reform(grid(*,2,*)))

ENDCASE

return, mat

END
