FUNCTION waviness_read,filein,default=default

IF Keyword_Set(default) THEN BEGIN
  ds = SDep(/ds)
  filein= Xop_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ $
                ds+'data'+ds+'waviness.inp'
ENDIF


IF N_Elements(filein) EQ 0 THEN BEGIN
  filein = Dialog_Pickfile()
ENDIF

IF filein EQ '' THEN RETURN,0

file=''
mm = DblArr(3,5001)

OpenR,unit,filein,/Get_Lun
  readf,unit,file
;print,'>>>>',file
  readf,unit,npointx,npointy
  readf,unit,width,xlength
;print,'>>>>',npointx,npointy
;print,'>>>>',width,xlength
  readf,unit,n,slp
;print,'>>>>',n,slp
   iseed=0L
  readf,unit,iseed
  IF n GT 5000L THEN BEGIN
    itmp = Dialog_Message(/Info,'Max number of harmonics: 5000: Shortened')
    n=5000L
  ENDIF
;print,'>>>>',iseed
;help,mm
  tmp = Dblarr(3)
  FOR i=0L,n DO BEGIN
     readf,unit,tmp 
     mm[*,i]=tmp
  ENDFOR
Free_Lun,unit


out = {file:file, npointx:Long(npointx), npointy:Long(npointy), width:width, $
       xlength:xlength, n:Long(n), slp:slp, iseed:Long(iseed), $
       c:Reform(mm[0,*]), y:Reform(mm[1,*]), g:Reform(mm[2,*]) }

RETURN,out
END ; waviness_read
