PRO cnpick
;+
; NAME:
;	CNPICK
;
; PURPOSE:
;	This is a menu-driven procedure to perform the basic EXAFS 
;	data substraction
;
; CATEGORY:
;	XAID XAFSdata analysis package.
;
; CALLING SEQUENCE:
;	cnpick
;
; INPUTS:
;	from the keyboard
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	In the graphic screen, and optionally writes files.
;	Creates the file cnpick.log consisting in an IDL program
;	which reproduces the performed operations.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	This program uses the IDL's EXAFS package
;
; EXAMPLE:
;
;		Just follow the default menu values.
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	May, 1993 version 0.3
;	October, 1994 version 0.4
;	30-Set-97 srio@esrf.fr READ_ASCII renamed to RASCII
;-
;
; open log file
;
openw,Unit,'cnpick.log',/get_lun
;
print,'*******************************************************'
print,'*                                                     *'
print,'*                    CNPICK                           *'
print,'*                   MSR, ESRF                         *'
print,'*               v0.3     May 1993                     *'
print,'*                                                     *'
print,'*******************************************************'
;
; select terminal
;
terminal
;
; read the file and store the data in 'set0', then plot ------
;
file='co.mu'
file = getvalue('Data file with absorption E,mu(E) [Default=co.mu] : ? ',file)
set0 = rascii(file) ; set0 = experimental spectrum
printf,Unit,';'
printf,Unit,'; read file '
printf,Unit,';'
printf,Unit,"file='"+strcompress(file,/rem)+"'"
printf,Unit,"set0 = rascii(file)"
;
; create structure with labels for plots
;
title_str = {name:'', x:'E [eV]', y:'!4l!3  [arbitrary units]', top:''}
spawn,'date',/noshell,date
;spawn,'pwd',/noshell,pwd
spawn,'echo $user',user
spawn,'echo `hostname`',host
title_str.top='CNPICKv0.3 '+strcompress(user(0),/rem)+'@'+ $
 strcompress(host(0),/rem)+'   '+'Data from file: '+strcompress(file,/rem)+$
 '             '
;
; cleaning menu
;
set1 = set0
printf,Unit,'set1 = set0'
repeat begin
  plotset,set1,tit_str=title_str
  print,' Please select one option : '
    print,'		[0] Cancel and continue'
    print,'		[1] Cut the spectrum'
    print,'		[2] Zoom'
    print,'		[3] Print values'
    prInt,'		[4] Show 1st and 2nd derivatives'
    print,'		[5] Interpolation'
  i_menu_clean = getvalue('[Default=0] ? ',0)
  npoints = n_elements(set1(0,*))
  case i_menu_clean of
  0:
  1: begin
       plotset,set1,tit_str=title_str
       gettwoabscissas,x1,x2
       ;
       plot,set1(0,*),set1(1,*),xrange=[x1,x2],/xstyle
       i_ok = getyesornot(' Are you happy with this cut ? [y/n] ')
       if i_ok then begin
         cutset,set1,settmp,xrange=[x1,x2]
         set1 = settmp
         printf,Unit,';'
         printf,Unit,'; cut set '
         printf,Unit,';'
         printf,Unit,'x1 = ',x1,'  &  x2 = ',x2
         printf,Unit,' cutset,set1,settmp,xrange=[x1,x2]'
         printf,Unit,'set1 = settmp'
       endif
     end
  2: zoomset,set1
  3: begin
       print,' Please, click the extrema of the printing: First point ? '
       cursor,x1,y1,3
       plotset,[[x1,-1000000],[x1,1000000]],/over
       print,'                                       Last point ? '
       cursor,x2,y2,3
       plotset,[[x2,-1000000],[x2,1000000]],/over
       print,'*******************************************'
       print,'  point number           E               chi         '
       print,' '
       for i=0,n_elements(set1(0,*))-1 do begin
         if (set1(0,i) ge x1 and set1(0,i) lt x2) then $
          print,i,'	',set1(0,i),'	',set1(1,i)
       endfor
       print,'*******************************************'
       i_remove = getyesornot(' Do you want to remove any point ? [n] ')
       if i_remove then begin
         print,' Which point number ? '
         read,i_point
         remove_point,i_point,set1,settmp
         set1 = settmp
         for i=0,n_elements(set1(0,*))-1 do begin
           if (set1(0,i) ge x1 and set1(0,i) lt x2) then $
            print,i,'	',set1(0,i),'	',set1(1,i)
         endfor
         printf,Unit,';'
         printf,Unit,'; remove point '
         printf,Unit,';'
         printf,Unit,'i_point = ',i_point
         printf,Unit,' remove_point,i_point,set1,settmp'
         printf,Unit,' set1 = settmp'
       endif
     end
  4: begin
       derivset,set1,plot=2
       pause
     end
  5: begin
       print,npoints,' points in current spectrum'
       print,'------------- min -----  max -------  mean ------- stdev ---'
       stdevval = stddev(set1(0,*))
       mean1 = mean(set1(0,*))
       print,' E  : ',min(set1(0,*)),max(set1(0,*)),mean1,stdevval
       stdevval = stddev(set1(1,*))
       mean1 = mean(set1(1,*))
       print,' mu : ',min(set1(1,*)),max(set1(1,*)),mean1,stdevval
       vecttmp = shift(set1(0,*),-1) - set1(0,*)
       vecttmp = vecttmp(0:npoints-2)
       stdevval = stddev(vecttmp)
       mean1 = mean(vecttmp)
       print,' DE : ',min(vecttmp),max(vecttmp),mean1,stdevval
       print,'------------------------------------------------------------'
       print,' Select interpolation method: '
       print,'		[0] Cancel and Continue'
       print,'		[1] Linear interpolation'
       print,'		[2] Spline'
       read,i_interp
       if ((i_interp eq 1) or (i_interp eq 2)) then begin
         print,' Input number of points for the interpolated spectrum ? '
         read,n_interp
         int_step = (max(set1(0,*))-min(set1(0,*)))/float(n_interp-1)
         settmp = fltarr(2,n_interp)
         settmp(0,*) = findgen(n_interp)*int_step + min(set1(0,*))
         if (i_interp eq 1) then settmp(1,*) = $
          interpol(set1(1,*),set1(0,*),settmp(0,*))
         if (i_interp eq 2) then settmp(1,*) = $
          spline(set1(0,*),set1(1,*),settmp(0,*))
         plotset,settmp,tit_str=title_str
         print,n_interp,' points in current spectrum'
         print,'------------- min -----  max -------  mean ------- stdev ---'
         stdevval = stddev(settmp(0,*))
         mean1 = mean(settmp(0,*))
         print,' E  : ',min(settmp(0,*)),max(settmp(0,*)),mean1,stdevval
         stdevval = stddev(settmp(1,*))
         mean1 = mean(settmp(1,*))
         print,' mu : ',min(settmp(1,*)),max(settmp(1,*)),mean1,stdevval
         vecttmp = shift(settmp(0,*),-1) - settmp(0,*)
         vecttmp = vecttmp(0:npoints-2)
         stdevval = stddev(vecttmp)
         mean1 = mean(vecttmp)
         print,' DE : ',min(vecttmp),max(vecttmp),mean1,stdevval
         print,'------------------------------------------------------------'
         i_go = getyesornot(' Do you want to substitute the current'+ $
          ' spectrum by the interpolated one ? [n] ')
         if i_go then begin
           set1=settmp
           printf,Unit,';'
           printf,Unit,'; interpolation '
           printf,Unit,';'
           printf,Unit,'n_interp = ',n_interp
           printf,Unit,'int_step = ',int_step
           printf,Unit,'settmp = fltarr(2,n_interp)'
           printf,Unit,'settmp(0,*) = findgen(n_interp)*int_step +'+  $
            'min(set1(0,*))'
           if (i_interp eq 1) then printf,Unit, $
             'settmp(1,*) =  interpol(set1(1,*),set1(0,*),settmp(0,*))'
           if (i_interp eq 2) then printf,Unit, $
             'settmp(1,*) = spline(set1(0,*),set1(1,*),settmp(0,*))'
           printf,Unit,'set1=settmp'
         endif
       endif
     end
  endcase
endrep until (i_menu_clean eq 0)
;
; Edge Value ---------------------------------------------------
;
;
print,'********************* Edge value ****************************'
;
print,' Getting Eo from the maximum of the derivative...'
e0 = gete0(set1)
print,' The selected Eo from the maximum of the derivative is:   ',e0
repeat begin
  plotset,set1,tit_str=title_str
  plotset,[[e0,-1e5],[e0,1e5]],/over
  print,' Please select one option : '
    print,'		[1] Rescale to this value '
    print,'		[2] Get a value with the cursor '
    print,'		[3] Input an external value '
    print,'		[4] No rescale: memorize Eo '
    i_menu_e0  = getvalue('[Default=1] ? ',1)
    case i_menu_e0 of
     1: begin
          set1(0,*) = set1(0,*) - e0
          e0_saved = e0
          e0 = 0
          printf,Unit,';'
          printf,Unit,'; rescale Energy'
          printf,Unit,';'
          printf,Unit,'set1(0,*) = set1(0,*) - ',e0_saved
          title_str.x='E-'+strcompress(e0_saved,/rem)+' [eV]'
        end
     2: begin
          e0 = gete0(set1,method=1)
          print,' The selected Eo is: ',e0
        end
     3: begin
          print,' Input the value of Eo ? '
          read,e0
        end
     4: print,' Eo stored is : ',e0
    endcase
endrep until ((i_menu_e0 eq 1) or (i_menu_e0 eq 4))
;
; Pre edge ----------------------------------------------------
;
print,'**************************  Pre edge  *********************'
repeat begin
  plotset,set1,tit_str=title_str
  x1=min(set1(0,*))    &    x2=e0-20.
  plotset,[[x1,-1e5],[x1,1e5]],/over
  plotset,[[x2,-1e5],[x2,1e5]],/over
  print,' Selected limits by default for the Pre-edge fit are:'
  print,'      ['+strcompress(x1,/rem)+','+strcompress(x2,/rem)+']'
  i_yes = getyesornot(' Do you want to change these values ? [n]')
  if i_yes then begin
    plotset,set1,tit_str=title_str
    gettwoabscissas,x1,x2
  endif
  ;
  print,' Please select method for pre-edge fit: '
  print,'		[1] Polynomial Least-Square fit'
  print,'		[2] Polynomial Singular Value Decomposition'
;  print,'		[3] Victoreen fit'
  method =  getvalue('[Default=1] ? ',1)
  ;
  if ((method eq 1) or (method eq 2)) then begin
    degree =  $
     getvalue(' Please give me the degree of the polynomial [Default=1] ? ',1)
  endif
  fitset,set1,fit1,method=method,degree=degree,xrange=[x1,x2]   ;,/verbose
  plotset,fit1,/over
  print,' Please, select: '
  print,'		[0] cancel and continue'
  print,'		[1] select new limits and repeat fitting '
  print,'		[2] Substract fit from spectrum          '
  i_menu_pre =  getvalue('[Default=2] ? ',2)
  case i_menu_pre of
   0: begin
        set2 = set1
        printf,Unit,'set2 = set1'
      end
   2: begin
        set2 = set1  
        set2(1,*)=set1(1,*)-fit1(1,*)
        title_str.y=' !S !4l - l !I!3backg !R             [arb units]'
        ; log file
        printf,Unit,';' 
        printf,Unit,'; preedge fitting'
        printf,Unit,';' 
        printf,Unit,'fitset,set1,fit1,method='+strcompress(method,/rem)+ $
         ',degree='+strcompress(degree,/rem)+',xrange=['+    $
         strcompress(x1,/rem)+','+strcompress(x2,/rem)+']'
        printf,Unit,'set2 = set1'
        printf,Unit,'set2(1,*)=set1(1,*)-fit1(1,*)' 
      end
   else: print,' error in input '
  endcase
endrep until (i_menu_pre ne 1)
plotset,set2,tit_str=title_str
;
; Post-edge ----------------------------------------------------
;
print,'*************************  Post edge  *********************'
i_scale_k = getyesornot(' Do you want to change the E scale to k ?  [y/n] ')
if (i_scale_k eq 1) then begin
  set2=e2k(set2,e0=e0)
  title_str.x='k (A!S!E-1!R  )'
  plotset,set2,tit_str=title_str
  printf,Unit,'set2=e2k(set2,e0='+strcompress(e0)+')'
endif
;
BACKTOSPLINE:
repeat begin
  postedge,set2,fit2,unit=unit,/NOMOUSE
  plotset,fit2,/over
    repeat begin
      print,' Analysis of the splines(atomic absorption). Please select: '
      print,'		[0] Cancel and continue'
      print,'		[1] Zoom the signal and splines'
      print,'		[2] Show 1st and 2nd derivatives of the splines'
      print,'		[3] Fourier Transform of the splines'
      i_spline = getvalue('[Default=0] ? ',0)
      case i_spline of
       0:
       1: zoomset,set2,fit2
       2: begin
            derivset,fit2,plot=2
          end
       3: begin
            settmp=e2k(fit2,e0=e0)
            ftrset,settmp,/inquire,windpar=1.5,/plotfourier
          end
      endcase
    endrep until (i_spline eq 0)
    i_yes=getyesornot(' Do you want to repeat the spline ? [y/n] ') 
  if i_yes then plotset,set2,tit_str=title_str
endrep until (i_yes ne 1)
;
; Normalization ----------------------------------------------------
;
cutset,set2,set22,xrange=[0.,1e5]
cutset,fit2,fit22,xrange=[0.,1e5]
printf,Unit,';'
printf,Unit,'; normalization'
printf,Unit,';'
printf,Unit,'cutset,set2,set22,xrange=[0.,1e5]'
printf,Unit,'cutset,fit2,fit22,xrange=[0.,1e5]'
;
if (i_scale_k eq 1) then begin         ; use E scale (mandatory)
  set22 = k2e(set22)
  fit22 = k2e(fit22)
  printf,Unit,'set22 = k2e(set22)'
  printf,Unit,'fit22 = k2e(fit22)'
endif
;
print,' Please, enter the kind of normalization you want: '
print,' [1] experimental {chi(E)=(mu(E)-mu_at(E))/(mu_at(E)-mu_bck(E)) } '
print,' [2] constant     {chi(E)=(mu(E)-mu_at(E))/jump} '
print,' [3] Lengeler-Einsenberg  {chi(E)=(mu(E)-mu_at(E))/jump*LE(E) '
print,'                          with LE(E) = 1- (8/3) [(E-Eo)/Eo]  }'
i_menu_nor =  getvalue('[Default=2] ? ',2)
; 
; if i_menu_nor is 2 or 3, calculate jump
;
if ((i_menu_nor eq 2) or (i_menu_nor eq 3)) then begin
print,$
'********************* Jump **********************************'
  jump = getjump(set2,/nomouse)
  printf,Unit,'jump =',jump
endif
;
; if i_menu_nor is 3 we mandatory need the e0 different from 0
;
e0leng=e0
if ((e0 eq 0) and (i_menu_nor eq 3)) then begin
  set22(0,*) = set22(0,*) + e0_saved
  fit22(0,*) = fit22(0,*) + e0_saved
  e0leng = e0_saved
  ;
  printf,Unit,'set22(0,*) = set22(0,*) + e0_saved'
  printf,Unit,'fit22(0,*) = fit22(0,*) + e0_saved'
endif
;
printf,Unit,'e0leng =',e0leng
;
; now the normalization, where 
; mu = set22 ,  mu_at = fit22  and  mu_bkc=0 (already substracted)
;
printf,Unit,' set3 = set22'
printf,Unit,' set3 = set22'
set3 = set22
case i_menu_nor of
 1: begin
     set3(1,*)  = (set22(1,*)  - fit22(1,*) ) / fit22(1,*)
     printf,Unit,'set3(1,*)  = (set22(1,*)  - fit22(1,*) ) / fit22(1,*)'
    end
 2: begin
     set3(1,*) = (set22(1,*) - fit22(1,*)) / jump
     printf,Unit,'set3(1,*) = (set22(1,*) - fit22(1,*)) / jump'
    end
 3: begin
     print,' Eo = ',e0leng
     for i=0,n_elements(set22(0,*))-1 do begin
       set3(1,i) = (set22(1,i) - fit22(1,i)) / jump / $  
                   (1. - (8./3.)*(set22(0,i)-e0leng)/e0leng)
     endfor
     ;
     printf,Unit,'for i=0,n_elements(set22(0,*))-1 do begin'
     printf,Unit,' set3(1,i) = (set22(1,i) - fit22(1,i)) / jump / $'
     printf,Unit,'             (1. - (8./3.)*(set22(0,i)-e0leng)/e0leng)'
     printf,Unit,'endfor'
    end
endcase
set4 = e2k(set3,e0=e0leng)
printf,Unit,'set4 = e2k(set3,e0=e0leng)'
plotset,set4,xrange=[0.,max(set4(0,*))],yrange=[-.2,.2],$
 ytitle='!4v!3',xtitle='k (A!S!E-1!R  )',title=title_str.top
plotset,[[-100,0],[100,0]],/over
repeat begin
;
; Last things ----------------------------------------------------------
;
  print, ' Please select : '
  print,'		[0] Repeat spline and normalization '
  print,'		[1] Write the exafs (not weighted) in a file'
  print,'		[2] Plot the exafs with a selected weight '
  print,'		[3] Perform the Fourier Transform '
  print,'		[4] Show the Cumulative Distribution Function (CDF)'
  print,'		[5] End and exit  '
  i_menu_end = getvalue('[Default=5] ? ',5)
  case i_menu_end of
   0: begin
        plotset,set2,tit_str=title_str
        goto,BACKTOSPLINE
      end
   1: begin
        fileout = 'cnpick.out'
        fileout = $
         getvalue(' Name for the output file [Default=cnpick.out] ? ',fileout)
        writeset,set4,fileout
        printf,Unit,';' 
        printf,Unit,'; write output file'
        printf,Unit,';' 
	printf,Unit,"fileout = '"+strcompress(fileout,/rem)+"'"
        printf,Unit,'writeset,set4,fileout'
      end
   2: begin
        kpower = getvalue(' Give me the power of the K [Default=1] ? ',1)
        set5 = set4
        set5(1,*) = set4(1,*)*set4(0,*)^kpower
        plotset,set5,xrange=[0.,max(set5(0,*))], $
         ytitle='!4v!3(k).k!S!E'+strcompress(kpower,/rem)+'!R', $
         xtitle='k (A!S!E-1!R  )',title=title_str.top
        plotset,[[-100,0],[100,0]],/over
      end
   3: begin
        ftrset,set4,settmp,/inquire,/plotfourier,/plotwindow,  $
         windpar=1.5
      end
   4: begin
        !p.position = [0.05,0.55,0.95,0.95]
        kpower = getvalue(' Give me the power of the K [Default=1] ? ',1)
        set5 = set4
        set5(1,*) = set4(1,*)*set4(0,*)^kpower
        plot,set5(0,*),set5(1,*),xrange=[0.,max(set5(0,*))]
        plotset,[[-100,0],[100,0]],/over
        print,' Please, click the extrema of the integration: First point ? '
        cursor,x1,y1,3
        plotset,[[x1,-1000000],[x1,1000000]],/over
        print,'                                               Last point ? '
        cursor,x2,y2,3
        plotset,[[x2,-1000000],[x2,1000000]],/over
        integral_val = integset(set5,settmp,xrange=[x1,x2])
        !p.position = [0.05,0.05,0.95,0.45]
        plot,settmp(0,*),settmp(1,*),/noerase,xrange=[0.,max(set5(0,*))]
        plotset,[[-100,0],[100,0]],/over
        print,' Value of integrated spectrum is: ',integral_val
        !p.position = 0
     end
   5: 
  endcase
endrep until (i_menu_end eq 5)
;
; end prenpi --------------------------------------------------
;
printf,Unit,'end'
free_lun,Unit
print,'*************************************************************'
print,'*                                                           *'
print,'*                 Thanks for using cnpick                   *'
print,'*           (c) MSR, ESRF Programming Group (1993)          *'
print,'*                                                           *'
print,'*************************************************************'
end
