;
;========================================================================
;

PRO xaid_mu2chi_defaultparms,wid

;+
; PRO xaid_mu2chi_defaultparms,wid
; 
; Set default parameters (data must be loaded)
;
; 2009-05-13 srio@esrf.eu written.
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
  itmp = Dialog_Message(/Error, $
    !error_state.msg)
  Catch, /Cancel
  RETURN
ENDIF

IF Widget_Info(wid,/Valid_Id) NE 1 THEN BEGIN
  message,'Invalid input parent id: '+StrCompress(wid)
ENDIF
Widget_Control,wid, Get_UValue=state

;widget_control,state.wids.abscissas,Set_Value=0
;widget_control,state.wids.ordinates,Set_Value=0

set1 = *(state.ptr)
IF N_Elements(set1) LE 2 THEN BEGIN
  Message,'Please load data'
ENDIF
;
; Default Eo, Emin, Emax 
;

e0 = gete0(set1,/sort)
widget_control,state.wids.e0,set_value=e0
widget_control,state.wids.preMin,set_value=min(set1[0,*])+state.str.eStart
widget_control,state.wids.preMax,set_value=e0-state.str.eEnd


; 
; Default Jump
;

jump = getjump(set1,Dialog_Parent=wid,/NoPlot)
widget_control,state.wids.jump,set_value=jump

;
; 
;
set2 = e2k(set1,e0=e0)
widget_control,state.wids.npol,get_value=npol
aa = makearray1(npol+1,2,max(set2[0,*]),/Fix)
widget_control,state.wids.knots,set_value=vect2string(aa)


; 
; update plot etc
;
;
;widget_control,state.wids.abscissas,Set_Value=2
;widget_control,state.wids.ordinates,Set_Value=8
;xaid_mu2chi_plot,wid,/reset

END

