PRO writeset,set,file
;+
; NAME:
;	ROUTINE_NAME
;
; PURPOSE:
;	This procedure writes a set of data in the specified file
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	WRITESET, set, 'filename'
;
; INPUTS:
;	set:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Creates or overwrites a file.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		WRITESET,set,'exit.out'
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993	Any additional mods get described here. 
;-
on_error,2
;
; writes a set to a file
;
openw,Unit,file,/get_lun
printf,Unit,set
free_lun,Unit
;print, n_elements(set(0,*)), ' lines written in the file: ',file
message,/info, strcompress(n_elements(set(0,*)),/rem)+ $
  ' lines written in the file: '+file
return
end
