PRO POSTEDGE,setin,fit,unit=unit, nomouse=nomouse, DeliaId=deliaId, group=group, $
	Dialog_Parent=dialog_parent
;+
; NAME:
;	POSTEDGE
;
; PURPOSE:
;	This procedure calculates the post edge fit of a xafs spectrum
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	POSTEDGE,setin,setfit
;
; INPUTS:
;	setin:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;       UNIT: File unit where to write the log stuff.
;       NOMOUSE: when set, uses ASCII terminal dialog, otherwise uses
;               widget dialogs.
;	DIALOG_PARENT: this keyword is passed to dialogs for centering
;		the widget with a parent widget.
;
; OUTPUTS:
;	setfit: fltarr(2,npints) set with the fit
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward. Interaction with the user, and, mainly
;	a driver for POLSPL
;
; EXAMPLE:
;
;		POSTEDGE, set1, fit1
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;       96-08-13 MSR (srio@esrf.fr) changes wmenu->wmenu2 and
;               xtext->widget_message
;	98-10-01 srio@esrf.fr adapts for delia.
;	00-02-12 MSR (srio@esrf.fr) adds Dialog_Parent keyword
;-
;
on_error,2
;
fit=0
set2 = setin
xl = dblarr(10)  &  xh = dblarr(10)  & c = dblarr(36)
nc=dblarr(10)
;
if keyword_set(nomouse) then begin
  print,' Please select for the post-edge multi-polynomial spline: '
  print,' [0] default option: 3 pols, degree=3, equi-spaced'
  print,' [1] user selected # of pols and degrees. Hand typing selection'
  print,' [2] user selected # of pols and degrees. Mouse selection '
  i_menu = getvalue('[Default=0] ? ',0)
endif else begin
  options = ['default option: 3 pols, degree=3, equi-spaced', $ ;option 0
	'user selected # of pols and degrees. Hand typing selection', $
	'user selected # of pols and degrees. Mouse selection', $
	'Please select for the post-edge multi-polynomial spline: ']
  ;i_menu = wmenu(options,title=3)
  i_menu = wmenu2(options(0:2),Dialog_Parent=dialog_parent)
endelse
;
case i_menu of
  ;
  ; default spline
  ;
 0: begin
  x1 = min(set2(0,*))   &   x2=max(set2(0,*))
  print,'Minimum and maximum values of the current spectrum are: '
  print,'  ['+strcompress(x1,/rem)+','+strcompress(x2,/rem)+']'
  if not(keyword_set(nomouse)) then begin
    tmp = { x1:x1, x2:x2 }
    XscrMenu,tmp,/NoType,Titles=['Minimum','Maximum'], $
      Wtitle='Spline limits:',Action=Action, $
      Dialog_Parent=dialog_parent
    if Action NE 'DO' then return
    x1 = tmp.x1 & x2=tmp.x2 
  endif else begin
    x1 = getvalue(' Input minimum value for the spline [Default=0.0] ? ',0.0)
    x2 = getvalue(' Input maximum value for the spline [Default='+ $
     strcompress(x2,/rem)+'] ? ',x2)
  endelse
  xrange=[x1,x2]
  ;i_yes=getyesornot('Do you want to change these values ? [y/n]')
  ;if (i_yes eq 1) then begin
  ;  print,'Input min and max'
  ;  read,xrange
  ;endif
  ;
  nr = 3
  xl(1) = xrange(0)
  xh(3) = xrange(1)  
  nc(1:3) = 4                         ; polinom degree + 1
  step = (xh(3)-xl(1))/3.
  for i=1,2 do begin
    xl(i+1) = xl(i) + step
    xh(i)   = xl(i+1)
  endfor
 end
;
; user defined spline (hand-typing selection)
;
 1: begin
  if keyword_set(nomouse) then begin
    print,' How many intervals of the spline ? '
    read,nr
    print,' Please, input the extrema of the intervals ? '
    for i=1,nr+1 do begin
      read,xll
      xl(i) = xll
    endfor
    print,' Please, input the degree of polynomials : '
    for i=1,nr do begin
      print,' polynomial ',i,' = ? '
      read,ncc
      nc(i) = ncc
    endfor
  endif else begin
   tmp = { nr:3 }
   XscrMenu,tmp,/NoType,Titles=['Number:'], $
      Wtitle=' How many intervals of the spline ? :',Action=Action, $
      Dialog_Parent=dialog_parent
   if Action EQ 'DONT' then return
   nr = tmp.nr
   x1 = min(set2(0,*))   &   x2=max(set2(0,*))
   ;cuts = findgen(tmp.nr+2)/float(tmp.nr+1)
   cuts = findgen(tmp.nr+1)/float(tmp.nr)
   cuts = cuts*(x2-x1) + x1
   textcuts = vect2string(cuts)
   coeffs = indgen(nr)*0+2
   textcoeffs = vect2string(coeffs)
   tmp = { cuts:textcuts, coeffs:textcoeffs }
   XscrMenu,tmp,/NoType,Titles=['Intervals:','Coefficients:'], $
      Wtitle=' Interval limits:',Action=Action,fieldlen=60, $
      Dialog_Parent=dialog_parent
   if Action EQ 'DONT' then return
   ioerr = execute('xl = [0.,'+tmp.cuts+']')
   ioerr = execute('nc = [0,'+tmp.coeffs+']')
  endelse
  ;
  for i=1,nr do begin
    xh(i) = xl(i+1)
    nc(i) = nc(i)+1
  endfor
 end
;
; user defined spline (mouse selection)
;
 2: begin
  if keyword_set(nomouse) then begin
    print,' How many intervals of the spline ? '
    read,nr
    print,' Please, click on the graph to select the ',$
	fix(nr+1),' points that defines the intervals' 
  endif else begin
    tmp = { nr:3 }
    XscrMenu,tmp,/NoType,Titles=['Number:'], $
      Wtitle=' How many intervals of the spline ? :',Action=Action, $
      Dialog_Parent=dialog_parent
    if Action EQ 'DONT' then return
    nr = tmp.nr
;   Xtext, text=['Please, click on the','graph to select the',$
;	strcompress(fix(nr+1),/rem)+' points that','defines the intervals']
    itmp = Dialog_Message(/info,Dialog_Parent=group,$
	['Please, click on the graph to select the',$
	strcompress(fix(nr+1),/rem)+' points that','define the intervals'])
  endelse
  for i=1,nr+1 do begin
    cursor,xll,yll,3
    plotset,[xll,yll],/over,psym=1
    print,' selected point is : ',xll,yll
    xl(i) = xll
  endfor
  if keyword_set(nomouse) then begin
    print,' Please, input the degree of polynomials : '
    for i=1,nr do begin
      print,' polynomial ',i,' = ? '
      read,ncc
      nc(i) = ncc
    endfor
  endif else begin
    coeffs = indgen(nr)*0+2
    textcoeffs = vect2string(coeffs)
    tmp = { coeffs:textcoeffs }
    XscrMenu,tmp,/NoType,Titles=['Coefficients:'], $
       Wtitle=' Polynomial coefficients:',Action=Action, $
      Dialog_Parent=dialog_parent
    if Action EQ 'DONT' then return
    ioerr = execute('nc = [0,'+tmp.coeffs+']')
  endelse
  ;
  for i=1,nr do begin
    xh(i) = xl(i+1)
    nc(i) = nc(i)+1
  endfor
 end
;
endcase
;
; present intervals
;
xrange = [xl(1),xh(nr)]

if type(deliaId) EQ 8 then begin
  widget_control,deliaId.chi.Npol,set_value=strcompress(nr)
  widget_control,deliaId.chi.Degree,set_value=vect2string(fix(nc[1:nr])-1)
  widget_control,deliaId.chi.knots,set_value=vect2string([xl[1:nr],xh[nr]])
endif
cutset,set2,set22,xrange=xrange
if not(keyword_set(nomouse))  then begin
  text=' Number of fitting points: '+strcompress(n_elements(set22(0,*)))
  text=[text,strcompress(nr,/rem)+' polynomials used for fitting: ',$
  '   #      degree    min             max    ']
  for i=1,nr do text=[text,'   '+strcompress(i,/rem)+'      '+$
	strcompress(fix(nc(i)-1),/rem)+'      '+$
	strcompress(xl(i),/rem)+'      '+$
	strcompress(xh(i),/rem) ]
  xdisplayfile1,TITLE='Multispline Info', TEXT=text, $
    WIDTH=max(strlen(text)), HEIGH=n_elements(text),/noscroll, $
    Dialog_Parent=dialog_parent
endif else begin
  print,' Number of fitting points: ',n_elements(set22(0,*))
  print,nr,' polynomials used for fitting: '
  print,'    #             degree          min          max    '
  for i=1,nr do print,i,nc(i)-1,xl(i),xh(i)
endelse
;
; call spline
;
npts = n_elements(set22(1,*))
w=fltarr(npts+1)
w=w*0.0+1.0
xx=fltarr(npts+1)  &  yy = fltarr(npts+1)
xx(1:npts)=set22(0,*)  &  yy(1:npts)=set22(1,*)
;
polspl,xx,yy,w,npts,xl,xh,nr,c,nc
;
; log file
;
if keyword_set(unit) then begin
  printf,Unit,';'
  printf,Unit,'; polynomial spline'
  printf,Unit,';'
  printf,Unit,'xrange = [',xl(1),',',xh(nr),']'
  printf,Unit,'cutset,set2,set22,xrange=xrange'
  printf,Unit,'npts = n_elements(set22(1,*))'
  printf,Unit,'w=fltarr(npts+1) & xx=fltarr(npts+1)  &  yy = fltarr(npts+1)'
  printf,Unit,'w=w*0.0+1.0'
  printf,Unit,'xx(1:npts)=set22(0,*)  &  yy(1:npts)=set22(1,*)'
  ;
  printf,Unit,'xl = [ $ '
   for i=0,n_elements(xl)-2 do printf,Unit,xl(i),',$' & $
                               printf,Unit,xl(n_elements(xl)-1),' ]'
  ;
  printf,Unit,'xh = [ $ '
   for i=0,n_elements(xh)-2 do printf,Unit,xh(i),',$' & $
                               printf,Unit,xh(n_elements(xh)-1),' ]'
  ;
  printf,Unit,'nc = [ $ '
   for i=0,n_elements(nc)-2 do printf,Unit,nc(i),',$' & $
                               printf,Unit,nc(n_elements(nc)-1),' ]'
  ;
  printf,Unit,'nr =',nr
  printf,Unit,'polspl,xx,yy,w,npts,xl,xh,nr,c,nc'
  printf,Unit,'polspl_evaluate,set2,xl,xh,c,nc,nr,fit2'
endif
;
polspl_evaluate,set2,xl,xh,c,nc,nr,fit
;
return
end
