FUNCTION nrbmakeellipsoid, p=p,q=q,a=a,b=b,angle=alpha,ll=ll,ww=ww

;+
;
; FUNCTION nrbmakeellipsoid, p=p,q=q,a=a,b=b,alpha=alpha,ll=ll,ww=ww
;
; ARGUMENTS
;
;   ANGLE  = Grazing incident angle [rad]
;   LL = longitudinal aperture (chord, default = 10)
;   WW = transversal aperture (chord, default = 5)
;
;   Define either: 
;   P  = distance source-mirror
;   Q  = distance mirror-image
;   or: 
;   A  = semimajor axis
;   B  = semiminor axis
;
; OUTPUT
;
;   MIRR = a NURBS structure of a revolution ellipsoid, centered
;          correctly to be used as a mirror. 
;-

IF n_elements(p) EQ 0 THEN p=3000d
IF n_elements(q) EQ 0 THEN q=1000d
IF n_elements(alpha) EQ 0 THEN alpha=5d-3


IF n_elements(a) EQ 0 AND n_elements(b) NE 0 THEN Message,'Wrong input: missing a.'
IF n_elements(a) NE 0 AND n_elements(b) EQ 0 THEN Message,'Wrong input: missing b'

IF n_elements(a) EQ 0 THEN BEGIN ; existence of b is not checked
  a = (p + q)/2
  b = sqrt(p*q)*sin(alpha)
ENDIF ELSE BEGIN
  IF a LT b THEN Message,'Bad input. It must be a>b.'
  discr = a*a - b*b/sin(alpha)^2
  IF discr LT 0 THEN message,'Impossible ellipse for inputs. '
  p = a + sqrt(discr)
  q = a - sqrt(discr)
ENDELSE

;IF n_elements(b) EQ 0 THEN b = sqrt(p*q)*sin(alpha)

IF n_elements(ll) EQ 0 THEN ll=700d
IF n_elements(ww) EQ 0 THEN ww=10D

elp=__nrbelliptical_arch(p=p,q=q,alpha=alpha,ll=ll,x=x, y=y)

;nrbplot, elp,100

rr=abs(y)  ; sagittal radius

IF ww GT rr THEN BEGIN 
  message, 'The width was changed to the maximum possible value:'+string(abs(y))+'cm',/continue
  ww=rr
ENDIF

alpha_ww = asin(ww/2D0/rr)
elp_mirr = __nrbrevolve(elp,pnt=[x,0d,0d],vec=[1d,0d,0d],theta=2D*alpha_ww)

matx = vecrotx(!dpi/2-alpha_ww) ;rotation matrix around the x axis

y1 = b*x/a/sqrt(a^2-x^2) ; derivative, i.e., tangent to pole
rotang=atan(y1)
maty = vecroty(rotang) ; rotation matrix around the y axis

matz=vecrotz(!dpi/2d) ; rotation matrix around the z axis

; translation
matrans = vectrans([-x,rr*cos(alpha_ww),rr*sin(alpha_ww)])


elp_mirr = nrbtransform(elp_mirr,matz##maty##matx##matrans)

return,elp_mirr

END
