;+ 
;
; testnurbs1: test a simple spherical NURBS from primitive
;
;   i) creates a NURBS sphere
;   ii) tests evaluated points
;-


;
; i) creates a NURBS sphere
;
print,'i) creates a NURBS sphere'
lx=100D0
ly=400D0
rr = 10d2 ; in cm
nx=10
ny=20
;
n1=spherical_mirr(rr,ll=ly/2,ww=lx/2)
n1=spherical_mirr(rr,ll=rr,ww=rr)

nrbplot,n1,nx,ny

;
; ii) tests evaluated points 
;

uu = MakeArray1(nx)
vv = MakeArray1(ny)

for j=0L,ny-1 do begin
  for i=0L,nx-1 do begin
    c = nrbeval(n1,uu[i],vv[j])
    print,'  '
    m = min([(rr-Sqrt(rr^2-c[0]^2-c[1]^2)),(rr+Sqrt(rr^2-c[0]^2-c[1]^2))])
    print,i,j,c[2]-m
  endfor
endfor

END
