function nrbextrude,curve,vector
;//
;// Function Name:
;//
;//   nrbextrude - Construct a NURBS surface by extruding a NURBS curve.
;//
;// Calling Sequence:
;//
;//   srf = nrbextrude(crv,vec);
;//
;// Parameters:
;//
;//   crv     : NURBS curve to extrude, see nrbmak.
;//
;//   vec     : Vector along which the curve is extruded.
;//
;//   srf     : NURBS surface constructed.
;//
;// Description:
;//
;//   Constructs a NURBS surface by extruding a NURBS curve along a defined
;//   vector. The NURBS curve forms the U direction of the surface edge, and
;//   extruded along the vector in the V direction. Note NURBS surfaces cannot
;//   be extruded.
;//
;// Examples:
;//
;//   Form a hollow cylinder by extruding a circle along the z-axis.
;//
;//   srf = nrbextrude(nrbcirc, [0,0,1]);

;//  D.M. Spink
;//  Copyright (c) 2000.

IF n_elements(curve.dim) EQ 2 THEN BEGIN
  message,'Nurb surfaces cannot be extruded!'
ENDIF

IF n_params() LT 2 THEN BEGIN
  message,'Not enough arguments!'
ENDIF

a=vectrans(vector)##curve.coefs
coefs = [[[curve.coefs]],[[a]]]
srf = nrbstruct(coefs,curve.uknots, [0d,0d,1d,1d])

return, srf
END