
FUNCTION intermincalc,n1=n1,verbose=verbose

;+
;
; FUNCTION intermincalc,n1=n1,verbose=verbose
;
; Calculates the intersection of a ray (_x0,_v0) with a surface
; (NURBS: _n0) using a minimization algorithm. 
;
;
; Inputs (passed in COMMON block): 
;   NURBS surface:
;      _n0
;   Ray:
;      _x0 (input) is the starting point of the ray
;      _v0 (input) is the ray direction
;
;
; Outputs: 
;   The function returns (x,y,z) of the intersection point
;   n1: Keeyword to receive the normal to the surface at the interception point
;
; Keywords:
;   verbose: if set, it displays some info
;
; 
;-


; common variables for intersection using minimization
COMMON intermin, _n0, _x0, _v0  
COMMON intermin1, minxy, maxxy

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   ;if sdep(/w) then itmp = Dialog_Message(/Error,$
   ;     'NURBS: interMinCalc: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   n1=[0D,0,1]
   RETURN,[0D,0,0]
endif

epsilon=1d-8  ; for numerical evaluation of derivative
ftol=1d-5


;
; Intersection of a ray defined by straight line defined by 
; a point and a direction:  x=x0+t*v0
; with a NURBS surface 
; 
; USING A NUMERICAL METHOD: Minimization of the distance from a point in
; the surface to the straight line

;n1=[0D,0,0]

;find the guess (solution of intersection of the ray with the plane z=0)
;
t0 = -_x0[2]/_v0[2]
xg = _x0+t0*_v0

; calculate z-guess:
xguess = xg[0:1]

;
; calculate approximated u=(u,v) corresponding at this xg
;
xg = Reform(_n0.xgrid[0,*])
yg = Reform(_n0.ygrid[*,0])

nxg = N_Elements(xg)
nyg = N_Elements(yg)

;uk = Reform(_n0.uknots)
;vk = Reform(_n0.vknots)
;
;uk = uk(Uniq(uk))
;vk = vk(Uniq(vk))

;u = interpol(uk,xg,xguess[0]>xg[0]<xg[nxg-1], $
;	spline=0,quadratic=0,lsquadratic=0) >0 <1
;v = interpol(vk,yg,xguess[1]>yg[0]<yg[nyg-1], $
;	spline=0,quadratic=0,lsquadratic=0) >0 <1

IF N_Elements(minxy) EQ 0 THEN BEGIN
  x1=min(xg,max=x2)
  y1=min(yg,max=y2)
  minxy=[x1,y1]
  maxxy=[x2,y2]
ENDIF

u = (xguess[0]-minxy[0])/(maxxy[0]-minxy[0])
v = (xguess[1]-minxy[1])/(maxxy[1]-minxy[1])

;u=0.5D
;v=0.5D


IF Keyword_Set(verbose) THEN print,'INTERMINCALC: Guess in (x,y),(u,v):  ',xguess,u,v
;print,'Guess in u:  ',u,v

; 
; calls the minimization function to minimise interminfom

xxx = transpose([ [1.,0],[0.,1] ])
x=[u,v]
powell,x,xxx,ftol,fmin,'interminfom',iter=iter,/Double
  IF Keyword_Set(verbose) THEN print,'INTERMINCALC: Powell iterations: ',iter

IF N_Elements(x) EQ 1 THEN BEGIN
  print,'INTERMINCALC: Minimization failed to converge'
  out=0
ENDIF ELSE BEGIN
  ;print,'Calling nrbeval with: ',x[0],x[1]
  znurbs = nrbdeval(_n0,x[0]>0<1,x[1]>0<1,jacob=jacob,dnrb=1)
  ;znurbs = nrbdeval(_n0,x[0],x[1],jacob=jacob,dnrb=1)
  out=[znurbs[0],znurbs[1],znurbs[2]]
ENDELSE

;
; calculate normal
; 

;; evaluate surface in u+epsilon, v+epsilon
;zuepsilon = nrbeval(_n0,(x[0]+epsilon)>0<1,x[1]>0<1)
;zvepsilon = nrbeval(_n0,x[0]>0<1,(x[1]+epsilon)>0<1)
;; calculate tangential vectors
;tx = Reform(zuepsilon[0:2]-out)
;ty = Reform(zvepsilon[0:2]-out)
;; cross product
;txty = [tx[1]*ty[2]-tx[2]*ty[1],tx[2]*ty[0]-tx[0]*ty[2],tx[0]*ty[1]-tx[1]*ty[0]]
;n1 = txty/ sqrt(Total(txty^2)) 

;n1 = crossp(jacob.jacu,jacob.jacv)
;n1 = -n1/norm(n1)
n1 = -vecproduct(Reform(jacob.jacu),Reform(jacob.jacv))

;itest=1
;IF itest THEN BEGIN
;  p=3000.0D  ; source-mirror
;  q=1000.0D  ; mirror-image
;  theta=5D-3 ; grazing angle, rad
;  radius=2D0*p*q/(p+q)/sin(theta)
;  tmp0 = intercept2(_x0,_v0,radius)
;  print,'Intercept: ',out
;  print,'     z exact=',radius-sqrt(radius^2-out[0]^2-out[1]^2)
;  print,'Exact value: ',tmp0
;  print,'n1: ',n1
;  ; norm is [0,0,R]-tmp0 (normalized)
;  normal55 = [0D,0,radius]
;  normal55 = normal55-tmp0
;  normal55 = normal55/norm(normal55)
;  print,'Exact n1: ',normal55
;  ;out=tmp0
;  ;n1=normal55
;ENDIF

RETURN,out
END

