; INTERNAL FUNCTION __NrbFindSpan()
; INPUT:
;   n     -  number of control points - 1
;   p     -  spline degree
;   u     -  parametric point
;   knots -  knot sequence
;
; RETURN:
;   s - knot span
;
; Algorithm A2.1 from 'The NURBS BOOK' pag. 68
;

FUNCTION __nrbfindspan,n,p,u,knots

  ; special case
IF u EQ knots[n+1] THEN BEGIN
   return, n
ENDIF ELSE BEGIN
  ; does binary search
  low = p
  high = n+1
  mid = (low + high)/2
  WHILE (u LT knots[mid] || u GE knots[mid+1]) Do BEGIN
    IF (u LT knots[mid]) THEN high = mid ELSE low = mid
    mid = (low + high) / 2
  ENDWHILE
  return,mid
ENDELSE



;
; alternative way (not fully tested, not necesarily faster!)
;
;IF u EQ knots[n+1] THEN RETURN,n ELSE BEGIN
;  itmp = where(knots LE u)
;  RETURN,itmp[N_Elements(itmp)-1]
;ENDELSE

END
