
;procedure to make graphics image of a mirror footprint, in the traditional
;way.
;
; MSR/95/06/09 add /noerase keyword
; srio@esrf.fr added _EXTRA=extra

pro cart_axes,xrange,yrange,position = position,physical = phys, $
  noerase = noerase,_EXTRA=extra

if not(keyword_set(position)) then begin
    position = [0.1,0.1,.925,.925]
endif
winsize = fltarr(4)
winsize(0) = !d.x_size
winsize(1) = !d.y_size
winsize(2) = winsize(0)
winsize(3) = winsize(1)
position = position*winsize

center =[total(xrange)/2,total(yrange)/2]
xmag = (position(2)-position(0))/(xrange(1) - xrange(0))
ymag = (position(3)-position(1))/(yrange(1) - yrange(0))
mag = min([ymag,xmag])

xplotrange = [center(0) - (position(2)-position(0))/(2*mag),center(0)$
	      +(position(2) - position(0))/(2*mag)]
yplotrange = [center(1) - (position(3)-position(1))/(2*mag),center(1)$
	      +(position(3) - position(1))/(2*mag)]
if keyword_set(phys) and !d.name eq 'PS' then begin
    xdevrange = position(2) - position(0)
    ydevrange = position(3) - position(1)
    xphysrange = xdevrange/(phys*100000)
    yphysrange = ydevrange/(phys*100000)
    xplotrange = [center(0)-xphysrange/2,center(0) + xphysrange/2]
    yplotrange = [center(1)-yphysrange/2,center(1) + yphysrange/2]
endif
plot,[0,1],[0,1],xrange = xplotrange, yrange = yplotrange,$
    xstyle = 1,ystyle = 1,position = position,/device,/nodata, $
    noerase=noerase,_EXTRA=extra
xrange = xplotrange
yrange = yplotrange
end



	



