pro  WRITEPAR_LAUE2, parameters,beamsize=beamsize,sample_depth=sample_depth,$
	dark_current=dark_current,boxsize=boxsize,gain=gain,bg_gain=bg_gain,$
	noise_percentage=noise_percentage,bg_max_slope=bg_max_slope,$
	satvalue = satvalue,$
	ovlp_dist=ovlp_dist,ovlp_min_dist=ovlp_min_dist,bc_extend=bc_extend,mode=mode
;+
; NAME:
;	WRITEPAR_LAUE2
;
; PURPOSE:
;
;	Write in the experimental parameters of a Laue experiment.
;
; CATEGORY:
;	Laue processing
;
; CALLING SEQUENCE:
;	WRITEPAR_LAUE2,parameters,beamsize=beamsize,sample_depth=sample_depth,$
;	dark_current=dark_current,boxsize=boxsize,gain=gain,bg_gain=bg_gain,$
;	noise_percentage=noise_percentage,$
;	bg_max_slope=bg_max_slope,$
;	ovlp_dist=ovlp_dist,ovlp_min_dist=ovlp_min_dist,$
;	bc_extend=bc_extend,mode=mode
;
; INPUTS:
;	parameters : the experimental parameters
;	beamsize : beamsize
;	sample_depth : sample depth
;	dark_current : dark_current in the detector
;	boxsize : boxsize for integration
;	gain : gain of the detector at 1.5418 A
;	bg_gain : gain of the detector at the wavelength of the background (for Laue)
;	noise_percentage : the percentage of the pixels in the integration 
;			box to be taken as background 
;	bg_max_slope : the maximum slope in background calculation.
;	satvalue : saturation value
;   	ovlp_dist : distance [mm] between spot centers, below which spots are considered overlapped
;   	ovlp_min_dist : distance [mm] between spot centers, below which spots are considered impossible
;				to deconvolute
;	bc_extend : the number of pixels that are added to the border of the spot regions in each sector
;		in order to get rid of signal in area used for bg calculation. Default = 2
;	mode : the integration mode, either 'laue' or 'mono'
;
; OUTPUTS:
;	the experimental parameters par are modified.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;	
; MODIFICATION HISTORY:
;	D.Bourgeois, June 1995, April 1997., March 1998.
;-

parameters=CREATE_STRUCT(parameters,'mode','mono')
IF N_ELEMENTS(noise_percentage) EQ 0 THEN noise_percentage = 25
IF N_ELEMENTS(bg_max_slope) EQ 0 THEN bg_max_slope = 100
IF N_ELEMENTS(beamsize) EQ 0 THEN beamsize = 0
IF N_ELEMENTS(gain) EQ 0 THEN gain = 1
IF N_ELEMENTS(bg_gain) EQ 0 THEN bg_gain = 1
IF N_ELEMENTS(dark_current) EQ 0 THEN dark_current = 0
IF N_ELEMENTS(sample_depth) EQ 0 THEN sample_depth = 0
IF N_ELEMENTS(boxsize) EQ 0 THEN boxsize = {x:16,y:16}
IF N_ELEMENTS(satvalue) EQ 0 THEN satvalue = 65535L
IF N_ELEMENTS(ovlp_dist) EQ 0 THEN ovlp_dist=0
IF N_ELEMENTS(ovlp_min_dist) EQ 0 THEN ovlp_min_dist=0
IF N_ELEMENTS(bc_extend) EQ 0 THEN bc_extend=2
IF N_ELEMENTS(mode) EQ 0 THEN mode='mono'
parameters.noise_percentage = noise_percentage
parameters.bg_max_slope = bg_max_slope
parameters.beamsize = beamsize
parameters.gain = gain
parameters.bg_gain = bg_gain
parameters.dark_current = dark_current
parameters.sample_depth = sample_depth
parameters.boxsize = boxsize
parameters.satvalue = satvalue
parameters.ovlp_dist = ovlp_dist
parameters.ovlp_min_dist = ovlp_min_dist
parameters.bc_extend=bc_extend
parameters.mode=mode
END


