pro WRITE_GEASC, filename, refl_arr 
;+
; NAME:
;	WRITE_GEASC
;
; PURPOSE:
;
; 	Modify a .geasc (ASCII format) file from the Laue suite CCP4
;
; CATEGORY:
;	File processing
;
; CALLING SEQUENCE:
;	WRITE_GEASC,filename,refl_arr ;
;
; INPUTS:
;	filename : the path name of the file to modify
;	refl_arr : the spotlist containing the new info 
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Follows the format of the original .geasc ASCII file
;	For each reflexion, the field to change is accessed and changed.
;
;	There is a Header containing some useful information, but tha we skip
;	in the reading. Then each reflection is described as a 
;	structure ( noted
;	"s") with some fields described in the following :
;	two fields are aded at the end : the angle 2 theta and the
;	 sin(theta)/lambda
;  	   h, k, l        The reflection indices
;	   x, y         Spot position on 'film' (mm from centre)
;	   lambda         Wavelength (Angstroms)
;  	   mult           Multiplicity
;	   nodal          Nodal flag (1=yes, 0=no)
;	   ovlp           Overlap flag (1=yes, 0=no)
;	   close          Close reflection flag (1=yes, 0=no)
;	   h2, k2, l2     Nodal indices (for multiple reflection)
;	   nidx           Nodal spot selection index
;	   lambda2        Second lambda for a double (otherwise 0.0)
;	   ipoint         Pointer to .ge2 file for a multiple (>2)
;	   dminth         Dmin threshold squared for next harmonic
;	   intb(6)        Box integrated itensities for 6 films
;	   isigb(6)       Sigmas for the above
;	   intp(6)        Profile fitted integrated intensities for 6 films
;	   isigp(6)       Sigmas for the above
;	   *              An asterisk indicates the end of the reflection
;	   tth (added)	  2 theta
;	   res (added)	  0.5*lambda/sin(theta) (give the position of 
;			  resolution sphere for lambda< 2*(actual)*lambdaRes
;
; MODIFICATION HISTORY:
;	D.Bourgeois, April 1994.
;-

;on_error,2                              ;Return to caller if an error occurs

star = '*'

;open the file 
OPENW,1,filename+'.geasc'
PRINT,'Writing .geasc file ...'

;Read the header :
refl_number = (SIZE(refl_arr))(1)


PRINTF,1,FORMAT='(A17,I5,A12)','REFLECTION DATA  ',refl_number,' REFLECTIONS'


FOR index=LONG(0),refl_number-1 DO BEGIN


 PRINTF,1,		$
 refl_arr(index).m, 	$
 refl_arr(index).x,	$
 refl_arr(index).y,	$
 refl_arr(index).l,	$
 refl_arr(index).mul,	$
 refl_arr(index).nodal,	$
 0,$
; refl_arr(index).overlap,$
 refl_arr(index).close,	$
 refl_arr(index).m2,	$
 refl_arr(index).nidx

 PRINTF,1,		$
 refl_arr(index).l2,	$
 refl_arr(index).ipoint,$
 refl_arr(index).dminth

 PRINTF,1,		$
 [FIX(refl_arr(index).intb(0)),-9999,-9999,-9999,-9999,-9999],	$
 [FIX(refl_arr(index).isigb(0)),-9999,-9999,-9999,-9999,-9999]

 PRINTF,1,		$
 [FIX(refl_arr(index).intp(0)),-9999,-9999,-9999,-9999,-9999],	$
 [FIX(refl_arr(index).isigp(0)),-9999,-9999,-9999,-9999,-9999],	$
 star

ENDFOR

;close the file
CLOSE,1
END

