pro WRITE_DENZOX, file, orig_file, refl,noyork=noyork 
;+
; NAME:
;	WRITE_DENZOX
;
; PURPOSE:
;
; 	Modify a DENZO .x (ASCII format) file.
;
; CATEGORY:
;	File processing
;
; CALLING SEQUENCE:
;	WRITE_DENZOX,file, orig_file, refl [,/NOYORK];
;
; INPUTS:
;	file : the path name of the file to modify
;	orig_file : the original DENZO .x file containing the header and tail.
;	refl : the reflection list containing the new info 
;	noyork : [optional] set this keyword if the YORK format is not used.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Follows the format of the original DENZO .x ASCII file YORK format.
;	For each reflexion, the fields to change are accessed and changed.
;
;	The Header and Tail are taken from the original DENZO file, since they are 
;	not modified in IDL.
;	The fields of interest for each reflection are :
;
;	M       INTARR(3) :The Miller indices h,k,l
;  	XPIX    FLOAT     : X position in image [raster]
;   	YPIX    FLOAT     : Y position in image [raster]
;  	INTP    FLTARR(6)  : Profile fitted integrated intensities for 6 films
;  	ISIGP   FLTARR(6)  : Sigmas for profile fitted integrated intensities for 6 films
;   	STRENGTH FLOAT     : Strength of average profile [arb units]
;   	CHISQUARE FLOAT    : chi_square of profile fitting in DENZO
;   	COSINE  FLOAT      : cosine of incidence angle at detector
;   	LP      FLOAT      : Lorentz polarization factor
;       PARTIALITY FLOAT   : Partiality [0=full ; 1=partial]
;   	PAR1    FLOAT      : Additional parameter (unknown) 1
;   	PAR2    FLOAT      : Additional parameter (unknown) 2
;
; MODIFICATION HISTORY:
;	D.Bourgeois, July 1996.
;-

;on_error,2                              ;Return to caller if an error occurs

;open the file 
OPENW,1,file
PRINT,'Writing .x file ...'

refl_number = (SIZE(refl))(1)
format = '(3I4,I2,2F8.1,F7.2,F6.1,F6.3,2F7.1,F6.3,F8.1,F6.3,F6.1)'
formatbig = '(3I4,I2,2I8,F7.2,I6,F6.3,2F7.1,F6.3,F8.1,F6.3,F6.1)'


FOR index=LONG(0),refl_number-1 DO BEGIN
IF  (refl(index).isigp(0)*refl(index).lp LE -1000.) OR (refl(index).isigp(0)*refl(index).lp GE 10000.) OR (refl(index).intp(0)*refl(index).lp LE -100000.) OR (refl(index).intp(0)*refl(index).lp GE 1000000.) THEN BEGIN

 PRINTF,1,FORMAT=formatbig,	$
 refl(index).m, 		$
 refl(index).partiality,	$
 (refl(index).intp(0)*refl(index).lp)<9999999.>(-999999.),		$
 refl(index).intb(1)<9999999.>(-999999.),		$
 refl(index).chisquare,		$
 (refl(index).isigp(0)*refl(index).lp)<99999.>(-9999.),		$
 refl(index).cosine,		$
 refl(index).xpix,		$
 refl(index).ypix,		$
 refl(index).lp,		$
 refl(index).strength,		$
 refl(index).par1,		$
 refl(index).par2

ENDIF ELSE BEGIN

 PRINTF,1,FORMAT=format,	$
 refl(index).m, 		$
 refl(index).partiality,	$
 refl(index).intp(0)*refl(index).lp,		$
 refl(index).intb(1)<999999.>(-99999.),		$
 refl(index).chisquare,		$
 refl(index).isigp(0)*refl(index).lp,		$
 refl(index).cosine,		$
 refl(index).xpix,		$
 refl(index).ypix,		$
 refl(index).lp,		$
 refl(index).strength,		$
 refl(index).par1,		$
 refl(index).par2

ENDELSE
ENDFOR

;close the file
CLOSE,1

;get the .x file with good header and tail
IF KEYWORD_SET(noyork) THEN $
SPAWN,'source '+STRTRIM(GETENV('PROW_SCR')+'merge_denzox.scr') + ' ' + orig_file + ' ' + file + ' noyork' ELSE $
SPAWN,'source '+STRTRIM(GETENV('PROW_SCR')+'merge_denzox.scr') + ' ' + orig_file + ' ' + file + ' york'

END

