function READ_LOGLDM, filename
;+
; NAME:
;	READ_LOGLDM
;
; PURPOSE:
;
; 	Read in an (ASCII) ".log" from the Lauegen program. 
;	Returns the initial and final RMS values from prediction refinement,
;	with the number of spots considered.
;
; CATEGORY:
;	File managing
;
; CALLING SEQUENCE:
;	par = READ_LOGLDM(filename) ;
;
; INPUTS:
;	filename : the path name of the file to process with extension
;
; OUTPUTS:
;	par : the structure array containing the results
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Par -->
;   NSTART	LONG  	  : the starting number of spots
;   NEND        LONG     : the ending number of spots
;   NCYCLE      SHORT   : the number of cycle in the refinement
;   RMSSTART    FLOAT     : the starting RMS value [um]
;   RMSEND      FLOAT     : the ending RMS value [um]
;
;
; MODIFICATION HISTORY:
;	D.Bourgeois, July 2004.
;-

;on_error,2                              ;Return to caller if an error occurs

par = { $
		nstart : 0L, $
		nend : 0L, $
		ncycle : 0, $
		rmsstart : 0.0, $
		rmsend : 0.0 $
       }


ncycle=0
nspots=0
rms=0.0

 ;open the 'log' file 
  ldmfile=FINDFILE(filename,COUNT=count)
  IF count EQ 1 THEN BEGIN
   line=''
   OPENR,lun,filename,/GET_LUN
   PRINT,'Reading .ldm file ...'
   WHILE (NOT EOF(lun)) DO BEGIN
    READF, lun, line
    IF (STRMID(line, 0, 3) EQ 'RMS') THEN BEGIN
     ncycle = ncycle+1
     subline = STRMID(line, 6, 6)
     READS,subline,FORMAT='(F7.3)',rms
     np = STRPOS(line, 'the ')
     subline = STRMID(line, np+3, 6)
     READS,subline,FORMAT='(I5)',nspots
     IF ncycle EQ 1 THEN BEGIN
	par.nstart=nspots
	par.rmsstart=rms*1000
     ENDIF
    ENDIF
   
   
   ENDWHILE
   FREE_LUN,lun

  IF ncycle EQ 0 THEN MESSAGE,'No refinement monitored in this logfile !'
  ENDIF ELSE MESSAGE,'Could not find .log file !'


par.ncycle=ncycle
par.nend=nspots
par.rmsend=rms*1000

RETURN,par
END

