FUNCTION READ_FORMATED_ASCII,name,format=format,n_elem=n_elem
;+
; NAME:
;	READ_FORMATED_ASCII
;
; PURPOSE:
;	Read in an text-file 
;
; CATEGORY:
;	Input
;
; CALLING SEQUENCE:
;   Result = READ_FORMATED_ASCII(name,format=format,n_elem=n_elem)
;
; INPUTS:
;	NAME: String containing the name of the xplor-file.
;	FORMAT : A string containing the FORMAT : Exemple : '(3I4,2F9.3,I3,I4,2F9.4)'
;	N_ELEM : The number of elements in one line of the file to be read : Exemple : 9
;
; OUTPUTS:
;	READ_FORMATED_ASCII returns a FLTARR
;
; SIDE EFFECTS:
;	A file is read.
;
; COMMENTS:
;	The number of reflections are limited by MAX_REF.
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois October 98.
;-

;on_error,2                      ;Return to caller if an error occurs

max_ref=50000
i=1L
cr = STRING("15b)


IF N_ELEMENTS(format) EQ 0 THEN MESSAGE,'You need to specify the format !'
IF N_ELEMENTS(n_elem) EQ 0 THEN MESSAGE,'You need to specify the number of elements per line !'

res = FLTARR(n_elem, max_ref)
oneres = FLTARR(n_elem)

i=0L

OPENR, file, name, /GET_LUN 

REPEAT BEGIN
 READF,file,format=format,oneres
 res(*,i)=oneres 
 i=i+1
 IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' line read',A)",i,cr
ENDREP UNTIL EOF(file)

PRINT,'Done !                '
PRINT,'Number of read reflexions : ',i

FREE_LUN, file

return, res(*,0:i-1)
error:
return,0
END 



