function SYS_AHK, m, cent, sg_no=sg_no, symmetry=sym, isys=isys, ksys=ksys
;+
; NAME:
;	SYS_AHK
;
; PURPOSE:
;	Determine if hkl is a systematic absence in this spacegroup
;	regardless of l. Uses only the centering type. For full test
;	see SYS_ABS.
;	Fastest to call with keyworded parameters SYMMETRY, ISYS and
;	KSYS (since only centering testing is done SYMMETRY might as well
;	only be a dummy SYMMETRY from the call "symmetry=READ_SYMMETRY(0)"). 
;
; CATEGORY:
;	Laue data processing, Crystallography
;
; CALLING SEQUENCE:
; 	result= SYS_AHK(m [,centering_no, sg_no=sg_no, symmetry=symmetry, $
;			isys=isys, ksys=ksys])
;
; INPUTS:
;	M: Array (INTARR(3,*)) of the Miller indices.
;	CENTERING_NO: Type of centering (integer):
;	    'P':	centering_no=1
;	    'A':   	centering_no=2
;	    'B':	centering_no=3
;	    'C':	centering_no=4
;	    'I':	centering_no=5
;	    'F':	centering_no=6
;	    'R':	centering_no=7
;
; KEYWORDED PARAMETERS:
;	SG_NO: Spacegroup number. If given then the centering is read
;		with READ_SYMMETRY. Either CENTERING_NO, SG_NO or SYMMETRY
;		must be given. 
;	SYMMETRY: Instead of giving SG_NO which is used to read a SYMMETRY
;		structure with READ_SYMMETRY the SYMMETRY structure itself
;		can be given. (Use "symmetry=READ_SYMMETRY(sg_no)")
;	ISYS, KSYS: See SET_LATT. If given then SET_LATT is not called.
;
; OUTPUTS:
;	Returns an one-dimensional array of integers set to one for 
;	the systematic absent reflections and zero for the rest.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;	From LDM.FOR (Daresbury Laue Software Suite).
;	(LDM_SET_LATT, LDM_SYSABS, LDM_SYSAHK)
;
; MODIFICATION HISTORY:
;	Written by Thomas Ursby, September 1995
;
;-

IF ((N_PARAMS() lt 2) and (not (KEYWORD_SET(sg_no) or KEYWORD_SET(sym))))$
	THEN MESSAGE,'No symmetry information given!'

IF (not KEYWORD_SET(sym)) THEN BEGIN
  IF KEYWORD_SET(sg_no) THEN BEGIN
    sym= READ_SYMMETRY(sg_no)
    cent= sym.centering_no
  ENDIF ELSE sym= READ_SYMMETRY(0)
ENDIF ELSE cent= sym.centering_no

; Get ISYS and KSYS. Variables used for determin what test on centering.
IF NOT KEYWORD_SET(isys) THEN $
  IF NOT KEYWORD_SET(ksys) THEN SET_LATT, cent, isys, ksys
absent= m(0,*)*0

IF (isys ne 0) THEN $
  IF (((isys eq 4) or (isys eq 2)) and (ksys(3) eq 0)) THEN $
    absent= (((m(0,*)+m(1,*)) MOD 2) ne 0)

RETURN, absent

END
