function GET_MONOF, laue,mono,mult=mult,laue_group=laue_group
;+
; NAME:
;	GET_MONOF
;
; PURPOSE:
;
;	Adds monochromatic SF amplitudes to a Laue data set. (The missing monochromatic
;	reflexions are set to a value corresponding to the median value of the registered monochromatic
;	reflexions.)
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	laue3 = GET_MONOF(laue,mono,mult=mult,laue_group=laue_group) ;
;
; INPUTS:
;	laue,mono : the structures to process. Laue must have the field
;		.intp(1) and mono must have the field .entry(0)
;	laue_group : the point group for the data. Look at 'symop.lib' to figure out your point group. 
;
; OUTPUTS:
;	laue3 : these are the singles of 'laue' modified with 'mono'+the multiples, unmodified. The mono SF amplitude are put in the field
;		.intp(1). For those Laue reflexions which have a counterpart monochromatic one, the median monochromatic 
;		SF is used instead. Those reflexions are listed at the end. 
;	mult : these are the doubles of 'laue' modified with 'mono'. 
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, October 97.
;	D.Bourgeois, March 99.
;-

;on_error,2                              ;Return to caller if an error occurs

;First sort the Laue data
PRINT,'Sorting Laue predictions ...'
SORT_MILLER,laue

IF N_ELEMENTS(laue_group) EQ 0 THEN laue_group=28

;Then select unique reflexions in that laue_group
PRINT,'Moving reflections to asymetric unit in point group : ',laue_group

m = laue.m
m_mono = mono.m
EQUIV_HKL,laue_group,m
EQUIV_HKL,laue_group,m_mono
laue2=laue
laue2.m=m
mono2=mono
mono2.m=m_mono

;Remove the reflections having zero SF mono amplitude
w_ok=WHERE(mono2.entry(0) GT 0,ct_ok)
IF ct_ok GT 0 THEN mono2=mono2(w_ok) ELSE MESSAGE,'All monochromatic SF are zero ! ...'
;Compute the median SF amplitude in mono
median_monof=MEDIAN(mono2.entry(0))
PRINT,'The median monochromatic SF amplitude is : ',median_monof

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;First do it with the singles
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&

w_singles=WHERE(laue2.mul EQ 1,ct_singles)
IF ct_singles GT 0 THEN BEGIN
 l2_s=laue2(w_singles)
 l_s=laue(w_singles)
ENDIF

;then load mono f in l2_s
PRINT,'Loading monochromatic f''s into laue singles ...'

h1 = l2_s.m(0) & k1 = l2_s.m(1) & l1 = l2_s.m(2)
h2 = mono2.m(0) & k2 = mono2.m(1) & l2 = mono2.m(2)

max_hkl = MAX([h1,k1,l1]) > MAX([h2,k2,l2])
min_hkl = MIN([h1,k1,l1]) < MIN([h2,k2,l2])

sf_table =  FLTARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1,max_hkl - min_hkl + 1)
sf_table(*) = median_monof
sf_table(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) = mono2.entry(0)
l2_s.intp(1)=sf_table(h1 - min_hkl,k1 - min_hkl,l1 - min_hkl)
;then load that into laue ... To match l_s and  l2_s, the best is
;to use the field .id

max_id=MAX(l_s.id)
l_s_id = FLTARR(max_id+1)
l_s_id(l2_s.id)=l2_s.intp(1)
w=WHERE(l_s_id NE 0,ct)
l_s_id=l_s_id(w)

s=SORT(l_s.id)
l3_s=l_s(s)
l3_s.intp(1)=l_s_id(s)

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;at this point, it is OK for the singles, but not for
;the multiples
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

w_mul=WHERE((laue2.mul GT 1) AND (laue2.mul LE 2),ct_mul)
dum=WHERE((laue2.mul GT 1),ct_mul_all)
mult=999 ; flag for saying there are no multiples to treat
IF ct_mul GT 0 THEN BEGIN
 PRINT,'Now dealing with multiples ...'
 PRINT,'Due to pb in Lauegen, only dealing with doubles ...'
 PRINT,'Found ',ct_mul,' doubles'
 PRINT,'Will ignore ',ct_mul_all-ct_mul,' triples, quadruples, etc ...'
 
 mult=laue2(w_mul) 

 max_m=MAX(mult.mul) ; should be 2 
 one_mult={id:0,l_m:FLTARR(max_m),m_m:INTARR(3,max_m),ii_m:FLTARR(max_m),res_m:FLTARR(max_m)}
 mult2=REPLICATE(one_mult,ct_mul) 
 mult2.id=mult.id

 ;in mult2 we put all the relevant miller indices and corresponding
 ;wavelengths
 PRINT,'Expanding wavelengths and Miller indices ...'
 cr = STRING("15b)
 FOR i=0,ct_mul-1 DO BEGIN
  IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' ie : ',F3.0,'%',A)",i,100.*i/FLOAT(ct_mul),cr
  a1=1/mult(i).l & a2=1/mult(i).l2
  n1 = a1/(a2-a1)
  l0 = 1/(a2-a1)
  res0 = n1*mult(i).res
  m0 = ROUND(mult(i).m/n1)
  FOR j=0,mult(i).mul-1 DO BEGIN
   mult2(i).l_m(j)=l0/(n1+j)
   mult2(i).res_m(j)=res0/(n1+j)
   mult2(i).m_m(*,j)=ROUND(m0*(n1+j))
  ENDFOR ; for each j
 ENDFOR ; for each i


  ; now we need to fill the mono f into mult2
  PRINT,'Loading monochromatic f''s into laue doubles ...'

   h1 = mult2.m_m(0,*) & k1 = mult2.m_m(1,*) & l1 = mult2.m_m(2,*)
;  h2 = mono2.m(0) & k2 = mono2.m(1) & l2 = mono2.m(2) ; already done in principle

  max_hkl = MAX([h1,k1,l1]) > MAX([h2,k2,l2])
  min_hkl = MIN([h1,k1,l1]) < MIN([h2,k2,l2])

  sf_table =  FLTARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1,max_hkl - min_hkl + 1) 
  ;we put all values to the median monochromatic intensity
  sf_table(*) = median_monof
  ;those which exist are replaced by the correct values
  sf_table(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) = mono2.entry(0)

  FOR i=0,ct_mul-1 DO BEGIN
   mult2(i).ii_m=sf_table(mult2(i).m_m(0,*) - min_hkl,mult2(i).m_m(1,*) - min_hkl,mult2(i).m_m(2,*) - min_hkl)
  ENDFOR

 ;Now the last thing to do is to replace the unique miller indices
 ;by the original ones :

 max2_id=MAX(mult2.id)
 mult2_id = FLTARR(max2_id+1,7)
 ;7 because 0 contains id and 1:3 contains [h1,k1,l1] and 4:6 contains [h2,k2,l2]
 s=SORT(mult2.id)
 mult2=mult2(s)
 mult2_id(*,0)=-1
 
 mult2_id(mult2.id,0)=mult2.id

 w2=WHERE(laue.mul EQ 2,ct2)
 lauemul2=laue(w2)
 s=SORT(lauemul2.id)
 lauemul2=lauemul2(s)
 mult2_id(lauemul2.id,1)=lauemul2.m(0)
 mult2_id(lauemul2.id,2)=lauemul2.m(1)
 mult2_id(lauemul2.id,3)=lauemul2.m(2)
 mult2_id(lauemul2.id,4)=lauemul2.m2(0)
 mult2_id(lauemul2.id,5)=lauemul2.m2(1)
 mult2_id(lauemul2.id,6)=lauemul2.m2(2)


 w3=WHERE(mult2_id(*,0) NE -1)
 mult2_id=mult2_id(w3,*) 

 mult2.m_m(0,0)=mult2_id(*,1)
 mult2.m_m(1,0)=mult2_id(*,2)
 mult2.m_m(2,0)=mult2_id(*,3)
 mult2.m_m(0,1)=mult2_id(*,4)
 mult2.m_m(1,1)=mult2_id(*,5)
 mult2.m_m(2,1)=mult2_id(*,6)


 mult=mult2

ENDIF ; there are mutliples

;finally laue3 should contain l3_s + the multiples

w_mult=WHERE(laue.mul GT 1,ct_mult)
w_singles=WHERE(laue.mul EQ 1,ct_singles)

laue3=laue
IF ct_singles GE 1 THEN laue3(0:ct_singles-1)=l3_s
IF ct_mult GE 1 THEN laue3(ct_singles:ct_singles+ct_mult-1)=laue(w_mult)
SORT_MILLER,laue3

RETURN,laue3

END





