pro WRITE_2BYTES,array,filename,SCALE=SCALE
;+
; NAME:
;	WRITE_2BYTES
;
; PURPOSE:
;
; 	Outputs an array of LONG integers (4 bytes) in a binary file, after
;	reduction to words of 2 bytes. Produces CRAP if the MAX value in
;	array is more than 65535. Interesting to read IDL images of LONG
;	integers in other programs like FIT2D or LAUEGEN as SHORT (2 bytes)
;	integers.
;
; CATEGORY:
;	File managing
;
; CALLING SEQUENCE:
;	WRITE_2BYTES,array,filename
;
; INPUTS:
;	array : the array to use
;	filename : the filename to put the data in
;	scale : keyword set if the image is to be scaled between 0 and 65535
;
; OUTPUTS:
;	A binary file
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, April 1994.
;-

on_error,2                              ;Return to caller if an error occurs

IF KEYWORD_SET(scale) THEN array=LONG(array*65535/FLOAT(MAX(array)))

PRINT,'Converting to 2 bytes integers ...'
IF (SIZE(array))(0) EQ 1 THEN BEGIN
	byte_arr = BYTE(array,0,4,(SIZE(array))(1))
        byte_arr = byte_arr(2:3,*)
ENDIF

IF (SIZE(array))(0) EQ 2 THEN BEGIN
	byte_arr = BYTE(array,0,4,(SIZE(array))(1),(SIZE(array))(2))
        byte_arr = byte_arr(2:3,*,*)
ENDIF

IF (SIZE(array))(0) EQ 3 THEN BEGIN
	byte_arr = BYTE(array,0,4,(SIZE(array))(1),(SIZE(array))(2),(SIZE(array))(3))
        byte_arr = byte_arr(2:3,*,*,*)
ENDIF

 PRINT,'Writing binary file ... '
 OPENW,1,filename
 WRITEU,1,byte_arr

;close the file
CLOSE,1

END








