function ROILAUE3,struc,image,par,xmin,ymin,xmax,ymax,out_image_value=out_image_value
;+
; NAME:
;	ROILAUE3
;
; PURPOSE:
;
;	Automaticaly defines a region of interest in the image used to run
;	the "matchlaue" routine. This is useful because the border of the
;	original image often create problems with background calculations
;	due to sharp intensity changes. So the region of interest used in
;	the reflection list should be a bit smaller.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	spots = ROILAUE3(struc, image, par, xmin, ymin, xmax, ymax,[out_image_value=out_image_value])
;
; INPUTS:
;	image : the original image
;	struc : the reflection list (a structure produced with the
;	        program REFLIST to read the content of the CCP4 file
;		"*.geasc"
;	par : the parameter from the reflist.pro routine
;	xmin : minimum x value [pixel] in image
;	ymin : minimum y value [pixel] in image
;	xmax : maximum x value [pixel] in image
;	ymax : maximum y value [pixel] in image
; 	out_image_value : [optional] set to the value of the pixels 
;		which are out of the active area of the detector. Generally 0.
;
; OUTPUTS:
;	spots : the part of struc matching the defined region of interest
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, T.U. September 1995.
;-

!ERR = 0
;position of the center of the image
centerX = par.cenx-1
centerY = par.ceny-1

;y scale
scaleY = par.yscale


;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

;original pixel size [micrometers]
pix_size = par.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY

;half size of box in mm
box_size = {box, x:par.boxsize.x*par.raster*10.^(-3)/2.0,y:par.boxsize.x*par.raster*10.^(-3)/2.0}

IF N_ELEMENTS(out_image_value) EQ 0 THEN out_image_value=0 


x1= (struc.x-box_size.x)/pix_sizeX+centerX
y1= (struc.y-box_size.y)/pix_sizeY+centerY
x2= struc.x/pix_sizeX+centerX
y2= struc.y/pix_sizeY+centerY
x3= (struc.x+box_size.x)/pix_sizeX+centerX
y3= (struc.y+box_size.y)/pix_sizeY+centerY

w = WHERE((image(ROUND(x1), ROUND(y1)) GT out_image_value) $
	AND (image(ROUND(x1), ROUND(y3)) GT out_image_value) $
	AND (image(ROUND(x2), ROUND(y2)) GT out_image_value) $
	AND (image(ROUND(x3), ROUND(y1)) GT out_image_value) $
	AND (image(ROUND(x3), ROUND(y2)) GT out_image_value) $
	AND (x1 ge xmin) AND (y1 ge ymin) $
	AND (x3 le xmax) AND (y3 le ymax), $
	count)

IF count GE 1 THEN spots = struc(w) ELSE MESSAGE,'No spots selected ...'

PRINT,'Number of spots selected : ',(SIZE(spots))(1)
RETURN,spots
END








