function ROILAUE2,struc,image,par
;+
; NAME:
;	ROILAUE2
;
; PURPOSE:
;
;	Automaticaly defines a region of interest in the image used to run
;	the "matchlaue" routine. This is useful because the border of the
;	original image often create problems with background calculations
;	due to sharp intensity changes. So the region of interest used in
;	the reflection list should be a bit smaller.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	spots = ROILAUE2(struc, image, par)
;
; INPUTS:
;	image : the original image
;	struc : the reflection list (a structure produced with the
;	        program REFLIST to read the content of the CCP4 file
;		"*.geasc"
;	par : the parameter from the reflist.pro routine
;
; OUTPUTS:
;	spots : the part of struc matching the defined region of interest
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1994.
;-

!ERR = 0
;position of the center of the image
centerX = par.cenx-1
centerY = par.ceny-1

;y scale
scaleY = par.yscale


;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

;original pixel size [micrometers]
pix_size = par.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY

;half size of box in mm
box_size = par.boxsize*par.raster*10.^(-3)

w = WHERE((image(ROUND((struc.x-box_size.x)/pix_sizeX+centerX), $
	ROUND((struc.y-box_size.y)/pix_sizeY+centerY)) GT 0) $
	AND (image(ROUND((struc.x-box_size.x)/pix_sizeX+centerX), $
	ROUND((struc.y+box_size.y)/pix_sizeY+centerY)) GT 0) $
	AND (image(ROUND(struc.x/pix_sizeX+centerX), $
	ROUND(struc.y/pix_sizeY+centerY)) GT 0) $
	AND (image(ROUND((struc.x+box_size.x)/pix_sizeX+centerX), $
	ROUND((struc.y-box_size.y)/pix_sizeY+centerY)) GT 0) $
	AND (image(ROUND((struc.x+box_size.x)/pix_sizeX+centerX), $
	ROUND((struc.y+box_size.y)/pix_sizeY+centerY)) GT 0), $
	count)


IF count GE 1 THEN spots = struc(w) ELSE MESSAGE,'No spots selected ...'

PRINT,'Number of spots selected : ',(SIZE(spots))(1)
RETURN,spots
END








