function INTEGRATE_DENZO1, image,reb,all_spots,par,$
		ref_spots=ref_spots,$
		strong_spots=strong_spots,$
		ref_distance = ref_distance, $
		ref_ang_width = ref_ang_width, $
		show_image = show_image, $
		show_strong_peaks = show_strong_peaks, $
		show_ovlp_peaks = show_ovlp_peaks, $
		show_weak_peaks = show_weak_peaks, $
		show_m = show_m, $
		miller = miller, $
		use_partials = use_partials, $
		second_interp = second_interp, $
		study_win = study_win, $
		main_win = main_win, $
		sym_rad = sym_rad, $
		integ_mode = integ_mode
;+
; NAME:
;	INTEGRATE_DENZO1
;
; PURPOSE:
;	Master program to handle PROW integration from DENZO data. 
;	Strong spots are integrated with the INTEGRATE_BOX routint. 
;	Weak and overlaped spots are profile fitted with the INTEGRATE_PF3.PRO routine. 
;
; CATEGORY:
;	Laue processing.
;
; CALLING SEQUENCE:
;	Integ = INTEGRATE_DENZO1(image,reb,all_spots,par,
;		ref_spots=ref_spots,$
;		strong_spots=strong_spots,$
;		ref_distance = ref_distance, $
;		ref_ang_width = ref_ang_width, $
;		show_image = show_image, $
;		show_strong_peaks = show_strong_peaks, $
;		show_ovlp_peaks = show_ovlp_peaks, $
;		show_weak_peaks = show_weak_peaks, $
;		show_m = show_m, $
;		miller = miller, $
;		use_partials = use_partials, $
;		second_interp = second_interp, $
;		study_win = study_win, $
;		main_win = main_win, $
;		sym_rad = sym_rad, $
;		integ_mode = integ_mode
;
; INPUTS:
;	image : the original image
;	reb : the rebinning factor
;	all_spots : the reflexion list (all reflexions on the image)
;	par : the parameters of the experiment
;	ref_spots : the reference spots
;	strong spots : the strong spots that can be box integrated
;	ref_distance : maximum radial distance to look for reference peaks 
;				around the currently integrated peak [mm]
;	ref_ang_width : maximum tengential distance to look for reference peaks
;				around the currently integrated peak [degrees]	
;	show_strong_peaks = keyword set if the strong peaks are to be shown
;	show_ovlp_peaks = keyword set if the overlapped peaks are to be shown
;	show_weak_peaks = keyword set if the weak peaks are to be shown
;	show_m = keyword set if a particular reflection is to be shown,
;			given by miller
;	miller = INTARR[3] containing the miller indices of the reflection
;		to be displayed if the show_m keyword is set.
;	use_partials : keyword set if partials are to be used for the
;		evaluation of reference spots.
;	sym_rad : keyword set if the reference peak search is to be extented
;		to symmetrical sector if necessary
;	second_interp : set this keyword if you want to allow a second interpolation 
;		of reference profile in case of bad chi square tests.
;	study_win : window id of the window displaying surface plots, contour ... in debug modes
;	main_win : window id of the main window displaying the image
;	integ_mode : the integration mode. Either 'laue' or 'mono'. Default is 'mono'
;
; OUTPUTS:
;	integ : a structure now similar to "all_spots": with in addition : 	
;						integrated intensities
;						sigma
;						goodness of fit
;						flag		
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	D.Bourgeois, July 97.
;-

;See the mode
IF N_ELEMENTS(integ_mode) EQ 0 THEN integ_mode='mono' 
;deal with windows
IF show_image THEN $
	IF NOT N_ELEMENTS(main_win) THEN main_win=!D.WINDOW 

IF show_strong_peaks OR show_ovlp_peaks OR show_weak_peaks OR show_m THEN $
	IF NOT N_ELEMENTS(study_win) THEN BEGIN
		WIN, 512,512,/FREE,TITLE='Debug Window'
		study_win=!D.WINDOW
		WSET,main_win
	ENDIF ELSE study_win=-1

;Define an array containing the integrated intensities

one_spot={	m: INTARR(3), $
	 	x: 0.0, $
		y: 0.0, $
		xpix: 0.0, $
		ypix: 0.0, $
		partiality: 0, $
		lp: 0.0, $
		cosine: 0.0, $
		chisquare: 0.0, $
		strength: 0.0, $
		par1: 0.0, $
		par2: 0.0, $
		l: 0.0, $
		mul: 0, $
		nodal: 0, $
		ovlp: 0,$
		sector:0, $
		id:0L, $
		connect: LONARR(24), $
		close:0, $
		m2: INTARR(3), $
		nidx: 0, $
		l2: 0.0, $
		phi: 0.0, $
		ipoint: 0, $
		dminth: 0.0, $
		bc_coeff: FLTARR(3), $
		intb: FLTARR(6), $
		isigb: FLTARR(6), $
		intp: FLTARR(6), $
		isigp: FLTARR(6),$
		tth: 0.0, $
		res: 0.0, $
		flag : 0, $
		gfit : 0.0	}




integ = REPLICATE(one_spot, (SIZE(all_spots))(1))

;get the byte image
image_b = BYTARR(par.rastx,par.rasty)

IF (integ_mode EQ 'mono') AND (par.bc_extend GE 0) THEN BEGIN ;only calculate the byte image in mono mode. If in Laue there are generally too many spots !
 ;IF MAX(par.overall_region NE 0) THEN BEGIN
 ; peak_region=GET_ENLARGED_REGION(par.overall_region,par.boxsize.x,par.boxsize.y,extend=par.bc_extend,/REVERSE)
 ; xy_reg = WHERESUB(peak_region,LONARR(par.boxsize.x,par.boxsize.y,/NOZERO))
 ; xr = FIX(FLOAT(xy_reg) - FIX(par.boxsize.x/2)) & yr = FIX(IMAGINARY(xy_reg) - FIX(par.boxsize.y/2))
 ; FOR i=0,(SIZE(all_spots))(1)-1 DO image_b(FIX(all_spots(i).xpix)+xr,FIX(all_spots(i).ypix)+yr)=1
 ;ENDIF

 IF MAX(par.overall_region) NE 0 THEN BEGIN
  peak_overall_region=GET_ENLARGED_REGION(par.overall_region,par.boxsize.x,par.boxsize.y,extend=par.bc_extend,/REVERSE)
 ENDIF


 FOR loc_i=0,par.n_sectors-1 DO BEGIN
  peak_region=GET_ENLARGED_REGION(*par.regions(loc_i),par.boxsize.x,par.boxsize.y,extend=par.bc_extend,/REVERSE)

  IF MAX(par.overall_region) NE 0 THEN BEGIN
   peak_region = GET_COMMON_ELEMENTS(peak_region,peak_overall_region)
  ENDIF
  xy_reg = WHERESUB(peak_region,LONARR(par.boxsize.x,par.boxsize.y,/NOZERO))
  xr = FIX(FLOAT(xy_reg) - FIX(par.boxsize.x/2)) & yr = FIX(IMAGINARY(xy_reg) - FIX(par.boxsize.y/2))
  w=WHERE(all_spots.sector EQ (loc_i+1),ct_sec)
  IF ct_sec GT 0 THEN FOR loc_j=0,ct_sec-1 DO image_b(FIX(all_spots(w(loc_j)).xpix)+xr,FIX(all_spots(w(loc_j)).ypix)+yr)=1
 ENDFOR
ENDIF

;We now start the integration procedure

;1/Box integrate the reference  spots
integrate_with_box=0


IF (SIZE(strong_spots))(0) EQ 1 THEN n_strong_spots=(SIZE(strong_spots))(1) ELSE n_strong_spots=0


IF n_strong_spots GT 0 THEN BEGIN
IF integrate_with_box THEN BEGIN
 PRINT,'Box integrating reference profiles ...'

 IF KEYWORD_SET(show_strong_peaks) THEN BEGIN
  ii_box = INTEGRATE_BOX(strong_spots,reb,image,image_b,par,peak_variance,success_flag,bc_coeff=bc_coeff,/show_spots,study_win=study_win,main_win=main_win)
 ENDIF ELSE BEGIN
  IF KEYWORD_SET(show_m) THEN BEGIN
   ii_box = INTEGRATE_BOX(strong_spots,reb,image,image_b,par,peak_variance,success_flag,bc_coeff=bc_coeff,/show_m,miller=miller,study_win=study_win,main_win=main_win)
  ENDIF
 
  IF NOT KEYWORD_SET(show_m) THEN BEGIN
   ii_box = INTEGRATE_BOX(strong_spots,reb,image,image_b,par,peak_variance,success_flag,bc_coeff=bc_coeff,study_win=study_win,main_win=main_win)
  ENDIF
 ENDELSE

 IF (SIZE(ii_box))(1) GT 1 THEN $
  integ(0:n_strong_spots-1).intp(0) = ii_box ELSE $
  integ(0:n_strong_spots-1).intp(0) = ii_box(0)

 IF (SIZE(ii_box))(1) GT 1 THEN $
 integ(0:n_strong_spots-1).intp(2) = ii_box ELSE $
 integ(0:n_strong_spots-1).intp(2) = ii_box(0)

 IF (SIZE(ii_box))(1) GT 1 THEN BEGIN
  integ(0:n_strong_spots-1).intb(0) = ii_box
  strong_spots(0:n_strong_spots-1).intb(0) = ii_box
 ENDIF ELSE BEGIN
  integ(0:n_strong_spots-1).intb(0) = ii_box(0)
  strong_spots(0:n_strong_spots-1).intb(0) = ii_box(0)
 ENDELSE

 IF KEYWORD_SET(show_strong_peaks) THEN WSET,main_win

 IF (SIZE(success_flag))(1) GT 1 THEN $
  integ(0:n_strong_spots-1).flag = success_flag ELSE $
  integ(0:n_strong_spots-1).flag = success_flag(0)

 integ(0:n_strong_spots-1).x = strong_spots(0:n_strong_spots-1).x
 integ(0:n_strong_spots-1).y = strong_spots(0:n_strong_spots-1).y
 integ(0:n_strong_spots-1).chisquare = strong_spots(0:n_strong_spots-1).chisquare
 integ(0:n_strong_spots-1).cosine = strong_spots(0:n_strong_spots-1).cosine
 integ(0:n_strong_spots-1).lp = strong_spots(0:n_strong_spots-1).lp
 integ(0:n_strong_spots-1).ypix = strong_spots(0:n_strong_spots-1).ypix
 integ(0:n_strong_spots-1).xpix = strong_spots(0:n_strong_spots-1).xpix
 integ(0:n_strong_spots-1).partiality = strong_spots(0:n_strong_spots-1).partiality
 integ(0:n_strong_spots-1).strength = strong_spots(0:n_strong_spots-1).strength
 integ(0:n_strong_spots-1).par1 = strong_spots(0:n_strong_spots-1).par1
 integ(0:n_strong_spots-1).par2 = strong_spots(0:n_strong_spots-1).par2
 integ(0:n_strong_spots-1).m = strong_spots(0:n_strong_spots-1).m
 integ(0:n_strong_spots-1).tth = strong_spots(0:n_strong_spots-1).tth
 integ(0:n_strong_spots-1).res = strong_spots(0:n_strong_spots-1).res
 integ(0:n_strong_spots-1).mul = strong_spots(0:n_strong_spots-1).mul
 integ(0:n_strong_spots-1).nodal = strong_spots(0:n_strong_spots-1).nodal
 integ(0:n_strong_spots-1).sector = strong_spots(0:n_strong_spots-1).sector+1
 integ(0:n_strong_spots-1).id = strong_spots(0:n_strong_spots-1).id
 integ(0:n_strong_spots-1).connect = strong_spots(0:n_strong_spots-1).connect
 integ(0:n_strong_spots-1).close = strong_spots(0:n_strong_spots-1).close
 integ(0:n_strong_spots-1).m2 = strong_spots(0:n_strong_spots-1).m2
 integ(0:n_strong_spots-1).nidx = strong_spots(0:n_strong_spots-1).nidx
 integ(0:n_strong_spots-1).l2 = strong_spots(0:n_strong_spots-1).l2
 integ(0:n_strong_spots-1).phi = strong_spots(0:n_strong_spots-1).phi
 integ(0:n_strong_spots-1).ipoint = strong_spots(0:n_strong_spots-1).ipoint
 integ(0:n_strong_spots-1).dminth = strong_spots(0:n_strong_spots-1).dminth
 integ(0:n_strong_spots-1).intb(1:5) = strong_spots(0:n_strong_spots-1).intb(1:5)
 integ(0:n_strong_spots-1).isigb(1:5) = strong_spots(0:n_strong_spots-1).isigb(1:5)
 integ(0:n_strong_spots-1).intp(1) = strong_spots(0:n_strong_spots-1).intp(1)
 integ(0:n_strong_spots-1).intp(4:5) = strong_spots(0:n_strong_spots-1).intp(4:5)
 integ(0:n_strong_spots-1).isigp(1:5) = strong_spots(0:n_strong_spots-1).isigp(1:5)
 integ(0:n_strong_spots-1).l = strong_spots(0:n_strong_spots-1).l
 IF (SIZE(peak_variance))(1) GT 1 THEN $
  integ(0:n_strong_spots-1).bc_coeff = bc_coeff ELSE $
  integ(0:n_strong_spots-1).bc_coeff = bc_coeff(*,0)
 IF (SIZE(peak_variance))(1) GT 1 THEN $
  integ(0:n_strong_spots-1).isigp(0) = peak_variance ELSE $
  integ(0:n_strong_spots-1).isigp(0) = peak_variance(0)
 IF (SIZE(peak_variance))(1) GT 1 THEN $
  integ(0:n_strong_spots-1).isigb(0) = peak_variance ELSE $
  integ(0:n_strong_spots-1).isigb(0) = peak_variance(0)

ENDIF
ENDIF

;2/Recalculate background and get the interpolated reference profiles
PRINT,'Interpolating reference profiles ... '
cr = STRING("15b)

FOR loc_i=0,(SIZE(ref_spots))(1)-1 DO BEGIN
 IF loc_i/10 EQ loc_i/10.0 THEN PRINT,FORMAT="($,I5,' ie : ',F3.0,'%',A)",loc_i,100.*loc_i/FLOAT((SIZE(ref_spots))(1)),cr

 ;recalculate background
 ;PRINT,'Old coeff : ', ref_spots(loc_i).bc_coeff
 xpos = FIX(ref_spots(loc_i).xpix)
 ypos = FIX(ref_spots(loc_i).ypix)
 area_b = ref_spots(loc_i).sp*(image_b(xpos - FIX(par.boxsize.x/2.):xpos + FIX(par.boxsize.x/2.), ypos - FIX(par.boxsize.y/2.):ypos + FIX(par.boxsize.y/2.)) EQ 0)
 ref_spots(loc_i).bc = BACK2D_POLY4(area_b,par.noise_percentage,par.bg_gain,par.dark_current,flag,coeff,bc_mean,n_back,max_slope=par.bg_max_slope)
 ;PRINT,'New coeff : ',[0,bc_mean,n_back]

 ;get the interpolated profile
 ;ref_spots(loc_i).sp = GET_CENTERED_PROFILE(ref_spots(loc_i).sp-ref_spots(loc_i).bc)
 ref_spots(loc_i).sp = GET_INTERP_PROFILE(ref_spots(loc_i).sp-ref_spots(loc_i).bc,ref_spots(loc_i).xpix,ref_spots(loc_i).ypix,/REVERSE)
 ;ref_spots(loc_i).sp = ref_spots(loc_i).sp-ref_spots(loc_i).bc

 ;here "overall_region" should be applied
 IF MAX(par.overall_region) NE 0 THEN ref_spots(loc_i).sp(par.overall_region)=0
; ref_spots(loc_i).sp(par.overall_region2)=0

 ;here "regions" should be applied
 ref_spots(loc_i).sp(*par.regions(ref_spots(loc_i).sector))=0

ENDFOR

;3/Select the candidates for profile fitting integration :
PRINT,'Separating weak profiles ...'
IF n_strong_spots GT 0 THEN BEGIN
 weak_spots = DIFF_STRUC(all_spots,strong_spots)
 n_weak_spots = (SIZE(weak_spots))(1)
ENDIF ELSE BEGIN
 weak_spots = all_spots
 n_weak_spots = (SIZE(weak_spots))(1)
ENDELSE

PRINT,'Total number of weak reflections',n_weak_spots
PRINT,'Profile fitting weak reflections ...'

integ(n_strong_spots:n_strong_spots+n_weak_spots-1).ovlp = weak_spots.ovlp

IF KEYWORD_SET(show_weak_peaks) AND KEYWORD_SET(show_ovlp_peaks) THEN BEGIN 
 ii_pf = INTEGRATE_PF3(weak_spots,ref_spots,image,image_b,reb,par,ref_distance,ref_ang_width,good_fit,peak_variance,success_flag,bc_coeff=bc_coeff,/show_weak,/show_ovlp,sym_rad = sym_rad, box_scale_integ=box_scale_integ,second_interp=second_interp,study_win=study_win,main_win=main_win,box2_scale_integ=box2_scale_integ) 
ENDIF ELSE BEGIN

 IF KEYWORD_SET(show_weak_peaks) THEN BEGIN
  ii_pf = INTEGRATE_PF3(weak_spots,ref_spots,image,image_b,reb,par,ref_distance,ref_ang_width,good_fit,peak_variance,success_flag,bc_coeff=bc_coeff,/show_weak, sym_rad = sym_rad, box_scale_integ=box_scale_integ,second_interp=second_interp,study_win=study_win,main_win=main_win,box2_scale_integ=box2_scale_integ)
 ENDIF 

 IF KEYWORD_SET(show_ovlp_peaks) THEN BEGIN
  ii_pf = INTEGRATE_PF3(weak_spots,ref_spots,image,image_b,reb,par,ref_distance,ref_ang_width,good_fit,peak_variance,success_flag,bc_coeff=bc_coeff,/show_ovlp, sym_rad = sym_rad, box_scale_integ=box_scale_integ,second_interp=second_interp,study_win=study_win,main_win=main_win,box2_scale_integ=box2_scale_integ)
 ENDIF 

 IF KEYWORD_SET(show_m) THEN BEGIN
  ii_pf = INTEGRATE_PF3(weak_spots,ref_spots,image,image_b,reb,par,ref_distance,ref_ang_width,good_fit,peak_variance,success_flag,bc_coeff=bc_coeff,/show_m,miller=miller, sym_rad = sym_rad, box_scale_integ=box_scale_integ,second_interp=second_interp,study_win=study_win,main_win=main_win,box2_scale_integ=box2_scale_integ)
 ENDIF 

 IF (NOT KEYWORD_SET(show_ovlp_peaks)) AND (NOT KEYWORD_SET(show_weak_peaks)) AND (NOT KEYWORD_SET(show_m)) THEN $
 ii_pf = INTEGRATE_PF3(weak_spots,ref_spots,image,image_b,reb,par,ref_distance,ref_ang_width,good_fit,peak_variance,success_flag, bc_coeff=bc_coeff,sym_rad = sym_rad, box_scale_integ=box_scale_integ,second_interp=second_interp,study_win=study_win,main_win=main_win,box2_scale_integ=box2_scale_integ)

ENDELSE

IF (SIZE(ii_pf))(0) EQ 0 THEN MESSAGE,'Stopping program !'

IF (SIZE(ii_pf))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(0) = ii_pf ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(0) = ii_pf(0)

IF (SIZE(ii_pf))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(2) = box_scale_integ ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(2) = box_scale_integ(0)

IF (SIZE(ii_pf))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(3) = box2_scale_integ ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(3) = box2_scale_integ(0)

IF KEYWORD_SET(show_weak_peaks) THEN WSET,main_win

IF (SIZE(good_fit))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).gfit = good_fit ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).gfit = good_fit(0)

IF (SIZE(success_flag))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).flag = success_flag ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).flag = success_flag(0)

integ(n_strong_spots:n_strong_spots+n_weak_spots-1).x = weak_spots.x
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).y = weak_spots.y

integ(n_strong_spots:n_strong_spots+n_weak_spots-1).strength = weak_spots.strength
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).lp = weak_spots.lp
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).xpix = weak_spots.xpix
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).ypix = weak_spots.ypix
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).cosine = weak_spots.cosine
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).partiality = weak_spots.partiality
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).chisquare = weak_spots.chisquare
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).par1 = weak_spots.par1
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).par2 = weak_spots.par2

integ(n_strong_spots:n_strong_spots+n_weak_spots-1).m = weak_spots.m
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).tth = weak_spots.tth
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).res = weak_spots.res
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).mul = weak_spots.mul
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).nodal = weak_spots.nodal
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).sector = weak_spots.sector
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).id = weak_spots.id
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).connect = weak_spots.connect
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).close = weak_spots.close
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).m2 = weak_spots.m2
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).nidx = weak_spots.nidx
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).l2 = weak_spots.l2
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).phi = weak_spots.phi
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).ipoint = weak_spots.ipoint
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).dminth = weak_spots.dminth
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intb = weak_spots.intb
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).isigb = weak_spots.isigb
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(1) = weak_spots.intp(1)
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).intp(4:5) = weak_spots.intp(4:5)
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).isigp(1:5) = weak_spots.isigp(1:5)
integ(n_strong_spots:n_strong_spots+n_weak_spots-1).l = weak_spots.l
IF (SIZE(peak_variance))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).bc_coeff = bc_coeff ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).bc_coeff = bc_coeff(*,0)
IF (SIZE(peak_variance))(1) GT 1 THEN $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).isigp(0) = peak_variance ELSE $
 integ(n_strong_spots:n_strong_spots+n_weak_spots-1).isigp(0) = peak_variance(0)

;NEWNEWNEWNEWNEW
;4/Select the strong spots
PRINT,'Getting strong profiles ...'
new_strong_spots = DIFF_STRUC(all_spots,weak_spots)
IF (SIZE(new_strong_spots))(0) EQ 1 THEN $
 n_new_strong_spots = (SIZE(new_strong_spots))(1) ELSE n_new_strong_spots=0
PRINT,'Total number of STRONG reflections',n_new_strong_spots

IF n_new_strong_spots GT 0 THEN BEGIN
 PRINT,'Profile fitting strong reflections ...'
 strong_ii_pf = INTEGRATE_PF3(new_strong_spots,ref_spots,image,image_b,reb,par,ref_distance,ref_ang_width,good_fit,peak_variance,success_flag, bc_coeff=bc_coeff,sym_rad = sym_rad, box_scale_integ=box_scale_integ,second_interp=second_interp,study_win=study_win,main_win=main_win,box2_scale_integ=box2_scale_integ)

IF (SIZE(strong_ii_pf))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).intp(0) = strong_ii_pf ELSE $
 integ(0:n_new_strong_spots-1).intp(0) = strong_ii_pf(0)

IF (SIZE(strong_ii_pf))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).intp(2) = box_scale_integ ELSE $
 integ(0:n_new_strong_spots-1).intp(2) = box_scale_integ(0)

IF (SIZE(strong_ii_pf))(1) GT 1 THEN BEGIN
 integ(0:n_new_strong_spots-1).intb(2) = strong_ii_pf
 strong_spots(0:n_new_strong_spots-1).intb(2) = strong_ii_pf
ENDIF ELSE BEGIN
 integ(0:n_new_strong_spots-1).intb(2) = strong_ii_pf(0)
 strong_spots(0:n_new_strong_spots-1).intb(2) = strong_ii_pf(0)
ENDELSE

IF (SIZE(success_flag))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).flag = success_flag ELSE $
 integ(0:n_new_strong_spots-1).flag = success_flag(0)

IF (SIZE(good_fit))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).chisquare = good_fit ELSE $
 integ(0:n_new_strong_spots-1).chisquare = good_fit(0)

IF (SIZE(peak_variance))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).bc_coeff = bc_coeff ELSE $
 integ(0:n_new_strong_spots-1).bc_coeff = bc_coeff(*,0)

IF (SIZE(peak_variance))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).isigp(0) = peak_variance ELSE $
 integ(0:n_new_strong_spots-1).isigp(0) = peak_variance(0)

IF (SIZE(peak_variance))(1) GT 1 THEN $
 integ(0:n_new_strong_spots-1).isigb(2) = peak_variance ELSE $
 integ(0:n_new_strong_spots-1).isigb(2) = peak_variance(0)


integ(0:n_new_strong_spots-1).x = new_strong_spots(0:n_new_strong_spots-1).x
integ(0:n_new_strong_spots-1).y = new_strong_spots(0:n_new_strong_spots-1).y
integ(0:n_new_strong_spots-1).cosine = new_strong_spots(0:n_new_strong_spots-1).cosine
integ(0:n_new_strong_spots-1).lp = new_strong_spots(0:n_new_strong_spots-1).lp
integ(0:n_new_strong_spots-1).ypix = new_strong_spots(0:n_new_strong_spots-1).ypix
integ(0:n_new_strong_spots-1).xpix = new_strong_spots(0:n_new_strong_spots-1).xpix
integ(0:n_new_strong_spots-1).partiality = new_strong_spots(0:n_new_strong_spots-1).partiality
integ(0:n_new_strong_spots-1).strength = new_strong_spots(0:n_new_strong_spots-1).strength
integ(0:n_new_strong_spots-1).par1 = new_strong_spots(0:n_new_strong_spots-1).par1
integ(0:n_new_strong_spots-1).par2 = new_strong_spots(0:n_new_strong_spots-1).par2
integ(0:n_new_strong_spots-1).m = new_strong_spots(0:n_new_strong_spots-1).m
integ(0:n_new_strong_spots-1).tth = new_strong_spots(0:n_new_strong_spots-1).tth
integ(0:n_new_strong_spots-1).res = new_strong_spots(0:n_new_strong_spots-1).res
integ(0:n_new_strong_spots-1).mul = new_strong_spots(0:n_new_strong_spots-1).mul
integ(0:n_new_strong_spots-1).nodal = new_strong_spots(0:n_new_strong_spots-1).nodal
integ(0:n_new_strong_spots-1).sector = new_strong_spots(0:n_new_strong_spots-1).sector
integ(0:n_new_strong_spots-1).id = new_strong_spots(0:n_new_strong_spots-1).id
integ(0:n_new_strong_spots-1).connect = new_strong_spots(0:n_new_strong_spots-1).connect
integ(0:n_new_strong_spots-1).close = new_strong_spots(0:n_new_strong_spots-1).close
integ(0:n_new_strong_spots-1).m2 = new_strong_spots(0:n_new_strong_spots-1).m2
integ(0:n_new_strong_spots-1).nidx = new_strong_spots(0:n_new_strong_spots-1).nidx
integ(0:n_new_strong_spots-1).l2 = new_strong_spots(0:n_new_strong_spots-1).l2
integ(0:n_new_strong_spots-1).phi = new_strong_spots(0:n_new_strong_spots-1).phi
integ(0:n_new_strong_spots-1).ipoint = new_strong_spots(0:n_new_strong_spots-1).ipoint
integ(0:n_new_strong_spots-1).dminth = new_strong_spots(0:n_new_strong_spots-1).dminth
integ(0:n_new_strong_spots-1).intb(1) = new_strong_spots(0:n_new_strong_spots-1).intb(1)
integ(0:n_new_strong_spots-1).intb(3:5) = new_strong_spots(0:n_new_strong_spots-1).intb(3:5)
integ(0:n_new_strong_spots-1).isigb(1) = new_strong_spots(0:n_new_strong_spots-1).isigb(1)
integ(0:n_new_strong_spots-1).isigb(3:5) = new_strong_spots(0:n_new_strong_spots-1).isigb(3:5)
integ(0:n_new_strong_spots-1).intp(1) = new_strong_spots(0:n_new_strong_spots-1).intp(1)
integ(0:n_new_strong_spots-1).intp(3:5) = new_strong_spots(0:n_new_strong_spots-1).intp(3:5)
integ(0:n_new_strong_spots-1).isigp(1:5) = new_strong_spots(0:n_new_strong_spots-1).isigp(1:5)
integ(0:n_new_strong_spots-1).l = new_strong_spots(0:n_strong_spots-1).l

ENDIF
;END NEWNEWNEWNEWNEW



RETURN,integ
END


