function GET_XREF_PROF2, image,red,ref,par,max_number_peaks,min_sob,ref_distance,ref_ang_width,min_ref_peaks,show=show
;+
; NAME:
;	GET_XREF_PROF2
;
; PURPOSE:
;	Select reference peaks for profile fitted IDL integration software.
;	A maximum of number_peaks peaks are selected, which all show a 
;	minimum peak_value/background equal to min_sob. These peaks are
;	carefully checked for FWHM, dead pixels and spikes or spurious
;	peaks
;
; CATEGORY:
;	Laue processing.
;
; CALLING SEQUENCE:
;	Reference_profiles = GET_XREF_PROF2(image,ref,par,number_peaks,
;		min_sob,ref_distance,ref_ang_width,/show)
;
; INPUTS:
;	image : the original image
;	red : the rebinned version of image
;	ref : the reflexion list, corrected for positions, produced by the 
;			MATCHLAUE4.PRO routine.
;	par : the parameters of the experiment
;	max_number_peaks : the maximum number of peaks to select
;	min_sob : the minimum peak_value to background ratio to select a peak
;	ref_distance : the maximum radial distance to look for a reference peak
;	   	from the position of the currently integrated peak [mm]
;	ref_ang_width : the maximum tengential distance to look for a 
;		reference peak from the position of the currently integrated 
;		peak [degrees]
;	show : keyword set if the reference profile is to be visualized
;
; OUTPUTS:
;	reference_profile : a structure containing the reference profiles and
;			their parameters.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.	
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1995.
;-


;start the procedure if some peaks were selected
IF (SIZE(ref))(0) EQ 0 THEN MESSAGE,'Error : no spot selected !'

iteration=0
number_spots=0 & number_spike=0 & skip_spike=0
old_spot_number=0
min_sob2=1.2*min_sob
min_ref_peaks2=min_ref_peaks
PRINT,'Minimum number of reference peaks set to : ',min_ref_peaks 
REPEAT BEGIN

IF ((number_spots ge 1.25*min_ref_peaks2) and (skip_spike eq 0)) THEN BEGIN
IF (SIZE(spots))(1) GE min_ref_peaks2/1.2 THEN BEGIN
PRINT,'Minimum number of reference peaks reduced to : ',min_ref_peaks2/1.2 
GOTO,set_ok 
ENDIF
IF old_spot_number GE (SIZE(spots))(1)-1 THEN BEGIN
PRINT,'Too few good spots ...'
PRINT,'Minimum number of reference peaks reduced to : ',(SIZE(spots))(1)
GOTO,set_ok 
ENDIF
min_ref_peaks2=FIX(min_ref_peaks2/1.2)
PRINT,'Minimum number of reference peaks reduced to : ',min_ref_peaks2 
ENDIF ELSE skip_spike=0

IF (skip_spike eq 0) THEN min_sob2=min_sob2/1.2
IF (min_sob2 le 0.1) THEN MESSAGE, 'Can not find reference peaks!' 
PRINT,'Min_SoB : ', min_sob2
IF iteration GE 1 THEN old_spot_number = (SIZE(spots))(1)

IF (SIZE(ref))(1) GT 1 THEN poss_ref = (ref(REVERSE(SORT(ref.intp(0)))))(0:((max_number_peaks-1)<((SIZE(ref))(1)-1)))

;we select for the peaks of sufficient signal to background ratio
possible_index = WHERE(poss_ref.intp(0)/poss_ref.bc_coeff(2) GT min_sob2)

IF (SIZE(possible_index))(0) EQ 0 THEN MESSAGE,'Error, no spot selected ... ' $
ELSE poss_ref = poss_ref(possible_index)

;the number of potential spots is :
number_spots = (SIZE(possible_index))(1)
PRINT,'Number of peaks with sufficient I/Sig(I) :',number_spots

;*****
;get all spots of interest  (as structures) :
;*****
spots = GET_DENZO_SPOTS2(poss_ref,image,red,par)

IF KEYWORD_SET(show) THEN BEGIN ;show
main_window = !D.WINDOW
WIN,512,512
sim_window = !D.WINDOW
ENDIF ;show


;selection of good reference spots : all spots are checked for
;FWHM and then compared with the global mean profile and checked 
;for deviation :

;******
;remove any bad FWHM
;******

sigma = STDEV(spots.fwhm,mean)
possible_index = WHERE((spots.fwhm - mean)^2 LE 5.0*sigma^2,count)
;possible_index = WHERE((spots.fwhm - mean)^2 LE 5000000000.*sigma^2,count)

spots = spots(possible_index)
poss_ref = poss_ref(possible_index)

PRINT,'Number of reference peaks rejected from bad FWHM :',number_spots-count
number_spots=(SIZE(spots))(1)


;******
;remove spots with bad background 
;******

IF MAX(spots.flag) NE 0 THEN BEGIN
possible_index = WHERE(spots.flag EQ 0)
IF (SIZE(possible_index))(1) EQ 0 THEN MESSAGE, 'Error : No good spot'
PRINT,'Number of spots rejected over bad background :', (SIZE(spots))(1) - (SIZE(possible_index))(1)

spots = spots(possible_index)
poss_ref = poss_ref(possible_index)

;the number of potential spots is now:
number_spots = (SIZE(possible_index))(1)

ENDIF ELSE PRINT,'Number of spots rejected over bad background :',0


;******
;remove spots which are shifted
;******

FOR i=0,number_spots-1 DO spots(i).intp(1)=MAX(spots(i).sp)

bs=par.boxsize
bsx2 = FIX(par.boxsize.x/2.)
bsy2 = FIX(par.boxsize.y/2.)


possible_index = WHERE( $
spots.sp(FIX(bs.x*bsy2+bsx2)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*bsy2+bsx2-1)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*bsy2+bsx2+1)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*(bsy2-1)+bsx2)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*(bsy2-1)+bsx2-1)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*(bsy2-1)+bsx2+1)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*(bsy2+1)+bsx2)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*(bsy2+1)+bsx2-1)) EQ LONG(spots.intp(1)) OR $
spots.sp(FIX(bs.x*(bsy2+1)+bsx2+1)) EQ LONG(spots.intp(1)) $
,count)

IF (SIZE(possible_index))(1) EQ 0 THEN MESSAGE, 'Error : No good spot'
PRINT,'Number of spots rejected because too large shift :', (SIZE(spots))(1) - (SIZE(possible_index))(1)

spots = spots(possible_index)
poss_ref = poss_ref(possible_index)

;the number of potential spots is now:
number_spots = (SIZE(possible_index))(1)


;******
;remove any spurious peak or spike
;******
number_spike = 0
number_dead = 0

good_spots = spots
j = 0


FOR i=0,number_spots-1 DO BEGIN ;go through all spots
peak = spots(i).sp - spots(i).bc

;get the cutoff level
cutoff = GET_BOXLEVEL(peak,spots(i).bc_coeff(1),spots(i).bc_coeff(2),par.dark_current)

;is there a spike or a dead pixel ?
IF (skip_spike eq 1) THEN spike=0 $
ELSE spike = GET_SPIKE(peak,cutoff,par.boxsize,show=show)
number_spike = number_spike + spike
IF (skip_spike eq 1) THEN dead_pix=0 $
ELSE dead_pix = GET_DEADPIX(peak,cutoff,par.boxsize,show=show)
number_dead = number_dead + dead_pix
 
IF (spike EQ 0) AND (dead_pix EQ 0) THEN BEGIN
good_spots(j) = spots(i)
j = j + 1
ENDIF

;m0=17
;m1=3
;m2=-1
;IF ((spots(i).m(0) EQ m0) AND (spots(i).m(1) EQ m1) AND (spots(i).m(2) EQ m2)) THEN show=1


IF KEYWORD_SET(show) THEN BEGIN

IF i ge 0 THEN BEGIN
PRINT,'Spot number :',i
PRINT,'Miller indices :',spots(i).m

PRINT,'Original peak'
SURFACE,peak
OK=''
PRINT,'OK ? [Y/N]'
READ,OK

ENDIF

ENDIF
;****

ENDFOR ; going through all spots

spots = good_spots(0:j-1)

PRINT,'Number of spots rejected for spikes or too uneven background :',number_spike
PRINT,'Number of spots rejected for dead pixels :',number_dead
PRINT,'Number of selected spots :',(SIZE(spots))(1)

iteration=iteration+1
ENDREP UNTIL ((SIZE(spots))(1) ge min_ref_peaks2)
set_ok :
;****
IF KEYWORD_SET(SHOW) THEN BEGIN ;begin show
FOR i=0,number_spots-1 DO BEGIN
 dum = spots(i).sp - spots(i).bc
PRINT,'PosMax :',WHERESUB(WHERE(dum EQ MAX(dum)),dum)
ENDFOR

FOR i=0,(SIZE(spots))(1)-1 DO BEGIN
;SURFACE,spots(i).sp
WSET,main_window
dummy = PIXLAUE2(spots(i),red,image,par,draw=8,color=3)
;OK=''
;READ,'OK ? [Y/N]',OK
WSET,sim_window
ENDFOR
ENDIF ; show

RETURN,spots
END


