pro FIND_QUICKOVLP,spot_list,par,dist
;+
; NAME:
;	FIND_QUICKOVLP
;
; PURPOSE:
;	Finds the overlapped spots in spot_list. Does not bother about connexions.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	FIND_QUICKOVLP,spot_list,par,dist
;
; INPUTS:
;	spot_list : a list of spots obtained by the program READ_GEASC2.PRO
;	par : the parameter from the reflist.pro routine
;	dist : the distance below which two neighbouring spots are considered
;		overlapped [mm]
; OUTPUTS:
;	spots : the part of struc matching the defined region of interest
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, November 1994.
;-

!ERR = 0

;reset any old attribution
spot_list(*).ovlp = 0

size_list=(SIZE(spot_list))(1)

cr = STRING("15b)

;separate into columns of no more than 500 spots but at least 1 columns !
n_columns = FIX(size_list/500.)>1
min_x = MIN(spot_list.x) & max_x = MAX(spot_list.x)
col_width = (max_x - min_x)/FLOAT(n_columns)

FOR col=0,n_columns-1 DO BEGIN

PRINT,FORMAT="($,'Number of scanned image columns : ', I3,' ie : ',F3.0,'%',A)",col,100.*col/FLOAT(n_columns),cr

;consider a restricted column with overlap = 2*dist
loc_min_x = min_x + col*col_width - dist
loc_max_x = loc_min_x + col_width + 2*dist
w_list = WHERE(spot_list.x GE loc_min_x AND spot_list.x LE loc_max_x,ct_list)

IF ct_list GT 0 THEN BEGIN
list = spot_list(w_list)


;compute the autocorrelation matrix of list for the distance :
x = list.x & y = list.y
dist_correl = ((x # REPLICATE(1,N_ELEMENTS(x))) - (REPLICATE(1,N_ELEMENTS(x)) # x))^2 + ((y # REPLICATE(1,N_ELEMENTS(y))) - (REPLICATE(1,N_ELEMENTS(y)) # y))^2

;where are the overlaps
w_ovlp = WHERE((dist_correl GT 0) AND (dist_correl LE dist^2), c_ovlp)

IF c_ovlp GT 0 THEN BEGIN

j_ovlp = IMAGINARY(WHERESUB(w_ovlp,dist_correl))
spot_list(w_list(j_ovlp)).ovlp = 1

ENDIF ; c_ovlp gt 0
ENDIF ; ct_list gt 0
ENDFOR ; col 

dum = WHERE(spot_list.ovlp EQ 1,n_ovlp)
PRINT,STRCOMPRESS('Number of reflexion overlapped [reference spots selection] :'+ STRING(n_ovlp)+' ie :'+STRING(n_ovlp/FLOAT(size_list)*100)+' %')

END








