FUNCTION DRAW_SELECT_BAD,pred,bad_sel,n_found
;+
; NAME:
;	DRAW_SELECT_BAD.PRO
;
; PURPOSE:
;	Selects bad selection from PROW integration
;
; CATEGORY:
;	Crystallography processing.
;
; CALLING SEQUENCE:
;	pred_ok = DRAW_SELECT_BAD(pred,bad_sel,n_found)
;
; INPUTS:
;	pred : input structure containing all potential reflexions. Should contain field .m
;	bad_sel : flag for which type of bad reflexions :
;		 0:all, 1:bad_bg, 2: bad_fit, 3: ovlp, 4: non_ovlp
; OUTPUTS:
;	n_found : number of found reflexions
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, May 97.
;-


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


CASE bad_sel OF 
 0: pred2=pred
 1: BEGIN
  w_bad = WHERE(pred.flag EQ 1,n_found)
  IF n_found GT 0 THEN pred2=pred(w_bad)
    END
 2: BEGIN
  w_bad = WHERE(pred.flag EQ 2,n_found)
  IF n_found GT 0 THEN pred2=pred(w_bad) 
    END
 3: BEGIN
  w_ovlp = WHERE(pred.ovlp GE 1,n_found)
  IF n_found GT 0 THEN pred2=pred(w_ovlp) 
    END
 4: BEGIN
  w_ovlp = WHERE(pred.ovlp EQ 0,n_found)
  IF n_found GT 0 THEN pred2=pred(w_ovlp) 
   END
ENDCASE

IF n_found GT 0 THEN RETURN,pred2 ELSE RETURN,0

END


