pro DRAW_RES_CIRCLES, state,image_state,n_circles
;+
; NAME:
;	DRAW_RES_CIRCLES
;
; PURPOSE:
;	Draw resolution circles for the PROW widget application
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_RES_CIRCLES,state,image_state,n_circles
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

;get the state from PROW_DRAW
;WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY

WSET,image_state.draw_back_win1

;define the beam center on the image
x0=state.diff_par.cenx/image_state.bin_fac
y0=state.diff_par.ceny/image_state.bin_fac
IF N_ELEMENTS(n_circles) EQ 0 THEN n_circles=5
;biggest distance between beam center and the 4 corners
d1=x0^2+y0^2
d2=(x0-!d.x_size-1)^2+y0^2
d3=x0^2+(y0-!d.y_size-1)^2
d4=(x0-!d.x_size-1)^2+(y0-!d.y_size-1)^2
max_d=MAX([d1,d2,d3,d4])
r=LONG((INDGEN(n_circles)+1)*SQRT(max_d)/(n_circles+1))

WSET,image_state.draw_back_win1
DEVICE,SET_GRAPHICS=6
FOR i=0,n_circles-1 DO	dum=CIRCLE(x0,y0,r(i),/SHOW)
;restore the state from PROW_DRAW
DEVICE,SET_GRAPHICS=3

WSET,image_state.draw_back_win2
DEVICE,SET_GRAPHICS=6
FOR i=0,n_circles-1 DO	dum=CIRCLE(x0,y0,r(i),/SHOW)
;restore the state from PROW_DRAW
DEVICE,SET_GRAPHICS=3

WSET,image_state.draw_win
IF image_state.pred.status THEN $ ;if preds displayed
 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,image_state.draw_back_win2] $
ELSE $ ;if ne preds displayed
 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,image_state.draw_back_win1]

;change the state
state.res_circles=1-state.res_circles

;WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY


END








