pro DRAW_PULL_ANALYSIS,state,main_state,event
;+
; NAME:
;	DRAW_PULL_ANALYSIS
;
; PURPOSE:
;	Manages analysis pull down menu.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PULL_ANALYSIS,state,main_state,event
;
; INPUTS:
;	state: the state as defined in the widget program PROW_DRAW
;	main_state: the state as defined in the widget program LOOK_MAR18.
;	event: the event related to the choice in the pull down menu
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

COMMON SHARE_PROW,pred,sel_pred,par

CASE event.value OF 
 'Analysis.Profile.Set_Fraction' :	BEGIN
	field={fraction :100}
	field_title=['Enter fraction of maximum intensity [%] : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL)
	state.profile.fraction=field.fraction
				   	END

 'Analysis.Profile.Show' : 		BEGIN
	WSET,state.draw_win
	max_image = MAX(*state.orig_image)
	WIDGET_CONTROL,state.info,SET_VALUE='Zoom_Profile : Left mouse to toggle between rows and columns, Right mouse to quit'
	DRAW_MAIN_PROFILE,(*state.orig_image)<(max_image*state.profile.fraction/100.),state.study_win,BIN_FAC=state.bin_fac
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	WSET,state.study_win
					END

 'Analysis.Zoom_Profile' : 		BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='Zoom_Profile : Left mouse for profile, Right mouse to quit'
	WSET,state.zoom_win
	profile = DRAW_PROFILE(state.zoom,*state.zoom_image,state.study_win)
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	WSET,state.study_win
					END

 'Analysis.Spot_Shape.Parameters' : 	BEGIN
        bsx=state.spot_shape.boxsize_x
        bsy=state.spot_shape.boxsize_y
        fraction=state.spot_shape.fraction
        bc_sub=STRING(state.spot_shape.bc_sub)
	field={boxsize_x:bsx,boxsize_y:bsy,fraction:fraction,bc_sub:[bc_sub,'Yes','No']}
	field_title=['Box size in X [raster] : ','Box size in Y [raster] : ','Fraction of maximum intensity [%]','Subtract background ?']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL),ACTION=action
	IF action EQ 'DO' THEN BEGIN
	 state.spot_shape.fraction=field.fraction
	 state.spot_shape.boxsize_x=field.boxsize_x
	 state.spot_shape.boxsize_y=field.boxsize_y
	 state.boxinteg.boxsize.x=field.boxsize_x
	 state.boxinteg.boxsize.y=field.boxsize_y
	 state.fwhm.boxsize_x=field.boxsize_x
	 state.fwhm.boxsize_y=field.boxsize_y
	 state.spot_shape.bc_sub=FIX(field.bc_sub(0))
	ENDIF
					END


 'Analysis.Spot_Shape.Show' : 		BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='Spot_Shape : Left mouse for new spot, Right mouse to quit'
	boxsize={box,x:state.scale*state.spot_shape.boxsize_x,y:state.scale*state.spot_shape.boxsize_y}
	DRAW_PICK_SPOTS,state
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
					END

 'Analysis.Statistics.On_Zoom_Image' : 	BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='Statistics : see the table ...'
	DRAW_STATISTICS,state,GROUP=event.top
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
					END

 'Analysis.Statistics.On_Full_Image' : 	BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='Statistics : see the table ... This may take a long time'
	DRAW_STATISTICS,state,GROUP=event.top,/FULL
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
					END

 'Analysis.Box_integration.Parameters': BEGIN
        bsx=state.boxinteg.boxsize.x
        bsy=state.boxinteg.boxsize.y
	field={boxsize_x:bsx,boxsize_y:bsy}
	field_title=['Box size in X [raster] : ','Box size in Y [raster] : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL)
	IF action EQ 'DO' THEN BEGIN
	 state.boxinteg.boxsize.x=field.boxsize_x
	 state.boxinteg.boxsize.y=field.boxsize_y
	 state.fwhm.boxsize_x=field.boxsize_x
	 state.fwhm.boxsize_y=field.boxsize_y
	 state.spot_shape.boxsize_x=field.boxsize_x
	 state.spot_shape.boxsize_y=field.boxsize_y
	ENDIF
					END

 'Analysis.Box_integration.Integrate' : BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='Resetting zoom scale to 1 ...'
	state.scale=1
	WIDGET_CONTROL,state.slide,SET_VALUE=state.scale 
        draw_zoom, state, state.oldx, state.oldy,main_state
	WIDGET_CONTROL,state.info,SET_VALUE='Box integration : Pick spot with left mouse on zoom window, Right mouse to quit ...'
	DRAW_BOXINTEG,*state.zoom_image,state.zoom,state.study,state.xyz_show,state.boxinteg.boxsize,main_state.det_par.gain,main_state.det_par.offset
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	WSET,state.study_win
					END

 'Analysis.FWHM.Parameters' :		BEGIN
	field={boxsize_x:state.fwhm.boxsize_x,boxsize_y:state.fwhm.boxsize_y,fraction:state.fwhm.fraction}
	field_title=['Box size in X [raster] : ','Box size in Y [raster] : ','Fraction of maximum intensity [%]']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL)
	state.fwhm.fraction=field.fraction
	state.fwhm.boxsize_x=field.boxsize_x
	state.fwhm.boxsize_y=field.boxsize_y
	state.boxinteg.boxsize.x=field.boxsize_x
	state.boxinteg.boxsize.y=field.boxsize_y
	state.spot_shape.boxsize_x=field.boxsize_x
	state.spot_shape.boxsize_y=field.boxsize_y
					END

 'Analysis.FWHM.Contours' :	 	BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='FWHM : Pick spot with left mouse on zoom window, Right mouse to quit ...'
	boxsize={box,x:state.fwhm.boxsize_x,y:state.fwhm.boxsize_y}
	DRAW_CONTOUR,*state.zoom_image,state.zoom,state.study,state.xyz_show,state.scale,boxsize,FRACTION=state.fwhm.fraction
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	WSET,state.study_win
					END

 'Analysis.FWHM.Calculate' :		BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE='FWHM : Pick spot with left mouse on zoom window, Right mouse to quit ...'
	boxsize={box,x:state.fwhm.boxsize_x,y:state.fwhm.boxsize_y}
	DRAW_FWHM,*state.zoom_image,state.zoom,state.study,state.xyz_show,state.scale,boxsize,FRACTION=state.fwhm.fraction
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	WSET,state.study_win
					END


 'Analysis.Predictions.Parameters' :	BEGIN
	type=STRING(state.pred.type)
    	show_sel=STRING(state.pred.show_sel)
	hkl_sel=state.pred.hkl_sel
	bad_sel=STRING(state.pred.bad_sel)

	field= {$
	 	type:[type,'Denzo (York)','Denzo (Normal)','Prow','Ref','Geasc'], $
		show_sel:[show_sel,'Show all reflexions','Select reflexions'], $
		hkl_sel:hkl_sel, $
		bad_sel:[bad_sel,'all spots','bad background','bad fit','overlaped','non overlaped'] $
		}

	field_title=['Prediction Format : ', 'Select reflexions','Enter type of hkl reflexions','Type of PROW spots']
	flags=['1','1','w(1) eq 1','w(0) eq 2']
	;help='DRAW_HELP,''Input format : [h,k,l] or [nh[+1],nk[+1],nl[+1]]). Example : 4,2k+1,4l]'',title=''Type of reflexions''
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=30,ACTION=action,FLAGS=flags,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'help_predformat.txt',/REMOVE_ALL)
	IF action EQ 'DO' THEN BEGIN
 	 state.pred.type=FIX(field.type(0))
	 state.pred.show_sel=FIX(field.show_sel(0))
	 state.pred.hkl_sel=field.hkl_sel
	 IF state.pred.type EQ 2 THEN state.pred.bad_sel=FIX(field.bad_sel(0)) ELSE state.pred.bad_sel=0
	 IF state.pred.loaded THEN BEGIN ; some preds were loaded
	  WSET,state.draw_back_win2
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win1]  ;Restore Original image from draw_back_win1
	  WSET,state.zoom_back_win2
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win1]  ;Restore Original image from zoom_back_win1

	  IF state.pred.show_sel THEN sel_pred=DRAW_SELECT_HKL(pred,state.pred.hkl_sel,n_found) ELSE BEGIN
	   sel_pred=pred 
	   n_found=(SIZE(pred))(1)
	  ENDELSE

	  IF state.pred.bad_sel GT 0 THEN sel_pred=DRAW_SELECT_BAD(sel_pred,state.pred.bad_sel,n_found)

   	 IF n_found EQ 0 THEN ok=WIDGET_MESSAGE('No spot was found ...')
	  IF n_found GE 1 THEN BEGIN 
	   WIDGET_CONTROL,state.info,SET_VALUE=STRCOMPRESS(STRING(n_found)+' spots were found ...')
	   WSET,state.draw_back_win2
	   dummy=DRAW_PRED(sel_pred,state.x_im_sz/FLOAT(state.bin_fac),state.y_im_sz/FLOAT(state.bin_fac),state.bin_fac,par,0,0,main_state,DRAW=state.boxinteg.boxsize) ;redraw it 
	   WSET,state.zoom_back_win2
	   dummy=DRAW_PRED(sel_pred,state.x_zm_sz,state.y_zm_sz,1./state.scale,par,state.x0,state.y0,main_state,DRAW=state.boxinteg.boxsize) ;redraw it 
	  ENDIF ELSE WIDGET_CONTROL,state.info,SET_VALUE='Info : No reflexion found !'
	  IF state.pred.status THEN BEGIN
		    WSET,state.draw_win
		    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win2]  ;Restore Image+Preds from draw_back_win2
		    WSET,state.zoom_win
		    DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win2]  ;Restore Image+Preds from draw_zoom_win2
	  ENDIF
	 ENDIF ;  some predictions loaded
	ENDIF ; action eq 'do'
					END


 'Analysis.Predictions.Load' :		BEGIN
	;check if some preds already loaded. If yes erase old
	IF state.pred.loaded THEN BEGIN ; if preds already loaded
	 IF state.pred.status THEN BEGIN ; if preds displayed
	  WSET,state.draw_win
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win1]  ;Restore Original image from draw_back_win1
	  WSET,state.zoom_win
	  DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win1]  ;Restore Original image from zoom_back_win1
	 ENDIF ;preds displayed
	ENDIF ; preds already loaded

	WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose a predictions file ...'
	CASE state.pred.type OF
	 0: BEGIN ; DENZO YORK
		pred_file=PICKFILE(/READ,PATH=state.pred.path,GET_PATH=dir,FILTER=['*.x*'])
		IF pred_file EQ '' THEN BEGIN
		 WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		 GOTO,give_up_pred
		ENDIF
		state.pred.path=dir
		pred = READ_DENZOX(pred_file,par,RASTER=main_state.diff_par.raster) ;load the preds
	    END


	 1: BEGIN ; DENZO NO YORK
		pred_file=PICKFILE(/READ,PATH=state.pred.path,GET_PATH=dir,FILTER=['*.x*'])
		IF pred_file EQ '' THEN BEGIN
		 WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		 GOTO,give_up_pred
		ENDIF
		state.pred.path=dir
		pred = READ_DENZOX(pred_file,par,/NOYORK,RASTER=main_state.diff_par.raster) ;load the preds
	    END

	 2: BEGIN ; PROW
		pred_file=PICKFILE(/READ,PATH=state.pred.path,GET_PATH=dir,FILTER=['*.prow'])
		IF pred_file EQ '' THEN BEGIN
		 WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		 GOTO,give_up_pred
		ENDIF
		state.pred.path=dir

		RESTORE,pred_file
		pred=integ
	    END

	 3: BEGIN ; REF FILE
		pred_file=PICKFILE(/READ,PATH=state.pred.path,GET_PATH=dir,FILTER=['*.prow'])
		IF pred_file EQ '' THEN BEGIN
		 WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		 GOTO,give_up_pred
		ENDIF
		state.pred.path=dir

		RESTORE,pred_file
		pred=ref_spots
	    END

	 4: BEGIN ; GEASC FILE
		pred_file=PICKFILE(/READ,PATH=state.pred.path,GET_PATH=dir,FILTER=['*.geasc'])
		IF pred_file EQ '' THEN BEGIN
		 WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
		 GOTO,give_up_pred
		ENDIF
		state.pred.path=dir
		root_pred_file=STRTRIM(STR_REPLACE(pred_file,'.geasc',''))
		pred = READ_GEASC2(root_pred_file, par)
	    END

	    ELSE: PRINT,'Error ...'
	   ENDCASE


	;remove resolution circles if present
	IF main_state.res_circles THEN BEGIN
	 DRAW_RES_CIRCLES,main_state,state ;erase
	 main_state.res_circles=1
	ENDIF

	main_state.diff_par.distance=par.cdd
	main_state.diff_par.lambda=par.wave
	main_state.diff_par.raster=par.raster
	main_state.diff_par.cenx=par.cenx
	main_state.diff_par.ceny=par.ceny

 
	;redraw resolution circles if present
	IF main_state.res_circles THEN BEGIN
	 DRAW_RES_CIRCLES,main_state,state ;erase
	 main_state.res_circles=1
	ENDIF

	state.pred.loaded=1 ; preds were loaded
	IF state.pred.show_sel THEN sel_pred=DRAW_SELECT_HKL(pred,state.pred.hkl_sel,n_found) ELSE sel_pred=pred & n_found=(SIZE(pred))(1)
	IF state.pred.bad_sel GT 0 THEN sel_pred=DRAW_SELECT_BAD(sel_pred,state.pred.bad_sel,n_found) 

	IF n_found EQ 0 THEN ok=WIDGET_MESSAGE('No spot was found ...')
	IF n_found GE 1 THEN BEGIN
	 WIDGET_CONTROL,state.info,SET_VALUE=STRCOMPRESS(STRING(n_found)+' spots were found ...')
	 WSET,state.draw_win
	 dummy=DRAW_PRED(sel_pred,state.x_im_sz/FLOAT(state.bin_fac),state.y_im_sz/FLOAT(state.bin_fac),state.bin_fac,par,0,0,main_state,DRAW=state.boxinteg.boxsize) ;redraw it 
	 WSET,state.zoom_win
	 dummy=DRAW_PRED(sel_pred,state.x_zm_sz,state.y_zm_sz,1./state.scale,par,state.x0,state.y0,main_state,DRAW=state.boxinteg.boxsize) ;redraw it 
	 state.pred.status=1
 	 WSET,state.draw_back_win2
	 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_win]  ; Put Image + Preds in draw_back_win2
 	 WSET,state.zoom_back_win2
	 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_win]  ; Put Image + Preds in zoom_back_win2
	ENDIF

	give_up_pred:
	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
					END


 'Analysis.Predictions.Toggle_On_Off' :	BEGIN
	IF state.pred.loaded THEN BEGIN ;if some reflexion loaded
	IF state.pred.status THEN BEGIN ; toggle off
	 PRINT,'Removing preds'
	 WSET,state.draw_win
	 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win1]  ;Restore Original image from draw_back_win1
	 WSET,state.zoom_win
	 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win1]  ;Restore Original image from zoom_back_win1
  	ENDIF ELSE BEGIN ; toggle on
 	 PRINT,'Drawing back preds'
	 WSET,state.draw_win
	 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.draw_back_win2]  ;Restore Original image+preds from draw_back_win1
	 WSET,state.zoom_win
	 DEVICE, copy = [0,0, !d.x_size, !d.y_size, 0, 0,state.zoom_back_win2]  ;Restore Original image+preds from zoom_back_win1
	ENDELSE
	state.pred.status=1-state.pred.status
	ENDIF ELSE WIDGET_CONTROL,state.info,SET_VALUE='Info : No prediction file loaded !'
						END
	
'Analysis.Predictions.Analyse' :		BEGIN
	IF NOT state.pred.loaded THEN BEGIN ; if preds not already loaded 
	 WIDGET_CONTROL,state.info,SET_VALUE='Info : No prediction file loaded !'
	 WAIT,1
	 GOTO,give_up_pred_analyse
	ENDIF

	WIDGET_CONTROL,state.info,SET_VALUE='Info : Click on a spot with left mouse, (right mouse to quit) ...'
	info_id = DRAW_INFO(TITLE='Infos for pred''s :',XSIZE=550,YSIZE=280)
	state.pop_info=info_id
	DRAW_INSPECT_PRED,state
	WIDGET_CONTROL,state.pop_info,/DESTROY		
	give_up_pred_analyse:
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
						END


	ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : Error !'
	ENDCASE
END

