
PRO DRAW_LINE,x_first,y_first,x_last,y_last,xx,yy

;Draw a line between [x_first,y_first] and [x_last,y_last]
;draw_win is the window where the user drags the mouse
;profile_win is the window where the profile is plotted
;do_plot is 1 if the profile is to be plotted
; Use the XOR drawing mode.
IF (x_first EQ x_last) AND (y_first EQ y_last) THEN RETURN

dx = float(x_last-x_first)		;delta x
dy = float(y_last-y_first)
n = abs(dx) > abs(dy)
;
r = fltarr(n+1)
;
s=1
if abs(dx) gt abs(dy) then begin
	if x_last ge x_first then s=1 else s=-1
	sy = (y_last-y_first)/abs(dx)
   endif else begin
	if y_last ge y_first then sy=1 else sy=-1
	if abs(dy) ne 0 then s = (x_last-x_first)/abs(dy)
   endelse
;
xx = indgen(n+1l)*s+x_first		;X values, make into longwords.
yy = indgen(n+1l)*sy+y_first		;Y values
         
	;show the line between (x_first,y_first) and (x_last,y_last)
	DEVICE, SET_GRAPHICS=6          ;Xor drawing mode   
	col = 1
	while col lt !d.table_size do col = col + col
        plots,[[x_first,y_first],[x_last,y_last]],/dev,color=col	
       	DEVICE, SET_GRAPHICS=3          ; Reset copy mode
END



function draw_profile, draw_id, image, profile_win, xx, yy, xstart = x0, ystart = y0, nomark = nomark
;+
; NAME:
;	DRAW_PROFILE
;
;
; PURPOSE:
;	Extract a profile from an image. 
;	The profile can be tilted. It is displayed interactively on a window
;
; CATEGORY:
;	Image processing.
;
; CALLING SEQUENCE:
;	Result = DRAW_PROFILE(draw_id, image, profile_win,XX, YY)
;
; INPUTS:
;	draw_id : the widget id of the draw window where image is displayed.
;	Image:	The data array representing the image.  This array can be
;		of any type except complex.
;
; KEYWORD PARAMETERS:
;      XSTART:	The starting X location of the lower-left corner of Image.
;		If this keyword is not specified, 0 is assumed.
;
;      YSTART:	The starting Y location of the lower-left corner of Image.
;		If this keyword is not specified, 0 is assumed.
;
;     NONMARK:	Set this keyword to inhibit marking the image with the 
;		profile line.
;
; OUTPUTS:
;	PROFILE returns a floating-point vector containing the values of
;	the image along the profile line marked by the user.
;
; OPTIONAL OUTPUTS:
;	XX:	After picking the end points, XX contains the X coordinates
;		of the points along the selected profile.
;
;	YY:	After picking the end points, YY contains the Y coordinates
;		of the points along the selected profile.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	Cursor on image display is enabled.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Allow the operator to mark two points on the
;	image display with the joystick.  Extract and
;	return the points along the line.  Optionally
;	return the X and Y values of each extracted point.
;
; EXAMPLE:
;	Display an image, select a profile and plot that profile in a new
;	window.  Create and display an image by entering:
;
;		A = BYTSCL(DIST(256))
;		TV, A
;
;	Extract a profile from the image.  Enter the following command and
;	mark two points on the image with the mouse:
;
;		R = PROFILE(A)
;
;	Create a new plotting window and plot the profile by entering:
;
;		WINDOW, /FREE
;		PLOT, R
;
;	An interactive version of this routine is available with the User
;	Library procedure PROFILES.
;
; MODIFICATION HISTORY:
;	Written, DMS, November, 1982.
;	Modified for Sun, march, 1988.
;	December 1991, KRC  Made PROFILES return XX and YY.
;       February 1993 : modification by Dominique Bourgeois
;       May 1997 : modification by Dominique Bourgeois
;-

;get the window number of the drawing widget
WIDGET_CONTROL, draw_id, GET_VALUE=draw_win
WSET, draw_win   

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

WSHOW, draw_win
button = 0
x_first = 0
y_first = 0
x_last = 0
y_last = 0

WHILE 1 DO BEGIN                ;Internal event loop   
 ;wait for an event from the drawing window
 ev = WIDGET_EVENT([draw_id])
        		
 x = ev.x    ;Pixel coordinates
 y = ev.y

 button = button or  ev.press xor ev.release
 IF ev.press THEN BEGIN
  DRAW_LINE,x_first,y_first,x_last,y_last ; remove old line
  x_first=x
  y_first=y
  x_last=x
  y_last=y
 ENDIF
 IF button THEN BEGIN
  DRAW_LINE,x_first,y_first,x_last,y_last ; remove old line
  x_last=x
  y_last=y
  IF (x_first NE x_last) OR (y_first NE y_last) THEN BEGIN
   DRAW_LINE,x_first,y_first,x_last,y_last,xx,yy ; draw new line
   ;plot the corresponding profile
   WSET,profile_win  ;swap to window 2
   PLOT,image(long(yy)*imageX + xx)
   ;TEMPORARY
   ;tmp=image(long(yy)*imageX + xx)
   ;SAVE,tmp,file='profile.idl'
   ;TEMPORARY
   WSET,draw_win  ; come back to window 1
  ENDIF
 ENDIF

 IF button EQ 4 THEN BEGIN
  DRAW_LINE,x_first,y_first,x_last,y_last,xx,yy ; draw new line
  GOTO,cut_loop
 ENDIF
ENDWHILE
cut_loop:
END




