function DRAW_PRED,preds,xsize,ysize,bin_fac,par,x0,y0,main_state,color=color,print=print,PSX=psx,PSY=psy,draw=draw
;+
; NAME:
;	DRAW_PRED
;
; PURPOSE:
;	Draws squares around predicted spots.
;	Optionnaly prints out positions of the predicted spots. 
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	pos = DRAW_PRED(preds,xsize,ysize,bin_fac,par,$
;		COLOR=color,PRINT=print,PSX=psx,PSY=psy,draw=draw
;
; INPUTS:
;	preds : a list of predictions (a structure produced for exemple
;		with the routine READ_DENZOX). The structure must contain 
;		the following fields : .x ; .y
;	xsize : the image x size
;	ysize : the image y size
;	bin_fac : the binning factor
;	par : the parameter from the routine READ_DENZOX (or equivalent). 
;	      Must contain the following fields : .cenx ; .ceny ; .yscale ;
;	      .raster.
;	x0 : the x-coordinate origin of the image
;	y0 : the y-coordinate origin of the image
;	main_state : the PROW state
;	color : the boxes are painted with color=!D.N_COLORS-color
;	print : keyword set if the coordinates of the spots are to be printed
;	psx   : keyword set to !D.X_SIZE('ps'device)/!D.X_SIZE('x'device) if 
;		plotting to ps device. 
;	psy   : keyword set to !D.Y_SIZE('ps'device)/!D.Y_SIZE('x'device) if 
;		plotting to ps device. 
;	draw : the size of the box
;
; OUTPUTS:
;	pos : the positions of the spots on the image "red"
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 97., March 98.
;-

!ERR = 0
;position of the center of the image
centerX = par.cenx-1
centerY = par.ceny-1

;y scale
scaleY = par.yscale

;original pixel size [micrometers]
pix_sizeX = 0.001*par.raster
pix_sizeY = 0.001*par.raster/scaleY


;position of the studied area relative to the center of the beam [mm]
minX = pix_sizeX*(x0-centerX)
minY = pix_sizeY*(y0-centerY)
maxX = pix_sizeX*(x0-centerX+xsize*bin_fac-1)
maxY = pix_sizeY*(y0-centerY+ysize*bin_fac-1)
IF (SIZE(preds))(0) EQ 0 THEN RETURN,0
w_preds=WHERE((preds(*).x GE minX) AND $
		    (preds(*).x LE maxX) AND $
		    (preds(*).y GE minY) AND $
		    (preds(*).y LE maxY),n_preds)

PRINT,'Number of spots selected : ',n_preds

IF NOT KEYWORD_SET(color) THEN color=1

;plot the X-ray beam center
;  pos_cenx =  FIX(centerX - x0)/FLOAT(bin_fac)
;  pos_ceny =  FIX(centerY - y0)/FLOAT(bin_fac)

  pos_cenx =  FIX((centerX - x0)/FLOAT(bin_fac))
  pos_ceny =  FIX((centerY - y0)/FLOAT(bin_fac))

  lower_x = pos_cenx - FIX(draw.x/2.)/FLOAT(bin_fac)
  upper_x = pos_cenx + FIX(draw.y/2.)/FLOAT(bin_fac)
  lower_y = pos_ceny - FIX(draw.x/2.)/FLOAT(bin_fac) 
  upper_y = pos_ceny + FIX(draw.y/2.)/FLOAT(bin_fac)

  IF N_ELEMENTS(psx) NE 0 AND N_ELEMENTS(psy) NE 0 THEN BEGIN
   lower_x = lower_x*psx
   upper_x = upper_x*psx
   lower_y = lower_y*psy
   upper_y = upper_y*psy
   pos_cenx = pos_cenx*psx
   pos_ceny = pos_ceny*psy
  ENDIF
  PLOTS,[pos_cenx,pos_cenx],[lower_y,upper_y],/DEVICE,COLOR=!D.N_COLORS-color
  PLOTS,[lower_x,upper_x],[pos_ceny,pos_ceny],/DEVICE,COLOR=!D.N_COLORS-color

IF n_preds EQ 0 THEN RETURN,0

roi_preds = preds(w_preds)


pos = LONARR((SIZE(roi_preds))(1),2)

pos(*,0) = FIX((roi_preds(*).x/pix_sizeX + centerX - x0))/FLOAT(bin_fac)
pos(*,1) = FIX((roi_preds(*).y/pix_sizeY + centerY - y0))/FLOAT(bin_fac)

draw_region=0

  IF bin_fac LE 0.25 THEN BEGIN
   ;is the tag "overall_region" existing in par
   exist=0
   FOR loc_i=0,N_TAGS(par)-1 DO BEGIN
    IF (TAG_NAMES(par))(loc_i) EQ 'OVERALL_REGION' THEN exist=1
   ENDFOR 
   IF exist THEN BEGIN
	reg=par.overall_region
	xreg_size=par.boxsize.x & yreg_size=par.boxsize.y
   ENDIF

    IF exist EQ 0 THEN BEGIN
     file=FINDFILE(main_state.diff_integ.regionfile,COUNT=count)
     IF count NE 0 THEN BEGIN
      exist=1
      RESTORE,file(0)
      reg=region
      xreg_size=main_state.diff_integ.boxsize.x
      yreg_size=main_state.diff_integ.boxsize.y
     ENDIF
    ENDIF
    IF exist EQ 0 THEN BEGIN
	GOTO,cut_region
    ENDIF

   draw_region=1
   ext_reg = GET_ENLARGED_REGION(reg,xreg_size,yreg_size,/REVERSE,/UP_RIGHT)

   border_reg=ext_reg
   xy_reg = WHERESUB(ext_reg,LONARR(xreg_size,yreg_size,/NOZERO))	
   ct_reg = (SIZE(ext_reg))(1)

   ;select the border
   FOR loc_i=0,ct_reg-1 DO BEGIN
    x = FLOAT(xy_reg(loc_i)) & y = IMAGINARY(xy_reg(loc_i))

    ;must check for [x-1,y-1],[x,y-1],[x+1,y-1],[x-1,y],[x+1,y],[x-1,y+1],[x,y+1],[x+1,y+1]
    w_check = WHERE( 	(FLOAT(xy_reg) EQ (x-1) AND IMAGINARY(xy_reg) EQ (y-1)) OR $
			(FLOAT(xy_reg) EQ (x) AND IMAGINARY(xy_reg) EQ (y-1)) OR $
			(FLOAT(xy_reg) EQ (x+1) AND IMAGINARY(xy_reg) EQ (y-1)) OR $
			(FLOAT(xy_reg) EQ (x-1) AND IMAGINARY(xy_reg) EQ (y)) OR $
			(FLOAT(xy_reg) EQ (x+1) AND IMAGINARY(xy_reg) EQ (y)) OR $
			(FLOAT(xy_reg) EQ (x-1) AND IMAGINARY(xy_reg) EQ (y+1)) OR $
			(FLOAT(xy_reg) EQ (x) AND IMAGINARY(xy_reg) EQ (y+1)) OR $
			(FLOAT(xy_reg) EQ (x+1) AND IMAGINARY(xy_reg) EQ (y+1)), $
			ct_check)
   IF ct_check LT 8 THEN border_reg(loc_i)=1 ELSE border_reg(loc_i)=0
   ENDFOR

   xy_border=xy_reg(WHERE(border_reg EQ 1,ct_border))  
   ;gen_border = gen_reg & gen_border(*)=0 & gen_border(w_reg(WHERE(border_reg EQ 1)))=1 
   ;SURFACE,gen_border

   ;need to reorganize 
   used_border=BYTARR(ct_border+1)
   xy_border2=xy_border
   used_border(0)=1 &   used_border(ct_border)=1
   FOR loc_i=0,ct_border-2 DO BEGIN
    w_free = WHERE(used_border EQ 0,ct_free)
    min_dist = MIN(FLOAT(xy_border(w_free)-xy_border2(loc_i))^2 + IMAGINARY(xy_border(w_free)-xy_border2(loc_i))^2)
    w=WHERE(FLOAT(xy_border(w_free)-xy_border2(loc_i))^2 + IMAGINARY(xy_border(w_free)-xy_border2(loc_i))^2 EQ min_dist,ct_w)
   IF ct_w GT 1 AND loc_i NE 0 THEN BEGIN
    ;take the one which is closer to xy_border2(loc_i-1)
    min_dist2 = MIN(FLOAT(xy_border(w_free(w))-xy_border2(loc_i-1))^2 + IMAGINARY(xy_border(w_free(w))-xy_border2(loc_i-1))^2)
    w2=WHERE(FLOAT(xy_border(w_free(w))-xy_border2(loc_i-1))^2 + IMAGINARY(xy_border(w_free(w))-xy_border2(loc_i-1))^2 EQ min_dist2,ct_w2)
    w=w(w2(0))
   ENDIF ELSE  w=w(0)
    xy_border2(loc_i+1)=xy_border(w_free(w))
    used_border(w_free(w))=1
   ENDFOR
  cut_region:
  ENDIF



FOR i=0L, (SIZE(roi_preds))(1)-1 DO BEGIN

 IF KEYWORD_SET(print) THEN BEGIN
  PRINT,'X position [pixels] :', pos(i,0)
  PRINT,'Y position [pixels] :', pos(i,1)
 ENDIF

  lower_x = pos(i,0) - FIX(FIX(draw.x/2.)/FLOAT(bin_fac))
  upper_x = pos(i,0) + FIX(FIX(1+draw.x/2.)/FLOAT(bin_fac))
  lower_y = pos(i,1) - FIX(FIX(draw.y/2.)/FLOAT(bin_fac))
  upper_y = pos(i,1) + FIX(FIX(1+draw.y/2.)/FLOAT(bin_fac))

  IF N_ELEMENTS(psx) NE 0 AND N_ELEMENTS(psy) NE 0 THEN BEGIN
   lower_x = lower_x*psx
   upper_x = upper_x*psx
   lower_y = lower_y*psy
   upper_y = upper_y*psy
  ENDIF

  PLOTS,[lower_x,upper_x,upper_x,lower_x,lower_x],[lower_y,lower_y,upper_y,upper_y,lower_y],/DEVICE,COLOR=!D.N_COLORS-color

 IF draw_region THEN BEGIN
  border = LONARR(2,ct_border+1)
  FOR loc_i=0,ct_border-1 DO BEGIN
   border(0,loc_i) = pos(i,0)+FIX(FIX(FLOAT(xy_border2(loc_i)) - FIX(xreg_size/2))/FLOAT(bin_fac))
   border(1,loc_i) = pos(i,1)+FIX(FIX(IMAGINARY(xy_border2(loc_i)) - FIX(yreg_size/2))/FLOAT(bin_fac))
  ENDFOR
  border(*,ct_border) = border(*,0) 
 
  IF N_ELEMENTS(psx) NE 0 AND N_ELEMENTS(psy) NE 0 THEN BEGIN
   border(0,*) = border(0,*)*psx
   border(1,*) = border(1,*)*psy
  ENDIF

  PLOTS,border(0,*),border(1,*),/DEVICE,COLOR=!D.N_COLORS-color-2
 ENDIF


ENDFOR

RETURN,pos
END








