pro DRAW_PICK_SPOTS,state
;+
; NAME:
;	DRAW_PICK_SPOTS
;
; PURPOSE:
;	Interactively shows spots from an image.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PICK_SPOTS,state
;
; INPUTS:
;	state : the state (a structure) containing the state of the 
;		widget application.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	The user clicks with left mouse on one spot.
;	Click on the right mouse to leave.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-


;get the window number of the drawing widget
main_win=state.draw_win
zoom_win=state.zoom_win

WSET, zoom_win   

button = 0

;size of "image"
;imageX = (size(*state.zoom_image))(1)
;imageY = (size(*state.zoom_image))(2)
;get image size
imageX = state.x_im_sz
imageY = state.y_im_sz


;get the proper "fraction"
fraction=state.spot_shape.fraction

;subtract background ?
bc_sub=state.spot_shape.bc_sub

;boxsize={box,x:state.scale*state.spot_shape.boxsize_x,y:state.scale*state.spot_shape.boxsize_y}
boxsize={box,x:state.spot_shape.boxsize_x,y:state.spot_shape.boxsize_y}

WHILE 1 DO BEGIN                ;Internal event loop   
	;wait for an event from the drawing window
    	ev = WIDGET_EVENT([state.draw,state.zoom])
	win_id=ev.id ; from which window
	button = ev.press  ;New button state   
	IF button EQ 4 THEN GOTO,cut_loop
	IF button EQ 1 THEN BEGIN
	 IF win_id EQ state.draw THEN BEGIN ;in main drawing window
   	  x = state.bin_fac*ev.x    ;Pixel coordinates
   	  y = state.bin_fac*ev.y
	 ENDIF ELSE BEGIN ; in zoom window
   	  x = state.x0+ROUND(ev.x/state.scale)    ;Pixel coordinates
   	  y = state.y0+ROUND(ev.y/state.scale)
  	 ENDELSE

	 box = (*state.orig_image)(MAX([0,x-boxsize.x/2]):MIN([imageX-1,x+boxsize.x/2]),$
	     MAX([0,y-boxsize.y/2]):MIN([imageY-1,y+boxsize.y/2]))

  	;find proper center of the box. Just consider the central part
  	sbox = (*state.orig_image)(MAX([0,x-4]):MIN([imageX-1,x+4]),MAX([0,y-4]):MIN([imageY-1,y+4]))


	 pos = WHERESUB(WHERE(box EQ MAX(sbox)),box)
	 x = FLOAT(pos(0))+ MAX([0,X-boxsize.x/2])
	 y = IMAGINARY(pos(0))+ MAX([0,Y-boxsize.y/2])

	 box = (*state.orig_image)(MAX([0,x-boxsize.x/2]):MIN([imageX-1,x+boxsize.x/2]),$
	     MAX([0,y-boxsize.y/2]):MIN([imageY-1,y+boxsize.y/2]))

IF NOT bc_sub THEN BEGIN
          bc=BACK2D_POLY4(box,25,2,0,flag)
          IF flag NE 0 THEN PRINT,'Bad backgroud !'
          box=box-bc
ENDIF

	 XSURFACE1,box<(MAX(box))*fraction/100.
	ENDIF
ENDWHILE 
cut_loop : 
END








