pro DRAW_FWHM,image,click_id,show_id,print_id,scale,boxsize,fraction=fraction
;+
; NAME:
;	DRAW_FWHM
;
; PURPOSE:
;	Interactively shows contours of a spot a calculate the long axis
;	length.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_FWHM,image,click_id,show_id,scale,boxsize,fraction=fraction
;
; INPUTS:
;	image : the original data image
;	click_id : the widget id of the click window where the image 
;		is displayed.
;	show_id : the widget id of the draw window where the contour
;		is displayed.
;	print_id : the widget id of the label window where calculated value
;		is displayed.
;	scale : the congrid factor for image
;	boxsize : size of the search box
;	fraction : [optional] contour level at which the contour is displayed
;			and the length calculated.  Default = 50.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	The user clicks with left mouse on one spot.
;	Click on the right mouse to leave.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

;get the window number of the showing widget

WIDGET_CONTROL, show_id, GET_VALUE=show_win
WIDGET_CONTROL, click_id, GET_VALUE=click_win
click_win=!D.WINDOW

button = 0

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

boxsize.x=scale*boxsize.x
boxsize.y=scale*boxsize.y

;get the proper "fraction"
IF NOT KEYWORD_SET(fraction) THEN fraction = 50.

WHILE 1 DO BEGIN                ;Internal event loop   
	;wait for an event from the clicking window
    	ev = WIDGET_EVENT([click_id])
	button = ev.press  ;New button state   
	IF button EQ 4 THEN GOTO,cut_loop
 	 IF ev.press THEN BEGIN

	  x = ev.x    ;Pixel coordinates
	  y = ev.y
	  box = image(MAX([0,x-boxsize.x/2]):MIN([imageX-1,x+boxsize.x/2]),$
	      MAX([0,y-boxsize.y/2]):MIN([imageY-1,y+boxsize.y/2]))

	  ;find the maximum
	  sbox = image(MAX([0,x-boxsize.x/4]):MIN([imageX-1,x+boxsize.x/4]),$
	      MAX([0,y-boxsize.y/4]):MIN([imageY-1,y+boxsize.y/4]))
	  pos = WHERESUB(WHERE(sbox EQ MAX(sbox)),sbox)
	  x_max = FLOAT(pos(0))+ MAX([0,x-boxsize.x/4])
	  y_max = IMAGINARY(pos(0))+ MAX([0,y-boxsize.y/4])
	  box = image(MAX([0,x_max-boxsize.x/2]):MIN([imageX-1,x_max+boxsize.x/2]),MAX([0,y_max-boxsize.y/2]):MIN([imageY-1,y_max+boxsize.y/2]))
	  ;get the center of box
          s=SIZE(box)
	  xc = FIX(s(1)/2.)
	  yc = FIX(s(2)/2.)
 	  ;subtract background
	  bc=BACK2D_POLY4(box,25,2,0,bc_flag)
	  IF bc_flag EQ 0 THEN BEGIN
 	   box=box-bc
	   WSET,click_win
	   longaxis = FIND_LONGAXIS(box,xc,yc,w,w1,w2,reb_box,LEVEL=fraction,/CONTINUOUS)
	   IF longaxis GT 0 THEN BEGIN
	    WSET,show_win
            reb_box2=reb_box
	    reb_box2(*)=0
	    reb_box2(w1)=1
	    reb_box2(w2)=1
 	    CONTOUR,reb_box2,LEVELS=[0.99999],XSTYLE=4,YSTYLE=4
	    dum=TVRD()
	    w_dum=WHERE(dum NE 0,ct_dum)
 	    IF ct_dum NE 0 THEN BEGIN
		xy_dum=WHERESUB(w_dum,dum)
		x_start=FLOAT(xy_dum(0))
		y_start=IMAGINARY(xy_dum(0))
		x_end=FLOAT(xy_dum(ct_dum-1))
		y_end=IMAGINARY(xy_dum(ct_dum-1))
		CONTOUR,reb_box,LEVELS=[box(xc,yc)*fraction/100.,box(xc,yc)]
		PLOTS,[[x_start,y_start],[x_end,y_end]],/DEV
	    ENDIF
            PRINT,'Long axis length [raster] : ',longaxis/scale
	    WIDGET_CONTROL,print_id, SET_VALUE=STRING(longaxis/scale,fraction,FORMAT='("Long axis length [raster] : ",f5.2," at",i3," % of maximum")')
	   ENDIF ELSE WIDGET_CONTROL,print_id, SET_VALUE='Cannot calculate this contour ...'
	  ENDIF ELSE WIDGET_CONTROL,print_id, SET_VALUE="Bad background !"
	ENDIF
ENDWHILE 
cut_loop : 
END








