FUNCTION fit_circle,x

COMMON SHARE_FIT_CENTER,cfit 
nfit=(SIZE(cfit))(1)
r=FLTARR(nfit)
r(*)=(cfit(*,0)-x(0))^2+(cfit(*,1)-x(1))^2
f1=TOTAL((r-x(2)^2)*(cfit(*,0)-x(0)))
f2=TOTAL((r-x(2)^2)*(cfit(*,1)-x(1)))
f3=TOTAL((r-x(2)^2)*x(2))
RETURN,[f1,f2,f3]
END


pro DRAW_FIT_CENTER, state,image_state
;+
; NAME:
;	DRAW_FIT_CENTER
;
; PURPOSE:
;	Fit the beam center from a circle.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_FIT_CENTER,state,image_state
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

COMMON SHARE_FIT_CENTER,cfit

;give instructions
repeat_fit:
WIDGET_CONTROL,state.info,SET_VALUE='Define points in main window on the circle (left mouse, middle mouse to quit, right mouse to finish) ... '

IF state.res_circles THEN BEGIN
 DRAW_RES_CIRCLES,state,image_state ;erase
 state.res_circles=1
ENDIF
WSET,image_state.zoom_win

;define box size
bx=image_state.boxinteg.boxsize.x
by=image_state.boxinteg.boxsize.y

;get the binning factor
bf=image_state.bin_fac
drawn=0

;get the number of left clicks
n_press=0
;allow a maximum of 100 points
max_click=100
cfit=LONARR(max_click,2)
;define the crosses
c1=LONARR(max_click,2) & c2=LONARR(max_click,2) 
c4=LONARR(max_click,2) & c5=LONARR(max_click,2)

WSET,image_state.draw_win

WHILE (1) DO BEGIN
 ;wait for events in the main window
 ev = WIDGET_EVENT([image_state.draw])
 x=ev.x*image_state.bin_fac
 y=ev.y*image_state.bin_fac
 z=(*image_state.orig_image)(x,y)
 WIDGET_CONTROL, image_state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')

 IF ev.press EQ 4 THEN BEGIN ; fit now
  WIDGET_CONTROL,state.info,SET_VALUE="Fitting center ..."
  GOTO,fit
 ENDIF

 IF ev.press EQ 2 THEN BEGIN ; add point
  GOTO,give_up_fit
 ENDIF

 IF ev.press EQ 1 THEN BEGIN ; add a point on circle
  box = (*image_state.orig_image)(MAX([0,x-bx/2]):MIN([image_state.x_im_sz-1,x+bx/2]),MAX([0,y-by/2]):MIN([image_state.y_im_sz-1,y+by/2]))
  ;find the maximum
  pos = WHERESUB(WHERE(box EQ MAX(box)),box)
  x = FLOAT(pos(0))+ MAX([0,x-bx/2])
  y = IMAGINARY(pos(0))+ MAX([0,y-by/2])
  box = (*image_state.orig_image)(MAX([0,x-bx/2]):MIN([image_state.x_im_sz-1,x+bx/2]),MAX([0,y-by/2]):MIN([image_state.y_im_sz-1,y+by/2]))
  ;displays that position
  z=(*image_state.orig_image)(x,y)
 WIDGET_CONTROL, image_state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')
  ;register the point
  cfit(n_press,*)=[x,y]
  ;draw a cross at that position
  DEVICE,SET_GRAPHICS=6
  col = 1
  WHILE col lt !d.table_size do col = col + col
  c1(n_press,*)= [x/bf,MAX([0,y/bf-by/2/bf])]
  c2(n_press,*)= [x/bf,MIN([(image_state.y_im_sz-1)/bf,y/bf+by/2/bf])]
  c4(n_press,*)= [MIN([(image_state.x_im_sz-1)/bf,x/bf+bx/2/bf]),y/bf]
  c5(n_press,*)= [MAX([0,x/bf-bx/2/bf]),y/bf]
  PLOTS,TRANSPOSE([c1(n_press,*),c2(n_press,*)]),COL=col,/DEVICE
  PLOTS,TRANSPOSE([c4(n_press,*),c5(n_press,*)]),COL=col,/DEVICE
  DEVICE,SET_GRAPHICS=3
  n_press=n_press+1
 ENDIF

ENDWHILE

fit:
;do the fit
wfit=WHERE(cfit(*,0) NE 0 AND cfit(*,1) NE 0,nfit)
IF nfit LE 2 THEN BEGIN
 WIDGET_CONTROL,state.info,SET_VALUE="Need at least 3 points ..."
 WAIT,0.5
 ;erase the crosses
 DEVICE,SET_GRAPHICS=6
 FOR i=0,n_press-1 DO BEGIN
  PLOTS,TRANSPOSE([c1(i,*),c2(i,*)]),COL=col,/DEVICE
  PLOTS,TRANSPOSE([c4(i,*),c5(i,*)]),COL=col,/DEVICE
 ENDFOR
 DEVICE,SET_GRAPHICS=3
 GOTO,repeat_fit
ENDIF ELSE BEGIN ; can start fitting
cfit=cfit(wfit,*)
CIR_3PNT,cfit(0:2,0),cfit(0:2,1),r,x0,y0
tmp=NEWTON([x0,y0,r],'fit_circle')
x0=tmp(0) & y0=tmp(1) & r=tmp(2)

WIDGET_CONTROL, image_state.xyz_show, SET_VALUE=STRING(x0,y0,FORMAT='("XCEN [raster] :",f10.3," YCEN [raster] :",f10.3)')
ENDELSE

;display the fitted circle
DEVICE,SET_GRAPHICS=6
c=CIRCLE(x0/bf,y0/bf,r/bf,/SHOW)
;display the center
c1(n_press,*)= [x0/bf,MAX([0,y0/bf-by/2/bf])]
c2(n_press,*)= [x0/bf,MIN([(image_state.y_im_sz-1)/bf,y0/bf+by/2/bf])]
c4(n_press,*)= [MIN([(image_state.x_im_sz-1)/bf,x0/bf+bx/2/bf]),y0/bf]
c5(n_press,*)= [MAX([0,x0/bf-bx/2/bf]),y0/bf]
PLOTS,TRANSPOSE([c1(n_press,*),c2(n_press,*)]),COL=col,/DEVICE
PLOTS,TRANSPOSE([c4(n_press,*),c5(n_press,*)]),COL=col,/DEVICE
DEVICE,SET_GRAPHICS=3
drawn=1
ok=WIDGET_MESSAGE('Is this OK ?',/QUESTION)
IF ok EQ 'No' THEN BEGIN
 ;erase
 DEVICE,SET_GRAPHICS=6
 c=CIRCLE(x0/bf,y0/bf,r/bf,/SHOW)
 DEVICE,SET_GRAPHICS=3
 ;erase the crosses and center
 DEVICE,SET_GRAPHICS=6
 FOR i=0,n_press-1 DO BEGIN
  PLOTS,TRANSPOSE([c1(i,*),c2(i,*)]),COL=col,/DEVICE
  PLOTS,TRANSPOSE([c4(i,*),c5(i,*)]),COL=col,/DEVICE
 ENDFOR
 PLOTS,TRANSPOSE([c1(n_press,*),c2(n_press,*)]),COL=col,/DEVICE
 PLOTS,TRANSPOSE([c4(n_press,*),c5(n_press,*)]),COL=col,/DEVICE
 DEVICE,SET_GRAPHICS=3
 GOTO,repeat_fit
ENDIF

state.diff_par.cenx=x0 & state.diff_par.ceny=y0

give_up_fit:
;erase the circle
IF drawn THEN BEGIN
 DEVICE,SET_GRAPHICS=6
 c=CIRCLE(x0/bf,y0/bf,r/bf,/SHOW)
 DEVICE,SET_GRAPHICS=3
ENDIF 
;erase the crosses and center
wfit=WHERE(cfit(*,0) NE 0 AND cfit(*,1) NE 0,nfit)
IF nfit GT 0 THEN BEGIN
 DEVICE,SET_GRAPHICS=6
 FOR i=0,n_press-1 DO BEGIN
  PLOTS,TRANSPOSE([c1(i,*),c2(i,*)]),COL=col,/DEVICE
  PLOTS,TRANSPOSE([c4(i,*),c5(i,*)]),COL=col,/DEVICE
 ENDFOR
 PLOTS,TRANSPOSE([c1(n_press,*),c2(n_press,*)]),COL=col,/DEVICE
 PLOTS,TRANSPOSE([c4(n_press,*),c5(n_press,*)]),COL=col,/DEVICE
 DEVICE,SET_GRAPHICS=3
ENDIF

;restore resolution circles if necessary
IF state.res_circles THEN BEGIN
 DRAW_RES_CIRCLES,state,image_state ;redraw
 state.res_circles=1
ENDIF

WIDGET_CONTROL,state.info,SET_VALUE="Info :"

END






