pro DRAW_BOXINTEG,image,click_id,show_id,print_id,boxsize,gain,offset
;+
; NAME:
;	DRAW_BOXINTEG
;
; PURPOSE:
;	Interactively box integrate spots.
;	length.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_BOXINTEG,image,click_id,show_id,boxsize,fraction=fraction
;
; INPUTS:
;	image : the original data image
;	click_id : the widget id of the click window where the image 
;		is displayed.
;	show_id : the widget id of the draw window where the contour
;		is displayed.
;	print_id : the widget id of the label window where calculated value
;		is displayed.
;	boxsize : size of the search box
;	gain : the gain of the detector
;	offset : the offset of the detector
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	The user clicks with left mouse on one spot.
;	Click on the right mouse to leave.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

;get the window number of the showing widget

WIDGET_CONTROL, show_id, GET_VALUE=show_win
WIDGET_CONTROL, click_id, GET_VALUE=click_win
click_win=!D.WINDOW

button = 0

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

noise_percentage = 25

;get the proper "fraction"
IF NOT KEYWORD_SET(fraction) THEN fraction = 50.

WHILE 1 DO BEGIN                ;Internal event loop   
	;wait for an event from the clicking window
    	ev = WIDGET_EVENT([click_id])
	button = ev.press  ;New button state   
	 IF button EQ 4 THEN GOTO,cut_loop
 	 IF button THEN BEGIN
	  x = ev.x    ;Pixel coordinates
	  y = ev.y
	  box = image(MAX([0,x-boxsize.x/2]):MIN([imageX-1,x+boxsize.x/2]),$
	      MAX([0,y-boxsize.y/2]):MIN([imageY-1,y+boxsize.y/2]))

	  ;find the maximum
	  sbox = image(MAX([0,x-boxsize.x/4]):MIN([imageX-1,x+boxsize.x/4]),$
	      MAX([0,y-boxsize.y/4]):MIN([imageY-1,y+boxsize.y/4]))
	  pos = WHERESUB(WHERE(sbox EQ MAX(sbox)),sbox)
	  x_max = FLOAT(pos(0))+ MAX([0,x-boxsize.x/4])
	  y_max = IMAGINARY(pos(0))+ MAX([0,y-boxsize.y/4])
	  box = image(MAX([0,x_max-boxsize.x/2]):MIN([imageX-1,x_max+boxsize.x/2]),MAX([0,y_max-boxsize.y/2]):MIN([imageY-1,y_max+boxsize.y/2]))
	  ;get the center of box
          s=SIZE(box)
	  boxsize={x:s(1),y:s(2)}
 	  ;subtract background
	  bc=BACK2D_POLY4(box,noise_percentage,gain,offset,bc_flag,bc_coeff,bc_mean,n_back,chi_square,noise_index,MAX_CYCLE=10)
	  PRINT,'Number of used pixels for background:',(SIZE(noise_index))(1)
	  PRINT,'******Mean background value***** :',bc_mean
;	  IF bc_flag NE 0 THEN BEGIN
;	   PRINT,'******BAD BACKGROUND******' 
;	   WIDGET_CONTROL,print_id, SET_VALUE='******BAD BACKGROUND******' 
;	  ENDIF ELSE BEGIN
	   ;the spot and the background have already been calculated
	   area = box - bc

	   ;get the optimum cutoff level [% of MAX(area)]
	   cutoff = GET_BOXLEVEL(area,n_back,bc_mean,offset)

	   ;get the best contour for integration
	   region = GET_BOXREG(area,cutoff,boxsize)
	   ;the integrated intensity is then
	   integrated = TOTAL(area(region))

	   ;the variance is :
	   n_peak = (SIZE(region))(1)
	   peak_variance = SQRT(GET_BOXVAR(integrated,n_peak,bc_mean,n_back,gain,gain,offset))

	   PRINT,'Percentage of used profile for integration [%] :',100*(n_peak/FLOAT(boxsize.x*boxsize.y))
	   PRINT,'Position of maximum [x,y] :',WHERESUB(WHERE(area EQ MAX(area)),area)
	   PRINT,'*****Peak intensity (including background)***** :',MAX(box)
	   PRINT,'*****Integrated intensity***** :',integrated
	   PRINT,'*****Peak variance***** :',peak_variance
	   PRINT,'*****I/Sig(I)***** :',integrated/peak_variance
	   PRINT,''
	   IF bc_flag NE 0 THEN $
 		PRINT,'******BAD BACKGROUND******' $ 
	   ELSE PRINT,'******CORRECT BACKGROUND******' 

	   WSET,show_win
	   CONTOUR,area,LEVELS=[(INDGEN(10)+1)*MAX(area)/10.],C_COLORS=!D.N_COLORS - 60
	   temp = area
	   temp(*) = 0
	   temp(region) = area(region)
	   CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 190

	   IF bc_flag NE 0 THEN $
	    WIDGET_CONTROL,print_id, SET_VALUE=STRCOMPRESS(STRING(MAX(box),integrated,integrated/peak_variance,bc_mean,FORMAT='("Peak value : ",i7," I : ",f10.1," I/SigI : ",f7.2," **BAD MEAN BG** : ",f10.1)')) $		
	   ELSE $
	    WIDGET_CONTROL,print_id, SET_VALUE=STRCOMPRESS(STRING(MAX(box),integrated,integrated/peak_variance,bc_mean,FORMAT='("Peak value : ",i7," I : ",f10.1," I/SigI : ",f7.2," Mean background : ",f10.1)'))


;	  ENDELSE
	ENDIF
ENDWHILE 
cut_loop : 
END








