function CIRCLE, x0, y0,r, show=show
;+
; NAME:
;	CIRCLE
;
; PURPOSE:
;	Draw a circle around (x0,y0) of radius r
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	circle = CIRCLE(x0,y0,r,/show)
;
; INPUTS:
;	x0 : the x coordinate of the circle center [raster]
;	y0 : the y coordinate of the circle center [raster]
;	r : the radius of the circle [raster]
;	show : set this keyword to plot the circle on a window
;
; OUTPUTS:
;	A LONARR(2,50) containing the x and y [raster] values of
;	the circle.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1994.
;-


n = 50   ;# of points
a = findgen(n) * (2 * !pi/(n-1))
c = transpose([[x0 + r * cos(a)], [y0 + r * sin(a)]])


col = 1
WHILE col lt !d.table_size do col = col + col
IF KEYWORD_SET(show) THEN PLOTS,c,COLOR=col,/DEVICE

RETURN,c
END








