pro BATCH_INTEG,file=file,RESTART=RESTART,RM_LOG=RM_LOG
;+
; NAME:
;	BATCH_INTEG
;
; PURPOSE:
;	Integrates data in batch mode (no graphics).
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	BATCH_INTEG,file=file,RESTART=restart_file,[/rm_log]
;
; INPUTS:
;	file : an idl file containing a structure integ_state as defined in the PROW GUI.
;	restart : [optional] restarts the session if crashed, enter the .ref filename of the last
;		  successfully integrated image !
;	rm_log : set this keyword to force removing of log file if necessary.
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, August 1997.
;-

dummy=FINDFILE(file,count=count)

IF count EQ 0 THEN BEGIN
 PRINT,'Could not find file :'+file
 GOTO,escape
ENDIF
RESTORE,file

IF integ_state.integ_mode EQ 'mono' THEN mode='mono' ELSE mode='laue'

logdir = integ_state.logdir
logfile = integ_state.logfile

denzo_format = integ_state.denzo_format
IF denzo_format NE 'york' AND $
   denzo_format NE 'noyork' THEN $
 MESSAGE,'Unknown DENZO format !'

xdir = integ_state.xdir
xfile = integ_state.xfile

loc_refine = integ_state.loc_refine
IF loc_refine LT 0 OR loc_refine GT 1 THEN $
 MESSAGE,'Loc_refine parameter must be 0 or 1 !'

prowdir = integ_state.prowdir
prowfile = integ_state.prowfile
reffile = integ_state.reffile

datadir = integ_state.datadir
datafile = integ_state.datafile

first = integ_state.first
last = integ_state.last

skip = integ_state.skip
IF skip THEN BEGIN
 ds= integ_state.data_skipped
 ds2=ds
 n_skipped=1
 IF STRPOS(ds2,',') NE -1 THEN BEGIN
  REPEAT BEGIN
   ds2=STR_REPLACE(ds2,',','?') 
   n_skipped=n_skipped+1
  ENDREP UNTIL STRPOS(ds2,',') EQ -1
 ENDIF
 data_skipped=INTARR(n_skipped)
 READS,ds,data_skipped
ENDIF

IF integ_state.integ_mode EQ 'laue_soft' THEN rdbw=1 ELSE rdbw=0

detector = integ_state.detector
IF detector NE 'marccd' AND $
   detector NE 'marccdswap' AND $
   detector NE 'ccd' AND $
   detector NE 'adscQ4' AND $
   detector NE 'adscQ315' AND $
   detector NE 'ccd4bytes' AND $
   detector NE 'mar18' AND $
   detector NE 'mar30' AND $
   detector NE 'mar345' AND $
   detector NE 'raxis' AND $
   detector NE 'edf' THEN $
 MESSAGE,'Unavailable detector !'

res_lim=integ_state.res_lim
READS,integ_state.res_lim,res1,res2
low_res = FLOAT(res1)>FLOAT(res2)
high_res = FLOAT(res1)<FLOAT(res2)

xsize = integ_state.xsize
ysize = integ_state.ysize
raster = integ_state.raster

set_bsmask = integ_state.set_bsmask
bs_maskfile = integ_state.bs_maskfile

set_mask =  integ_state.set_mask
maskfile =  integ_state.maskfile

boxsize_x = integ_state.boxsize.x
boxsize_y = integ_state.boxsize.y
IF (boxsize_x/2. EQ boxsize_x/2) OR (boxsize_y/2. EQ boxsize_y/2) THEN $
 MESSAGE,'Boxsize dimensions must be ODD, not EVEN !'

set_region = integ_state.set_region
n_sectors = integ_state.n_sectors
regionfile = integ_state.regionfile
bc_extend=integ_state.bc_extend

use_old_ref=integ_state.use_old_ref
second_interp=integ_state.second_interp

ovlp_dist = integ_state.ovlp_dist
ovlp_min_dist = integ_state.ovlp_min_dist
ovlp_ref_dist = integ_state.ovlp_ref_dist

satvalue = integ_state.satvalue
det_offset = integ_state.det_offset

det_gain = integ_state.det_gain
bg_percentage = integ_state.bg_percentage
bg_max_slope = integ_state.bg_max_slope

max_ref_spots = integ_state.max_ref_spots
min_ref_spots = integ_state.min_ref_spots

min_isigi = integ_state.min_isigi

use_partials = integ_state.use_partials

max_osc_distance = integ_state.max_osc_distance
rad_distance = integ_state.rad_distance
ang_width = integ_state.ang_width
IF rad_distance LE 0 THEN MESSAGE,'Radial distance must be positive !'
IF ang_width LE 0 THEN MESSAGE,'Angular width must be positive !'

sym_search = integ_state.sym_search

show_image = integ_state.show_image
show_ref_peaks = integ_state.show_ref
show_strong_peaks = integ_state.show_strong
show_weak_peaks = integ_state.show_weak
show_ovlp_peaks = integ_state.show_ovlp
show_m = integ_state.show_m

IF show_m THEN BEGIN
 READS,integ_state.miller,miller_h,miller_k,miller_l
 miller_h = FIX(miller_h)
 miller_k = FIX(miller_k)
 miller_l = FIX(miller_l)
ENDIF ELSE BEGIN
 miller_h = 0 & miller_k = 0 & miller_l =0
ENDELSE

;define a rebinning factor
reb_fac = 1 + (xsize > ysize) / 500


WHILE (FIX(xsize )/FIX(reb_fac) NE FIX(xsize )/FLOAT(reb_fac)) OR (FIX(ysize)/FIX(reb_fac) NE FIX(ysize)/FLOAT(reb_fac)) DO BEGIN
  reb_fac=reb_fac-1
ENDWHILE 
 

;for safety
CLOSE,1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& CREATE LOG FILE &&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

start_time = SYSTIME(1)
;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdir+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
 IF NOT KEYWORD_SET(rm_log) THEN BEGIN
  ok=WIDGET_MESSAGE('Log file exists. Remove it ?',/QUESTION)
  IF ok EQ 'Yes' THEN SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL),/SH ELSE GOTO,escape
 ENDIF ELSE SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL), /SH
ENDIF

JOURNAL,STRCOMPRESS(logdir+logfile,/REMOVE_ALL)
PRINT,'Integration : Opening logfile ...'

;get window numbers
;WIDGET_CONTROL, image_state.draw, GET_VALUE=win_temp
;image_state.draw_win = win_temp(0)
;WIDGET_CONTROL, image_state.study, GET_VALUE=win_temp
;image_state.study_win = win_temp(0)

IF show_image THEN BEGIN
 size_for_title=25
 IF !D.X_SIZE NE xsize/reb_fac OR !D.Y_SIZE NE (ysize/reb_fac+size_for_title) OR !D.WINDOW EQ -1 THEN BEGIN
 ;IF !D.WINDOW EQ -1 OR !D.X_SIZE NE xsize/reb_fac OR !D.Y_SIZE NE ysize/reb_fac THEN $
 ;DRAW_WIN,XSIZE=xsize/reb_fac,YSIZE=ysize/reb_fac,wid=window_id,TITLE='Integration window'
  WIN,xsize/reb_fac,(ysize/reb_fac+size_for_title),/FREE,TITLE='IMAGE WINDOW'
  black_box=BYTARR(xsize/reb_fac,size_for_title)
 ENDIF
 main_win=!D.WINDOW
ENDIF

IF show_ref_peaks OR show_strong_peaks OR show_weak_peaks OR show_ovlp_peaks OR show_m THEN BEGIN
 WIN,512,512,/FREE,TITLE='DEBUG WINDOW'
 study_win=!D.WINDOW
ENDIF ;ELSE study_win=image_state.study_win

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&& CHOOSE IMAGES TO PROCESS &&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
np1=STRPOS(datafile,'#') & np2=RSTRPOS(datafile,'#')
REPEAT datafile=STR_REPLACE(datafile,'#','?') UNTIL STRPOS(datafile,'#') EQ -1

image_names = FINDFILE(STRCOMPRESS(datadir+datafile,/REMOVE_ALL),count=count)
IF (count EQ 0) THEN MESSAGE, 'No images found ...'
image_numbers = FIX(STRMID(image_names,STRLEN(datadir)+np1,np2-np1+1))
s = WHERE(image_numbers GE first AND image_numbers LE last)
image_names = image_names(s)
image_numbers = image_numbers(s)

IF skip THEN BEGIN
FOR j=0,(SIZE(data_skipped))(1)-1 DO BEGIN
sk = WHERE(image_numbers NE data_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	image_numbers = image_numbers(sk)
	image_names = image_names(sk)
ENDIF
ENDFOR
ENDIF

PRINT,'Number of images to process : ',(SIZE(image_names))(1)

images= (SIZE(image_names))(1)

frame_start=INTARR(images)
frames=INTARR(images)+1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&& PRINT INFORMATION &&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
@draw_batch_info

;suppress nasty messages for arithmetic errors
junk = CHECK_MATH(trap = 0)

IF show_image THEN BEGIN
	WSET,main_win
	LOADCT,0
	red_col=[255,0,0]
	green_col=[0,255,0]
	dark_blue_col=[0,0,255]
	light_blue_col=[0,255,255]
	colours = LONARR(4,3)
	colours(0,*)=light_blue_col
	colours(1,*)=dark_blue_col
	colours(2,*)=green_col
	colours(3,*)=red_col
	TVLCT,colours,!D.N_COLORS-4
ENDIF

;IF show_ref_peaks OR show_strong_peaks OR show_weak_peaks OR show_ovlp_peaks OR show_m THEN $
; LOADCT,12

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&& PREDICT AND INTEGRATE EACH IMAGE &&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


FOR i=0,(images-1) DO BEGIN
    CATCH, error_status
    ;error_status=0
    IF (error_status ne 0) THEN BEGIN
      BATCH_ERROR, image_name
      error_status=0
      GOTO, end_of_image
    ENDIF
      image_name=image_names(i)

 start_image_time = SYSTIME(1)
PRINT, 'Time from beginning of session [s] : ',start_image_time-start_time
PRINT, 'Image name : ',image_name


;&&&&&&&&& GET PREDICTED REFLECTIONS &&&&&&&&&&&&&
	image_number = STRMID(image_name,STRLEN(datadir)+np1,np2-np1+1)
        gen_number = ''
        FOR loc_i=0,STRLEN(image_number)-1 DO gen_number=gen_number+'#'
 	gen_number=STRCOMPRESS(gen_number,/REMOVE_ALL)

	IF mode EQ 'mono' THEN BEGIN ; Mono MODE with DENZO
         denzo_name = STR_REPLACE(xfile,gen_number,image_number)
	 denzo_name=STRCOMPRESS(xdir+denzo_name,/REMOVE_ALL)
	 dummy=FINDFILE(denzo_name, count=count)

	    IF (count eq 0) THEN MESSAGE, "Couldn't find DENZO .x file."
		PRINT,'Integration : Loading predictions ...'
	    CASE denzo_format OF
		'york' : noyork=0
		'noyork' : noyork=1
		else : MESSAGE,'Unknown DENZO format ?'
	    ENDCASE

	    refl = READ_DENZOX(denzo_name, par, RASTER=raster, NOYORK=noyork, DETECTOR=detector)
	    par.rastx = xsize & par.rasty = ysize

	ENDIF ELSE BEGIN ; Laue MODE

	 geasc_name = STR_REPLACE(xfile,gen_number,image_number)
	 geasc_name = STR_REPLACE(geasc_name,'.geasc','')
	 geasc_name = STRCOMPRESS(xdir+geasc_name,/REMOVE_ALL)
	
	 dummy=FINDFILE(geasc_name+'.gen', count=count1)
	 dummy=FINDFILE(geasc_name+'.ldm', count=count2)
	 count=count1+count2
	 IF (count eq 0) THEN MESSAGE, "Couldn't find .gen nor .ldm file."

	 dummy=FINDFILE(geasc_name+'.geasc', count=count)
	 IF (count eq 0) THEN SPAWN, $
		'source '+ GETENV('PROW_SCR')+'/get_geasc.scr ' + geasc_name
	 dummy=FINDFILE(geasc_name+'.geasc', count=count)
	 IF (count eq 0) THEN MESSAGE, "Couldn't find GEASC- or GE1/GE2-files."

	 ;WIDGET_CONTROL,state.info,SET_VALUE='Integration : Loading predictions ...'

	 refl = READ_GEASC2(geasc_name, par)
	 par.rastx = xsize & par.rasty = ysize

	;&&&&&&& IN LAUE_SOFT MODE EXCLUDE REFLEXIONS PREDICTED TO BE WEAK &&&&&&
	;WIDGET_CONTROL,state.info,SET_VALUE='Integration : Excluding weak reflexions ...'
 	IF rdbw GT 0 THEN refl=DRAW_SET_RDBW(integ_state,refl,par,weak_refl=weak_refl)

	;&&&&&&& END OF THE EXCLUDE PROBLEM &&&&&&


	ENDELSE 

	PRINT,'Selecting resolution limits ...'
	w_res=WHERE(refl.res GT high_res AND refl.res LE low_res,ct_res)
	IF ct_res EQ 0 THEN MESSAGE,'Error : check resolution limits !' ELSE $
	refl=refl(w_res)

	par = CREATE_STRUCT(par,'n_sectors',n_sectors,'regions',PTRARR(n_sectors))

	IF set_region THEN BEGIN
		RESTORE,regionfile
		IF (boxsize_x NE boxsize_reg.x) OR (boxsize_y NE boxsize_reg.y) THEN BEGIN
		 PRINT,'Boxsize for spot region : ',boxsize_reg.x,boxsize_reg.y
		 PRINT,'User defined boxsize : ',boxsize_x,boxsize_y
		 MESSAGE,'Spot region incompatible with chosen boxsize !'
		ENDIF
	    	par = CREATE_STRUCT(par,'overall_region',region)
	ENDIF ELSE  par = CREATE_STRUCT(par,'overall_region',0)
 
	WRITEPAR_LAUE2,par,beamsize=0,sample_depth=0,$
	   	dark_current=det_offset,boxsize={box, x:boxsize_x,y:boxsize_y},gain=det_gain,$
	  	bg_gain=det_gain*1.5418/par.wave,noise_percentage=bg_percentage,bg_max_slope=bg_max_slope,satvalue=satvalue,$
	   	ovlp_dist=ovlp_dist,ovlp_min_dist=ovlp_min_dist,bc_extend=bc_extend,mode=mode

;&&&&&&&&& OPEN IMAGE AND DISPLAY IT &&&&&&&&&&&&&
 
    ;check the image file :
    PRINT,'Checking image file.'
    SPAWN,'date', date ,/SH & PRINT, date
    SPAWN,'file ' + image_name,/SH
    PRINT,'Integration : Loading image ...'
    tmp_xsize=xsize & tmp_ysize=ysize

    IF mode EQ 'mono' THEN BEGIN
     CASE detector OF 
	'marccdswap':  image=READ_MARCCD(file=image_name,/SWAP) 
	'marccd':  image=READ_MARCCD(file=image_name) 
	'ccd' :	   image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'adscQ4' :   image=READ_Q4(file=image_name)
	'adscQ315' :   image=READ_Q315(file=image_name)
	'ccd4bytes' : image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize,/DUMP)
	'mar18' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar30' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar345' : image=READ_MAR345(file=image_name)
	'raxis' : image=READ_RAXIS(file=image_name)
	'edf' : image=READ_EDF(file=image_name)
	 else :	   image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
     ENDCASE
    ENDIF ELSE BEGIN    
     CASE detector OF 
        ;change offset to zero for marccd for compatibility with LAUEGEN
	'marccdswap':  image=READ_MARCCD(file=image_name,/SWAP,offset=0) 
	'marccd':  image=READ_MARCCD(file=image_name,offset=0) 
	'ccd' :	   image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'adscQ4' :   image=READ_Q4(file=image_name)
	'adscQ315' :   image=READ_Q315(file=image_name)
	'ccd4bytes' : image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize,/DUMP)
	'mar18' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar30' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar345' : image=READ_MAR345(file=image_name)
	'raxis' : image=READ_RAXIS(file=image_name)
	'edf' : image=READ_EDF(file=image_name)
	 else :	   image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
     ENDCASE
    ENDELSE
    IF (SIZE(image))(0) EQ 2 THEN BEGIN  ; file exists
 
    IF set_bsmask THEN BEGIN
      ; Set image behind beamstop to zero so that ROILAUE3 removes 
      ; predictions in this region:
      RESTORE, bs_maskfile
      IF xsize NE sx OR ysize NE sy THEN MESSAGE,'Impossible to apply this mask ! (size problem)'
      image(mask) = 0
    ENDIF
    IF set_mask THEN BEGIN
      RESTORE, maskfile
      IF xsize NE sx OR ysize NE sy THEN MESSAGE,'Impossible to apply this mask ! (size problem)'
      image(mask) = 0
    ENDIF
 
      ;display the image
      IF show_image THEN BEGIN
	  tmp_title=STRMID(image_name,RSTRPOS(image_name,'/')+1,STRLEN(image_name)-RSTRPOS(image_name,'/')-1)
          ;WIDGET_CONTROL,window_id,TLB_SET_TITLE=tmp_title 
          XYOUTS,10,!D.Y_SIZE-size_for_title/2,tmp_title,/DEVICE
 	  red=REBIN(image,xsize/reb_fac,ysize/reb_fac)
 	  PRINT,'Integration : Displaying image ...'
	  index_sat=WHERE(red GE satvalue, count_sat)
	  red_displayed = (!D.N_COLORS-2)*ALOG(red>1)/ALOG(satvalue)
	  ; Set the marked pixels to such a high value so that after rebinning
	  ; it is still above !D.N_COLORS-1 :
  	  IF (count_sat gt 0) THEN  red_displayed(index_sat)= 10.0^20
	  TV, red_displayed < (!D.N_COLORS-1)
      ENDIF


	read_image_time = SYSTIME(1)
	PRINT, 'Time to read image and prediction [s] : ',read_image_time-start_image_time

      ;take only the spots inside image and where the image is not empty
     CASE detector OF 
	'marccdswap': out_image_value=10  
	 else :	   out_image_value=0  
     ENDCASE	    
      refl2 = ROILAUE3(refl,image,par,0,0,xsize-1,ysize-1,OUT_IMAGE_VALUE=out_image_value)

;&&&&&&&&& ADDITIONAL REFINEMENT IF WANTED &&&&&&&&&&&&&

IF loc_refine EQ 1 THEN BEGIN
      PRINT,'Searching for overlaps ...[for refinement]'
      ; Find overlaps to avoid that refinement brings two spots at the 
;same position
      FIND_QUICKOVLP,refl2,par,3*SQRT(2)*raster*0.001
      PRINT,'Integration : Doing local refinement ...' 

      ;run the local refinement routine 1 time with changing positions
      refl_obs=LOC_REFINE1(refl2,image,par,0,weak,sigma,back,change_pred=loc_refine)
ENDIF ELSE BEGIN
      PRINT,'Integration : Checking reflexions ...'
      refl_obs=LOC_REFINE2(refl2,image,par)
ENDELSE

match_image_time = SYSTIME(1)
PRINT, 'Time for internal refinement [s] : ',match_image_time-read_image_time

      ;overplot predicted positions on image
      IF show_image THEN dummy = PIXLAUE2(refl_obs,reb_fac,image,par,draw=4,color=2)

;&&&&&&&&& SEARCH FOR OVERLAPS &&&&&&&&&&&&&
      PRINT,'Integration : Finding overlaps...'
      IF ovlp_ref_dist NE par.ovlp_dist THEN BEGIN
       ; Find overlaps when selecting reference peaks; severe criteria!
       PRINT,'Searching for overlaps ...[reference_peaks]'
       FIND_QUICKOVLP,refl_obs,par, ovlp_ref_dist
       refl_obs.ovlp2=refl_obs.ovlp
      ENDIF
      ;get the overlapping pattern
      PRINT,'Searching for overlaps ...[all spots]'
      FIND_OVLP2,refl_obs,par,par.ovlp_dist,par.ovlp_min_dist
      IF ovlp_ref_dist EQ par.ovlp_dist THEN BEGIN
       ;no need to calculate twice the overlaps
       refl_obs.ovlp2=refl_obs.ovlp
      ENDIF
      IF show_image THEN BEGIN
	w_ovlp=WHERE(refl_obs.ovlp GT 0,ct_ovlp)
	IF ct_ovlp GT 0 THEN dummy = PIXLAUE2(refl_obs(w_ovlp),reb_fac,image,par,draw=4,color=4)
      ENDIF

ovlp_image_time = SYSTIME(1)
PRINT, 'Time for finding overlaps [s] : ',ovlp_image_time-match_image_time

;&&&&&&&&& FIND THE SECTORS &&&&&&&&&&&&&

SET_SECTORS,refl_obs,par,reb_fac=reb_fac,show=show_image


;&&&&&&&&& INTEGRATION &&&&&&&&&&&&&

    PRINT,'Integrating :',image_name

      miller = [miller_h,miller_k,miller_l]

IF use_old_ref THEN BEGIN
 ;restore the reference spots :      
 PRINT,'Integration : Restoring reference spots ...'

 curr_reffile = STR_REPLACE(reffile,gen_number,image_number)
 file_restore=STRCOMPRESS(prowdir+curr_reffile,/REMOVE_ALL)

 dum=FINDFILE(file_restore,count=count)
 IF count NE 1 THEN MESSAGE,'Could not find the file with old reference spots !'
 RESTORE,file_restore

 PRINT,'Number of restored reference spots : ', (SIZE(ref_spots))(1)
; PRINT,'Number of restored strong spots : ', number_strong_spots

ENDIF ELSE BEGIN

PRINT,'Integration : Searching reference spots ...'

 IF i EQ 0 THEN BEGIN
  old_ref_spots=0
  IF N_ELEMENTS(restart) NE 0 THEN BEGIN
   curr_reffile = restart
   file_restore=STRCOMPRESS(prowdir+curr_reffile,/REMOVE_ALL)
   dum=FINDFILE(file_restore,count=count)
   IF count NE 1 THEN MESSAGE,'Could not find the file with old reference spots !'
   PRINT,'Restoring old reference spots ...'
   tmp_par=par ; this is because RESTORE will input new par
   RESTORE,file_restore
   old_ref_spots=ref_spots
   par=tmp_par
  ENDIF
 ENDIF 

  new_ref_spots = FIND_REFSPOTS(image,reb_fac,refl_obs,par,$
	max_ref_spots=max_ref_spots, $
	min_ref_spots=min_ref_spots, $
	other_spots=other_spots, $
	number_ref_spots=number_ref_spots, $
	number_other_spots=number_other_spots, $
	min_sob=min_isigi, $
	show_image=show_image, $
	show_ref_peaks=show_ref_peaks, $
	use_partials=use_partials, $
	study_win=study_win, $
	main_win=main_win)
 ;get the strong spots
  w_nonovlp_ref = WHERE(new_ref_spots.ovlp EQ 0,ct_w_nonovlp_ref)
  IF number_other_spots GT 0 THEN $
   w_nonovlp_other = WHERE(other_spots.ovlp EQ 0,ct_w_nonovlp_other) $
  ELSE $
   ct_w_nonovlp_other=0

  IF ct_w_nonovlp_ref LT number_ref_spots THEN BEGIN
   PRINT,'Number of reference peaks declared as overlapped : ',number_ref_spots-ct_w_nonovlp_ref
   PRINT,'These spots will be not be box integrated, but profile fitted !'
  END

  IF (ct_w_nonovlp_ref+ct_w_nonovlp_other) GT 0 THEN $
   strong_spots = REPLICATE(new_ref_spots(0),ct_w_nonovlp_ref+ct_w_nonovlp_other) ELSE strong_spots=0

  IF ct_w_nonovlp_ref GT 0 THEN $
   strong_spots(0:ct_w_nonovlp_ref-1)=new_ref_spots(w_nonovlp_ref)

  IF ct_w_nonovlp_other GT 0 THEN $
   strong_spots(ct_w_nonovlp_ref:ct_w_nonovlp_ref+ct_w_nonovlp_other-1)=other_spots(w_nonovlp_other)

  IF (SIZE(strong_spots))(0) EQ 1 THEN $  
   number_strong_spots=(SIZE(strong_spots))(1) ELSE number_strong_spots=0

  IF (show_image AND number_strong_spots GT 0) THEN dummy = PIXLAUE2(strong_spots,reb_fac,image,par,draw=4,color=1)

 ;get the reference spots
  ref_spots = MERGE_REFSPOTS(new_ref_spots,old_ref_spots,par,$
				MAX_OSC_DISTANCE=max_osc_distance,$
				MAX_REF_SPOTS=max_ref_spots,$
				SHOW=0)

  old_ref_spots = ref_spots
 

;save the reference and strong spots :
      	curr_reffile = STR_REPLACE(reffile,gen_number,image_number)
	file_save=STRCOMPRESS(prowdir+curr_reffile,/REMOVE_ALL)
     	SAVE,file=file_save,ref_spots,strong_spots,par,number_ref_spots,number_strong_spots
ENDELSE

;integrate the data with profile fitting and overlap deconvolution
      PRINT,'Integration : Integrating ...'
      integ = INTEGRATE_DENZO1(image,reb_fac,refl_obs,par,$
	ref_spots=ref_spots,$
	strong_spots=strong_spots,$
	ref_distance=rad_distance, $
	ref_ang_width=ang_width, $
	show_image=show_image, $
	show_strong_peaks=show_strong_peaks, $
	show_weak_peaks=show_weak_peaks, $
	show_ovlp_peaks=show_ovlp_peaks, $
	show_m=show_m, miller=miller, $
	use_partials=use_partials, $
	sym_rad=sym_search, $
	second_interp=second_interp, $
	study_win=study_win, $
	main_win=main_win, $
;	integ_mode='laue')
	integ_mode=mode)
integ_image_time = SYSTIME(1)
PRINT, 'Time for integration [s] : ',integ_image_time-ovlp_image_time

      ;remove saturated spots and spots too close to integrate !
      integ = integ(WHERE(integ.close EQ 0))



  	;&&&&&&& IN LAUE_SOFT MODE MERGE WITH  REFLEXIONS PREDICTED TO BE WEAK &&&&&&

 	IF rdbw GE 1 THEN BEGIN
 	 integ=MERGE_INTEG(integ,weak_refl) 	 
	ENDIF
	;&&&&&&& END OF THE EXCLUDE PROBLEM &&&&&&

	;get some statistics

PRINT,''
PRINT,'&&&&&& SOME STATISTICS &&&&&'

IF mode EQ 'laue' THEN  BEGIN ;statistics on singles
      w_mul=WHERE(integ.mul EQ 1,ct_mul)
      PRINT,'Percentage of single reflexions : ', $
	100*ct_mul/FLOAT((SIZE(integ))(1))
ENDIF

IF rdbw GE 1 THEN  BEGIN ;statistics on excluded reflexions
      w_rdbw=WHERE(integ.flag EQ 4,ct_rdbw)
      PRINT,'Percentage of excluded reflexions : ', $
	100*ct_rdbw/FLOAT((SIZE(integ))(1))
ENDIF

     w=WHERE(integ.flag eq 2,ct)
PRINT,STRCOMPRESS('Number of spots with bad integrated intensities : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 1,ct)
PRINT,STRCOMPRESS('Number of spots with bad background : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 5,ct)
PRINT,STRCOMPRESS('Number of spots with bad deconvolution : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')

        curr_prowfile = STR_REPLACE(prowfile,gen_number,image_number)
        file_save = STRCOMPRESS(prowdir+curr_prowfile,/REMOVE_ALL)
      IF show_image THEN BEGIN
          ;XYOUTS,10,!D.Y_SIZE-size_for_title/4,tmp_title,/DEVICE,COLOR=0
          TV,black_box,0
      ENDIF
      SAVE,file=file_save,integ,par
      PRINT,''
    ENDIF ELSE BATCH_ERROR, image_name
    end_of_image:


end_image_time = SYSTIME(1)
PRINT, 'Total time for this image [s] : ',end_image_time-start_image_time

ENDFOR ; Image loop

JOURNAL

;remove garbage in the logfile
SPAWN,'/bin/cp ' + STRCOMPRESS(logdir+logfile,/REMOVE_ALL) + ' temp',/SH

SPAWN,'awk '' $2 !~ /ie/ && $3 !~ /ie/ && $4 !~ /scanned/ && $1 !~ /;p/ && $1 !~ /;\+/ && $1 !~ /;o/ && $1 !~ /;\*/ && $1 !~ /;w:/ && $1 !~ /;i/ && $1 !~ /;s/ {print}'' temp'+' > '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL),/SH

PRINT,'Integration session is DONE !'
;delete windows
IF show_image THEN BEGIN
 WDELETE,main_win
; WIDGET_CONTROL,window_id,/destroy  
ENDIF
IF show_ref_peaks OR show_strong_peaks OR show_weak_peaks OR show_ovlp_peaks OR show_m THEN WDELETE,study_win

escape :

;***********************************
END
;***********************************
;-














