FUNCTION select_peaks, peaks,atom_set, search_radius

;peaks is a set of (electron density) peaks, represented as a pdb model.
;atom_set is a set of atoms, represented as a pdb model.
;we select the peak that are close to atom_set within a radius given by search radius

j=0
selected_set=peaks
n_peaks = (SIZE(peaks))(1)
already_selected=BYTARR(n_peaks)

ct_set = (SIZE(atom_set))(1)

FOR i=0,ct_set-1 DO BEGIN
 w=WHERE((((peaks.x-atom_set(i).x)^2+(peaks.y-atom_set(i).y)^2+(peaks.z-atom_set(i).z)^2) LT search_radius^2) AND (already_selected EQ 0),ct)
 ;remove those which were already selected:
 
 IF ct GE 1 THEN BEGIN
  already_selected(w)=1
  selected_set(j:j+ct-1)=peaks(w)
 ENDIF
 j=j+ct
ENDFOR

PRINT,'Number of selected peaks = ',j
IF j GE 1 THEN RETURN, selected_set(0:j-1) ELSE RETURN,0

END
