FUNCTION READ_OUTLIERS,name
;+
; NAME:
;	READ_OUTLIERS
;
; PURPOSE:
;	Read in an outliers rejection text-file from LSCALE 
;
; CATEGORY:
;	Input
;
; CALLING SEQUENCE:
;   Result = READ_OUTLIERS(name)
;
; INPUTS:
;	NAME: String containing the name of outliers containing file.
;
; OUTPUTS:
;	READ_OUTLIERS returns a structure with the reflection info
;
; SIDE EFFECTS:
;	A file is read.
;
; COMMENTS:
;	The number of reflections are limited by MAX_REF.
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois December 98.
;-

;on_error,2                      ;Return to caller if an error occurs

max_ref=50000
i=1L
cr = STRING("15b)

OPENR, file, name, /GET_LUN 

; skip the first lines
line = ''
REPEAT READF,file,line UNTIL (line EQ '')

;define the structure of the outliers file
outliers_struc = CREATE_STRUCT('m',INTARR(3),'batch',0,'ii',0.0,'sigi',0.0,'scale',0.0,'lambda',0.0,'res',0.0)

ref = REPLICATE(outliers_struc,max_ref)

;define format
format1 = '(3I5,I5,2X,F13.3,2X,F13.3,5X,F10.3)'
format2 = '(F5.4)'
format3 = '(13X,F12.6)'

;define current parameters
h=FIX(0) & k=FIX(0) & l=FIX(0) & batch=FIX(0)
ii=0.0 & sigi=0.0 & scale=0.0 & lambda=0.0 & res=0.0
i=0L

WHILE (NOT EOF(file)) DO BEGIN
 IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' reflexions read',A)",i,cr
 READF,file,line
 READS,line,FORMAT=format1,h,k,l,batch,ii,sigi,scale
 READF,file,line
 READS,line,FORMAT=format2,lambda
 READF,file,line
 READS,line,FORMAT=format3,res
 
ref(i).m(0) = h & ref(i).m(1) = k & ref(i).m(2) = l 
ref(i).batch = batch
ref(i).ii = ii & ref(i).sigi = sigi 
ref(i).scale = scale
ref(i).lambda = lambda & ref(i).res = res
IF (NOT EOF(file)) THEN REPEAT READF,file,line UNTIL ((line EQ '') OR EOF(file))

  i = i + 1
ENDWHILE


PRINT,'Done !                '
PRINT,'Number of read reflexions : ',i

FREE_LUN, file

return, ref(0:i-1)
error:
return,0
END 



