FUNCTION READ_ESRF,display=display,no_rotate=no_rotate,file=file,header_size=header_size,beamline=beamline,longbyte=longbyte
;+
; NAME:
;	READ_ESRF
;
; PURPOSE:
;	Reads in ESRF data format (XRII)
;
; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_ESRF(file=file,/display,no_rotate=no_rotate,header_size=header_size,beamline=beamline,[/longbyte])
;
; INPUTS:
; 	Display : set this keyword to display the Log of the image
;	No_Rotate : set this keyword to avoid rotation of the image. If not
;		given the image will be rotated by ROTATE(image,4)
;	file : a filename
;	header_size : the size of the header (in bytes). Default : 1024.
;	beamline : set this keyword for image orientation as at the beamline
;		ID9 with DIS.
;	longbyte : [optional] set this keyword to read in a long byte image
;
; OUTPUTS:
;	READ_ESRF returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, April 1994
;-

;on_error,2                      ;Return to caller if an error occurs

;open the file

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 file=PICKFILE(/READ,PATH=GETENV('DATA'),FILTER=['*'])
ENDIF

IF file EQ '' THEN RETURN,0

OPENR,unit1,file,/BLOCK,/GET_LUN

;get the header
IF NOT KEYWORD_SET(header_size) THEN header_size=1024 ELSE header_size=header_size-2

;first read the file header as a byte array
header = BYTARR(header_size,/NOZERO)
READU,unit1,header
;print the header
header=STRTRIM(STRING(header))
PRINT,''
PRINT,header

st1='Dim_1          = '
st1l=STRLEN(st1)
stx=STRPOS(header,st1)
stxd=STRMID(header,stx+st1l,4)
rows=LONG(stxd)

st2='Dim_2          = '
st2l=STRLEN(st2)
sty=STRPOS(header,st2)
styd=STRMID(header,sty+st2l,4)
columns=LONG(styd)

;rows=1242L
;columns=1152L

;rows=1024L
;columns=1024L

offset=LONG(header_size)

image_size = rows*columns
;let's get a standard image buffer
image = LONARR(rows, columns, /nozero)

IF KEYWORD_SET(longbyte) THEN BEGIN
 POINT_LUN,unit1,offset
 READU,unit1,image
 IF !version.os EQ 'linux' THEN BYTEORDER,image,/LSWAP
ENDIF ELSE $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, offset)


IF NOT KEYWORD_SET(no_rotate) AND KEYWORD_SET(beamline) THEN BEGIN
 PRINT,'Rotating image as in DISP (TOP=TOP, TOWARDS SOURCE) ... '
 image=ROTATE(image,7) 
ENDIF 

IF NOT KEYWORD_SET(no_rotate) AND NOT KEYWORD_SET(beamline) THEN BEGIN
 PRINT,'Rotating image as in LAUEGEN (TOP=RIGHT, TOWARDS SOURCE) ... '
 image=ROTATE(image,4) 
 tmp=rows & rows=columns & columns=tmp
ENDIF 

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
 WINDOW,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
 PRINT,'Displaying on window : ',!D.WINDOW
 IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF

FREE_LUN,unit1
RETURN, image

END






















