FUNCTION READ_BIN, file,rows,columns,offset=offset,erase=erase,display=display,no_rotate=no_rotate
;+
; NAME:
;	READ_BIN
;
; PURPOSE:
;	Read unsigned integers binary files into array of long signed integers
;	Used to read files produced by fit2d

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_BIN(filename,rows,colums,offset=offset,/erase,/display,/no_rotate)
;
; INPUTS:
;	Filename:	A string containing the name of file to read.
;
;	If the filename ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Rows:the number of rows in the image
;	Columns: the number of columns
;	Offset: the offset at which the data start
;	Rows : the number of rows
;	Colums : the number of columns
;	Offset : the size for an header if any. If none, set to 0.
;	Erase: set this keyword to erase previous windows.
; 	Display : set this keyword to display the Log of the image
;	No_rotate : set this keyword if the image is not to be rotated
;
; OUTPUTS:
;	READ_BIN returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; EXAMPLE:
;	Read the file "pattern" in the current directory into the variable
;	IMAGE, 	entering:
;
;		IMAGE = READ_BIN('pattern')
;
;	To view the image, scale to color range to the device and
;	display the data
;	entering:
;
;		TVSCL, IMAGE 
;
;	The image is usually to large to be displayed on the screen.
;	If the image plate has been scanned in low resolution mode,
;	rebin the image using the following commands;
;
;		IMSIZE = SIZE(IMAGE)
;		IMAGE = REBIN(IMAGE, IMSIZE(1)/2, IMSIZE(2)/2)
;		WINDOW, IMSIZE(1), IMSIZE(2)
;		TVSCL, IMAGE
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, September 1993
;-

;on_error,2                      ;Return to caller if an error occurs

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
if (strmid(file,(strlen(file)-2)(0),2) eq '.Z') then begin
	print, 'Comressed File! - Uncompressing...'
	spawn,  'zcat ' + file + ' >! /tmp/spefile.tmp'
	file = '/tmp/spefile.tmp'
endif

if n_elements(lun) le 0 then lun = -1	;Clean up
if lun gt 0 then free_lun, lun
openr,lun,file, error = i, /GET_LUN, /BLOCK
if i lt 0 then begin 			; Something wrong, 
	if lun gt 0 then free_lun,lun
	lun = -1
	print, 'Unable to open file: ' + file
	goto, nothing
endif

;
; Get image sizes
;


free_lun, lun

$ rm -f /tmp/gelfile.tmp

print, 'Converting to Long Integer.'
IF N_ELEMENTS(offset) EQ 0 THEN offset=0

image = lonarr(rows, columns, /nozero)

image_size = long(rows)*long(columns)

dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, long(offset))

IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
 PRINT,'Rotating image ...'
 ;image = ROTATE(image,7)
 image = ROTATE(image,4)
ENDIF

;shall we erase previous windows ?
IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
window,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows,ysize=columns
print,!d.window
tvscl,alog(image>1)
ENDIF

print, 'Done'
return, image

nothing:
return,0

end






















