/*
*************************************************************************
.NAME	     : iq_lib.c
.TYPE	     : Library code for IDL 'CALL_EXTERNAL'
.LANGUAGE    : C
.CATEGORY    : Image analysis
.ENVIRONMENT : SUN UNIX
.VERSION     : 1.2    14-09-93   Written by Olof Svensson
.COMMENTS    :
	This file contains two functions, one called 'iq_swap' and
        one called 'ii_swap'. The 'iq_swap'-function is called 
	by the IDL function 'IQ_READ'. Five arguments are passed: 
	      0. A pointer an image (array of IDL_LONG)
	      1. The total number of pixels in the image (IDL_LONG)
	      2. The filename of the .gel file (type STRING, see typedef)
	      3. The offset of the image in the image file
	      4. The correction factor
	The 'iq_swap' function reads the .gel file, swaps the bytes,
	converts them to IDL_LONG, squares them and multiplies them with
	the correction factor.

        The ii_swap function is wery similar to the iq_swap function,
        the main difference is that the ii_swap function does not
	take the corrction factor as an argument.

        The no_swap function does exactly the same as ii_swap but it
	is not swapping the bytes.	
*************************************************************************
*/

#include <stdio.h>
#include "Export.h"
#include <math.h>

#define BLOCKSIZE 65536
#define min(a,b) ((a>b)?b:a)

/*
*************************************************************************
Type definition of strings passed as arguments to the 'CALL_EXTERNAL'
function. See the IDL User's Guide page 18-10.
*************************************************************************
*/

void iq_swap(argc, argv)
  int argc;
  void *argv[];
{
  IDL_LONG *image, image_size, offset;
  IDL_LONG rest, workdata, index, block, i;
  unsigned char workblock[BLOCKSIZE*2];
  IDL_STRING filename;
  float CorrFactor;
  FILE *fopen(), *imagefile;
  

  image = (IDL_LONG *) argv[0];
  image_size = *(IDL_LONG *) argv[1];
  filename = *(IDL_STRING *) argv[2];
  offset = *(IDL_LONG *) argv[3];
  CorrFactor = *(float *) argv[4];

  printf("Filename = %s\n", filename.s);

  if ((imagefile = fopen(filename.s, "rb")) == NULL) {
    printf("Error in opening file %s\n", filename.s);
    exit(1);
  }
  else {
    fseek(imagefile, offset, 0);
    rest = image_size;
    index = 0;
    while (rest > 0) {
      block = min(BLOCKSIZE, rest);
      fread(workblock, 2*block, 1, imagefile);
      for (i = 0; i < 2*block; i += 2) {
	workdata = (IDL_LONG) workblock[i] + (IDL_LONG) 256 * (IDL_LONG) workblock[i + 1];
        image[index++] = (IDL_LONG) ((workdata * workdata) * (float) CorrFactor);
      } 
      rest -= block;
    }

    fclose(imagefile);
  }    
} /* End of iq_swap */
  
void ii_swap(argc, argv)
  int argc;
  void *argv[];
{
  IDL_LONG *image, image_size, offset;
  IDL_LONG rest, workdata, index, block, i;
  unsigned char workblock[BLOCKSIZE*2];
  IDL_STRING filename;
  FILE *fopen(), *imagefile;
  

  image = (IDL_LONG *) argv[0];
  image_size = *(IDL_LONG *) argv[1];
  filename = *(IDL_STRING *) argv[2];
  offset = *(IDL_LONG *) argv[3];

  printf("Filename = %s\n", filename.s);

  if ((imagefile = fopen(filename.s, "rb")) == NULL) {
    printf("Error in opening file %s\n", filename.s);
    exit(1);
  }
  else {
    fseek(imagefile, offset, 0);
    rest = image_size;
    index = 0;
    while (rest > 0) {
      block = min(BLOCKSIZE, rest);
      fread(workblock, 2*block, 1, imagefile);
      for (i = 0; i < 2*block; i += 2) {
	workdata = (IDL_LONG) workblock[i] + (IDL_LONG) 256 * (IDL_LONG) workblock[i + 1];
        image[index++] = (IDL_LONG) (workdata);
      } 
      rest -= block;
    }

    fclose(imagefile);
  }    
} /* End of ii_swap */
  
void no_swap(argc, argv)
  int argc;
  void *argv[];
{
  IDL_LONG *image, image_size, offset;
  IDL_LONG rest, workdata, index, block, i;
  unsigned char workblock[BLOCKSIZE*2];
  IDL_STRING filename;
  FILE *fopen(), *imagefile;
  

  image = (IDL_LONG *) argv[0];
  image_size = *(IDL_LONG *) argv[1];
  filename = *(IDL_STRING *) argv[2];
  offset = *(IDL_LONG *) argv[3];

  printf("Filename = %s\n", filename.s);

  if ((imagefile = fopen(filename.s, "rb")) == NULL) {
    printf("Error in opening file %s\n", filename.s);
    exit(1);
  }
  else {
    fseek(imagefile, offset, 0);
    rest = image_size;
    index = 0;
    while (rest > 0) {
      block = min(BLOCKSIZE, rest);
      fread(workblock, 2*block, 1, imagefile);
      for (i = 0; i < 2*block; i += 2) {
	workdata = (IDL_LONG) workblock[i + 1] + (IDL_LONG) 256 * (IDL_LONG) workblock[i];
        image[index++] = (IDL_LONG) (workdata);
      } 
      rest -= block;
    }

    fclose(imagefile);
  }    
} /* End of no_swap */
  



