#include <stdio.h>
#include <math.h>
#include "Export.h"
#include "Types.h"
#include "Manip.h"
#include "LUDecomp.h"
#include "Chi_sqr.h"

#define PERCENTAGE   25.0
#define DARK_CURRENT 0
#define GAIN         1.2
#define MAX_CYCLE    100
#define MAX_SLOPE    5000.0

/*
   parameters are in the follwing order:
   
   INPUTS                         IDL TYPE
   argv[0] = the array to process LONG ARRAY (xdim x ydim)
   argv[1] = xdim                 LONG 
   argv[2] = ydim                 LONG
   argv[3] = percentage           LONG
   argv[4] = bg_gain              FLOAT
   argv[5] = dark_current         FLOAT
   argv[6] = show                 LONG
   argv[7] = max_cycle            LONG
   argv[8] = max_slope            FLOAT

   OUTPUTS
   argv[9] = coeff                FLOAT ARRAY (3x1)
   argv[10] = noise_index          LONG ARRAY (?x1)
   argv[11] = struct float {      
          [0] -> bad_flag         LONG
          [1] -> bc_mean          FLOAT
          [2] -> n_back           LONG
          [3] -> chi_square_test  FLOAT
         }
   argv[12] = background
   */

void function(argc,argv)
int argc;
void *argv[];
{
  /* on se dit qu'un array a deux dimensions a et b
     equivaut a un array de dimension a.b */

  /* variables */

  /* in order to iterate, count, etc. */
  /* the use of some of them could be avoid */
  int i,j,k=0;
  IDL_LONG k1, k2, k3, k4;
  IDL_LONG k1_dk, k2_dk, k3_dk, k4_dk;
  float border_threshold = 0.15;
  int number_cycle;
  int number_back;
  float corr_fac = 0.0;
  int rejected = 1;
  float a11, a12, a13;
  float a21, a22, a23;
  float a31, a32, a33;
  float b1, b2, b3;
  IDL_LONG   sf1, sf2, sf3, sf4;
  int _indx;
  int _indy;
  IDL_LONG *ix;
  int count1, count2, count3, count4;
  int count;
  int *indx;
  float d;

  /* dimensions of arrays */
  int xsize = *(int *) argv[1];
  int ysize = *(int *) argv[2];
  IDL_LONG totsize = xsize*ysize;
  
  /* command line options */
  float percentage = PERCENTAGE;
  float dark_current = DARK_CURRENT;
  float bg_gain = GAIN;
  int perc = (int) PERCENTAGE;
  int show = 0;
  int max_cycle = MAX_CYCLE;
  float max_slope = MAX_SLOPE;

  float *_coeff;
  IDL_LONG *_noise_index;
  float *_o_data;
  float *_res;

  float chi_square;
  float chi_square_test;
  IDL_LONG n_back;
  float bc_mean;
  int bad_flag = 0;

  IDL_LONG *_image = (IDL_LONG *) argv[0];
  
  /* lots of arrays ... */

  Array array;
  Array array1, array2, array3, array4;
  Array wd1, wd2, wd3, wd4;
  Array w1, w2, w3, w4;
  Array ni1, ni2, ni3, ni4;
  Array w;
  Array xy1, xy2, xy3, xy4;
  Array wf1, wf2, wf3, wf4;

   /* used for linear system */
  FArray a;
  float **tmp_a;
  FArray b;
  float *tmp_b;

  Array noise_index;
  Array noise_density;
  Array kept_index;
  FArray bc; 
  /* the calculated background */
  Array coord;
  
  Array x,y,x2,y2;
  
  /* indispensable for pointers referencing */
  
  Array ref, ref2;
  FArray fref, fref2;


  /* --- LOADING INPUTS --- */
  _image = (IDL_LONG *) argv[0];
  xsize = *(int*) argv[1];
  ysize = *(int*) argv[2];
  perc = *(int*) argv[3];
  percentage = (float) perc;
  bg_gain = *(float *) argv[4];
  dark_current = *(float *) argv[5];
  show = *(int*) argv[6];
  max_cycle = *(int *)argv[7];
  max_slope = *(float *)argv[8];

   /* --- AND OUTPUTS --- */
  _coeff = (float *) argv[9];
  _noise_index = (IDL_LONG *) argv[10];
  _o_data = (float*) argv[11];
  _res = (float *) argv[12];

  array = CreateArray(xsize,ysize);
  k = 0;
  for(i = 0; i < ysize ;i++)
    {
      for(j = 0; j < xsize; j++)
	{
	  array.e[i][j] = (IDL_LONG) _image[k];
	  k++;
	}
    }
  x = Indgen1(xsize);
  y = Indgen1(ysize);
  x2 = DieseArray(x,ref = Replicate(1,ysize)); Delete(ref);
  y2 = DieseArray(ref = Replicate(1,xsize),y); Delete(ref);

  number_back = FixInt(percentage/100.*totsize);

  array1 = CopyArray(array,
		     0,FixInt(((float)xsize)/2.),
		     0,FixInt(((float)ysize)/2.) );
  array2 = CopyArray(array,
		     0, FixInt(((float)xsize)/2.),
		     FixInt(((float)ysize)/2.)+1, ysize);
  array3 = CopyArray(array,
		     FixInt(((float)xsize)/2.)+1, xsize,
		     0, FixInt(((float)ysize)/2.));
  array4 = CopyArray(array,
		     FixInt(((float)xsize)/2.)+1, xsize,
		     FixInt(((float)ysize)/2.)+1, ysize);
  
  wd1 = Where(ref = ArrayGT(array1,(IDL_LONG) dark_current), &count1); Delete(ref);
  wd2 = Where(ref = ArrayGT(array2,(IDL_LONG) dark_current), &count2); Delete(ref);
  wd3 = Where(ref = ArrayGT(array3,(IDL_LONG) dark_current), &count3); Delete(ref);
  wd4 = Where(ref = ArrayGT(array4,(IDL_LONG) dark_current), &count4); Delete(ref);

  if ((count1 == 0) || (count2 == 0) ||
      (count3 == 0) || (count4 == 0))
    {
      w = Where(ref = ArrayGT(array, (IDL_LONG) dark_current), &count); Delete(ref);
      if (count == 0)
	{ 
	  if (show) printf("All pixels below dark current. This does not make much sense !\n");
	  k = 0;
	  for(i = 0; i < ysize; i++)
	    {
	      for(j = 0; j < xsize; j++)
		{
		  _res[k] = (float) array.e[i][j];
		  k++;
		}

	    }
	  Delete(array1);
	  Delete(array2);
	  Delete(array3);
	  Delete(array4);
	  Delete(wd1);
	  Delete(wd2);
	  Delete(wd3);
	  Delete(wd4);
	  Delete(x);
	  Delete(y);
	  Delete(x2);
	  Delete(y2);
	  Delete(array);
	  _o_data[0] = (float) 1;
	  _o_data[1] = (float) 0;
	  _o_data[2] = (float) 0;
	  _o_data[3] = 0;
	  return;
	}

      w2 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array,w)),
		     0,min(count-1, number_back-1),
		     0,1);
      Delete(ref); Delete(ref2);
      /* We cannot use CopyArrayFromArrayInd(w,w2)  because
	 we assume that noise_index is a xsize*ysize IDL_LONG
	 array. (it is supposed to speed the code up in the while loop)
	 */
      noise_index = CreateArray(xsize*ysize,1);
       /* but ... we change noise_index' size virtually */
      noise_index.xsize = w2.xsize ;
      noise_index.ysize = 1;

      ix = (IDL_LONG*)malloc((w.xsize*w.ysize) * sizeof(IDL_LONG));
      k = 0;
      for(i = 0; i < w.ysize; i++)
	{
	  for(j = 0; j < w.xsize; j++)
	    {
	      ix[k] = w.e[i][j];
	      k++;
	    }
	}
      for(i = 0; i < w2.xsize; i++)
	{
	  noise_index.e[0][i] = ix[w2.e[0][i]];
	}
      /*bad_flag = 1;*/

      free(ix);
      Delete(w);
      Delete(w2);
    }
  else
    {
      w1 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array1,wd1)),
		     0, min(count1-1,number_back/4),
		     0,1);  Delete(ref); Delete(ref2);
      w2 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array2,wd2)),
		     0, min(count2-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);
      w3 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array3,wd3)),
		     0, min(count3-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);
      w4 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array4,wd4)),
		     0, min(count4-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);

      ni1 = CopyArrayFromArrayInd(wd1,w1);
      ni2 = CopyArrayFromArrayInd(wd2,w2);
      ni3 = CopyArrayFromArrayInd(wd3,w3);
      ni4 = CopyArrayFromArrayInd(wd4,w4);
   
      xy1 = Wheresub(ni1, array1);
      xy2 = Wheresub(ni2, array2);
      xy3 = Wheresub(ni3, array3);
      xy4 = Wheresub(ni4, array4);
     
      wf1 = CreateArray(1, xy1.ysize);
      for(i = 0; i < wf1.ysize; i++)
	{
	  wf1.e[i][0] = xy1.e[i][0] + xsize * xy1.e[i][1];
	}
      sf1 = wf1.ysize;
     
      wf2 = CreateArray(1, xy2.ysize);
      for(i = 0; i < wf2.ysize; i++)
	{
	  wf2.e[i][0] = xy2.e[i][0] + xsize * (xy2.e[i][1] + FixInt(ysize/2.+1));
	}
      sf2 = wf2.ysize;
    
      wf3 = CreateArray(1, xy3.ysize);
      for(i = 0; i < wf3.ysize; i++)
	{
	  wf3.e[i][0] = xy3.e[i][0] + FixInt(xsize/2.+1) + xsize * xy3.e[i][1];
	}
      sf3 = wf3.ysize;
    
      wf4 = CreateArray(1, xy4.ysize);
      for(i = 0; i < wf4.ysize; i++)
	{
	  wf4.e[i][0] = xy4.e[i][0] + FixInt(xsize/2.+1) + 
	    xsize * (xy4.e[i][1] + FixInt(ysize/2. +1));
								;
	}
      sf4 = wf4.ysize;
     
      /* noise_index = CreateArray(sf1+sf2+sf3+sf4,1);
	 We suppose that noise_index is xsize*ysize IDL_LONG 
	 */
      noise_index = CreateArray(xsize*ysize,1);
       /* but ... we change noise_index' size virtually */
      noise_index.xsize = sf1+sf2+sf3+sf4;
      noise_index.ysize = 1;
      for(i = 0; i < sf1; i++)
	{
	  noise_index.e[0][i] = wf1.e[i][0];
	}
      for(i = sf1; i < (sf1 + sf2); i++)
	{
	  noise_index.e[0][i] = wf2.e[i-sf1][0];
	}
      for(i = (sf1+sf2); i < (sf1 + sf2 + sf3); i++)
	{
	  noise_index.e[0][i] = wf3.e[i-sf1-sf2][0];
	}
      for(i = (sf1+sf2+sf3); i < (sf1 + sf2 + sf3 + sf4); i++)
	{
	  noise_index.e[0][i] = wf4.e[i-sf1-sf2-sf3][0] ;
	}

      Delete(w1);
      Delete(w2);
      Delete(w3);
      Delete(w4);

      Delete(ni1);
      Delete(ni2);
      Delete(ni3);
      Delete(ni4);

      Delete(xy1);
      Delete(xy2);
      Delete(xy3);
      Delete(xy4);

      Delete(wf1);
      Delete(wf2);
      Delete(wf3);
      Delete(wf4);

    }

  Delete(array1);
  Delete(array2);
  Delete(array3);
  Delete(array4);

  Delete(wd1);
  Delete(wd2);
  Delete(wd3);
  Delete(wd4);

 /*First selection now done. Proceed with Least-Square plane fitting */

  bc = CreateFArray(xsize,ysize);
  coord = CreateArray(2,xsize*ysize);

  rejected = 1;

  number_cycle = 0;

  corr_fac = fmax((-0.025*pow(bg_gain,0.9) + 2.0),0.1);
  /*max((-0.025*pow(GAIN,0.9) + 2.0),0.1);*/

  a = CreateFArray(3,3);
  tmp_a = (float**) malloc(4*sizeof(float *));;
  for(i = 1; i <= 3; i++)
    {
      tmp_a[i] = (float *)malloc(4*sizeof(float));
    }

  b = CreateFArray(3,1);
  tmp_b = (float*) malloc(4*sizeof(float));

  /* 
     noise_density = CopyArrayFromArrayInd(array, noise_index);.
     is done by hand because we don't want to allocate memory
     */

  noise_density = CreateArray(xsize*ysize,1);
  kept_index = CreateArray(xsize*ysize,1);
  noise_density.xsize = noise_index.xsize;
  noise_density.ysize = 1;

  ix = (IDL_LONG*)malloc((xsize*ysize) * sizeof(IDL_LONG));
  k = 0;
  for(i = 0; i < array.ysize; i++)
    {
      for(j = 0; j < array.xsize; j++)
	{
	  ix[k] = array.e[i][j];
	  k++;
	}
    }


  for(i = 0; i < noise_index.xsize; i++)
    {
      noise_density.e[0][i] = ix[noise_index.e[0][i]];
    }

  /* preprocessing : memory allocation */

  indx = (int*)malloc(4*sizeof(int));
  /*
     PrintArray(noise_index);
     */

  while((rejected != 0) && (number_cycle <= max_cycle))
    {
      /* printf("ns.x: %d\n", noise_index.xsize);*/

      number_cycle++;

      /* we cannot here use the code of CopyArrayFromArrayInd()
	 because it allocates memory, which is forbidden in a
	 loop.
	 */
      noise_density.xsize = noise_index.xsize;
      /*noise_density.ysize = 1;*/
      
      for(i = 0; i < noise_index.xsize; i++)
	{
	  noise_density.e[0][i] = ix[noise_index.e[0][i]];
	}

      /* Wheresub */
      /*coord.xsize = 2;*/
      coord.ysize = noise_index.xsize;

      for(i = 0; i < noise_index.xsize; i++)
	{
	  coord.e[i][0] = (IDL_LONG)(((int)noise_index.e[0][i]) % ((int)array.xsize));
	  coord.e[i][1] = (IDL_LONG)((noise_index.e[0][i] -
				  coord.e[i][0]) / array.xsize);
	}

            
      /* We built the A and B matrices */

      a11 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  a11 += (float) (coord.e[i][0]*coord.e[i][0]);
	}

      a12 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  a12 += (float) (coord.e[i][0]*coord.e[i][1]);
	}

      a13 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  a13 += (float) (coord.e[i][0]);
	}

      a21 = a12;
      a22 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  a22 += (float) (coord.e[i][1] * coord.e[i][1]);
	}
      a23 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  a23 += (float) coord.e[i][1];
	}

      a31 = a13;
      a32 = a23;
      a33 = (float) coord.ysize;

      a.e[0][0] = a11;
      a.e[1][0] = a12;
      a.e[2][0] = a13;
      a.e[0][1] = a21;
      a.e[1][1] = a22;
      a.e[2][1] = a23;
      a.e[0][2] = a31;
      a.e[1][2] = a32;
      a.e[2][2] = a33;
      
      b1 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  b1 += (float) (noise_density.e[0][i] * coord.e[i][0]);
	}
      b2 = (float) 0.0;
      for(i = 0; i < coord.ysize; i++)
	{
	  b2 += (float) (noise_density.e[0][i] * coord.e[i][1]);
	}
      b3 = (float) 0.0;
      for(i = 0; i < noise_density.xsize; i++)
	{
	  b3 += (float) (noise_density.e[0][i]);
	}
 
      b.e[0][0] = b1;
      b.e[0][1] = b2;
      b.e[0][2] = b3;
      
      /* We built tmp_a&b suiting for Numerical Recipes in C code */ 
      /* this parts needs improvements */

      for(i = 1; i <= 3; i++)
	{
       
	  for(j = 1; j <= 3; j++)
	  {
	    tmp_a[i][j] = a.e[i-1][j-1];
	  }
	}
      for(i = 1; i <= 3; i++)
	{
	  tmp_b[i] = b.e[0][i-1];
	}

      ludcmp(tmp_a,3,indx,&d);
      lubksb(tmp_a,3,indx,tmp_b);

      
      b.e[0][0] = tmp_b[1];
      b.e[0][1] = tmp_b[2];
      b.e[0][2] = tmp_b[3];


      /*
	 printf("coeffs (%f, %f, %f)\n", b.e[0][0], b.e[0][1], b.e[0][2]);
	 */
      for(i = 0; i < bc.ysize; i++)
	{
	  for(j = 0; j < bc.xsize; j++)
	    {
	      bc.e[i][j] = b.e[0][0] * ((float)x2.e[i][j]) + b.e[0][1] * ((float)y2.e[i][j]) + b.e[0][2];
	    }
	}
      
      /* kept_index = WHERE...*/
  
      count = 0;
      k = 0;
      for(i = 0; i < ysize; i++)
	{
	  for(j = 0; j < xsize; j++)
	    {
	      if(( fabs((float)array.e[i][j]-bc.e[i][j]) <= (corr_fac*sqrt(bg_gain*((float)array.e[i][j])))) &&
		 (((float)array.e[i][j]) >= dark_current))
		{
		  kept_index.e[0][count] = k;
		  count++;
		}
	      k++;
	    }
	 }

      kept_index.xsize = count;


      rejected = 0;

      if (kept_index.xsize != noise_index.xsize)
	rejected = 1;
      else
	{
	  for(i = 0; i < kept_index.ysize; i++)
	    {
	      for(j = 0; j < kept_index.xsize; j++)
		{
		  if(kept_index.e[i][j] != noise_index.e[i][j])
		    rejected = 1;
		}
	    }
	}

      noise_index.xsize = kept_index.xsize;
      noise_index.ysize = kept_index.ysize;
      for(i = 0; i < noise_index.ysize; i++)
	{
	  for(j = 0; j < noise_index.xsize; j++)
	    {
	      noise_index.e[i][j] = kept_index.e[i][j];
	    }
	}
      
      /*
	 printf("noise_index.xsize : %d\n", noise_index.xsize);
	 printf("noise_index.ysize : %d\n", noise_index.ysize); 
	 */
    }  /* end of while loop */




  free(ix);
  for(i = 1; i <= 3; i++)
    {
      free(tmp_a[i]);
    }
  free(tmp_a);
  free(tmp_b);
  free(indx);

  k = 0;

  for(i = 0; i < ysize; i++)
    {
      for(j = 0; j < xsize; j++)
	{
	  _res[k] = (float) bc.e[i][j];
	  k++;
	}

    }
  chi_square = 0.0;
  if (noise_index.xsize <= (2*(xsize+ysize)))
    {
      chi_square_test = 0.0;
      bad_flag = 1;
    }
  else
    {

      for(i = 0; i < noise_index.xsize; i++)
	{
	  _indx = (int) ((int)noise_index.e[0][i] % array.xsize);
	  _indy = (int) (((int)noise_index.e[0][i] - _indx)/array.xsize);
	  chi_square += (float)((sqr(bc.e[_indy][_indx] - array.e[_indy][_indx])/bg_gain)/fmax((array.e[_indy][_indx] - dark_current), 0.1));
	}

      chi_square_test = 1.0 - chi_sqr(chi_square, (float)noise_index.xsize - 3.0);

      if (chi_square_test <= 0.1)
	bad_flag = 1;
      else
	bad_flag = max(0,bad_flag);
    }
   

/* Look at the border of box and verify that at least 15% of the border pixels participate to background */

  k1 = 0; k2 = 0; k3 = 0; k4 = 0;
  for(i = 0; i < coord.ysize; i++)
    {
      if (coord.e[i][0] == (xsize-1))
	k1++;
      if (coord.e[i][1] == (ysize-1))
	k2++;
      if (coord.e[i][0] == 0)
	k3++;
      if (coord.e[i][1] == 0)
	k4++;
    }


  k2_dk = array.xsize ; k4_dk = array.xsize ; 
  for(i = 0; i < array.xsize; i++)
    {
      if (array.e[ysize-1][i] == (IDL_LONG) dark_current)
	k2_dk--;
      if (array.e[0][i] == (IDL_LONG) dark_current)
	k4_dk--;
    }

  k1_dk = array.ysize ; k3_dk = array.ysize ;
  for(i = 0; i < array.ysize; i++)
    {
      if (array.e[i][xsize-1] == (IDL_LONG) dark_current)
	k1_dk--;
      if (array.e[i][0] == (IDL_LONG) dark_current)
	k3_dk--;
    }

  if(fmin4(fmax((float)(k1),border_threshold)/(fmax((float)k1_dk,border_threshold)), fmax((float)(k2),border_threshold)/(fmax((float)k2_dk,border_threshold)), fmax((float)(k3),border_threshold)/(fmax((float)k3_dk,border_threshold)), fmax((float)(k4),border_threshold)/(fmax((float)k4_dk,border_threshold))) < border_threshold)
    bad_flag = 1;
  
  /*printf(" Final values for MaxX MaxY MinX MinY : %d, %d, %d, %d\n", k1_dk,k2_dk,k3_dk,k4_dk) ;*/
  
  rejected = totsize - noise_index.xsize;
  n_back = noise_index.xsize;
  bc_mean = b.e[0][0] * (xsize - 1.0)/2.0 + b.e[0][1] * (ysize -
							 1.0)/2.0 + b.e[0][2];
 
  for(i = 0; i < 3; i++)
      _coeff[i] = b.e[0][i];
  if(fmax(_coeff[0],_coeff[1]) > max_slope)
    bad_flag = 1;

  for(i = 0; i < noise_index.xsize; i++)
      _noise_index[i] = noise_index.e[0][i];

  _o_data[0] = (float) bad_flag;
  _o_data[1] = (float) bc_mean;
  _o_data[2] = (float) n_back;
  _o_data[3] = chi_square_test;

  if (show)
    {
      printf(" BACK2d_POLY4 Results : (by call_ext)\n");
      printf(" Chi_square value : %f\n", chi_square);
      printf(" Probability to find a higher value : %f\n", chi_square_test);
      printf(" Number of used pixels : %d\n", noise_index.xsize);
      printf(" Number of background pixels at max(x), max(y), min(x), min(y):%d,%d,%d,%d\n",
	     k1, k2, k3, k4);
      if(fmin4(fmax((float)(k1),border_threshold)/(fmax((float)k1_dk,border_threshold)), fmax((float)(k2),border_threshold)/(fmax((float)k2_dk,border_threshold)), fmax((float)(k3),border_threshold)/(fmax((float)k3_dk,border_threshold)), fmax((float)(k4),border_threshold)/(fmax((float)k4_dk,border_threshold))) < border_threshold)
	printf(" Not enough background pixels on one border !\n");
      if(fmax(_coeff[0],_coeff[1]) > max_slope)
	printf(" To big slope for background ! Maximum set to: %f\n",max_slope);
      printf(" Number of cycles: %d\n", number_cycle);
      printf(" Polynomial coefficients: %f, %f, %f\n", b.e[0][0], b.e[0][1], b.e[0][2]);
      printf(" Mean backgound value: %f\n", bc_mean);
      printf(" Number of rejected pixels [percent] : %f\n", 100*(1.0 - (n_back/(float)totsize)));
      if (bad_flag > 0)
	printf(" ******** BAD BACKGROUND *********\n");
      else
	printf(" ******** CORRECT BACKGROUND *********\n");
    }

  /* Deallocation of memory used by arrays */

  Delete(array); 

  Delete(noise_index);
  Delete(noise_density);
  Delete(kept_index);

  Delete(x);
  Delete(y);
  Delete(x2);
  Delete(y2);

  FDelete(a);
  FDelete(b);

  coord.ysize=xsize*ysize;
  Delete(coord);
  FDelete(bc);
  
  return;
}


