#ifndef CHI_SQR
#define CHI_SQR

#include <math.h>
#include "Manip.h"

float gammaln(xx)
     float xx;
{
  double x, tmp, ser;
  static double cof[6]={76.18009173,
			  -86.50532033,
			  24.01409822,
			  -1.231739516,
			  0.120858003e-2,
			  -0.536382e-5};

  int j;
  
  x = xx-1.0;
  tmp=x+5.5;

  tmp -= (x+0.5)*log(tmp);
  ser=1.0;
  for(j = 0; j <= 5; j++)
    {
      x += 1.0;
      ser += cof[j] / x;
    }

  return (-tmp+log(2.50662827465*ser));
}

float g_series(x,a)
     float x;
     float a;
{
  FArray resarray;
  int i,k=0;
  float glog = gammaln(a);
  float sum = 0.0;
  float result;
  long nsample;

  nsample = (long) max2((long)(x/50.0),1000);

  /* ??? */
  resarray = CreateFArray((int)nsample,1);
  for(i = 0; i < nsample; i++)
    {
      resarray.e[0][i] = 1.0/(k+a);
      if (i >= 1)
	resarray.e[0][i] = x*resarray.e[0][i];
      k++;
    }
  sum = 1.0/a;

  for(i = 1; i < nsample; i++)
    {

      resarray.e[0][0] = resarray.e[0][0]*resarray.e[0][i];

      sum = sum + resarray.e[0][0];
      if (fabs(resarray.e[0][0]) < (fabs(sum) * 3.0e-7))
	{
	  result = sum * exp(-x+a*log(x) - glog);
	  FDelete(resarray);
	  return result;
      	}
    }
  result = -1;
  FDelete(resarray);
  return result;
}


float g_fract(x,a)
float x,a;
{
  float glog = gammaln(a);
  float gd = 0.0;
  float fc = 1.0;
  float a1, ana;
  float b1 = 1.0;
  float bo = 0.0;
  float ao = 1.0;
  float an,g,anf;
  float result;
  int n;

  a1 = x;
  for(n = 1; n <= 100; n++)
    {
      an = (float) n;
      ana = an - a;
      ao = (a1 + ao*ana) * fc;
      bo = (b1 + bo*ana) * fc;
      anf = an * fc;
      a1 = x * ao + anf * a1;
      b1 = x * bo + anf * b1;
      if (a1 != 0)
	{
	  fc = 1.0 / a1;
	  g = b1 * fc;
	  if (fabs((g-gd)/g) < 3.0e-7)
	    {
	      result = exp(-x  + a*log(x) - glog) * g;
	      return result;
	    }
	  gd = g;
	}
    }
  result = -1;
  return result;
}

float igamma_pdf(a,x)
float a,x;
{
  float r;

  if (x < (a+1.0))
    {

      return (g_series(x,a));

    }
  else
    {

      r = g_fract(x,a);
      if (r != -1)
	{
	  return (1.0-r);
	}
      else
	{
	  return -1;
	}

    }
}

float chi_sqr(x,df)
    float x,df;
{
  float gres;

  if (x <= 0.0)
    return 0.0;

  else
    {
      gres = igamma_pdf(df/2.0, x/2,0);
      if (gres != -1)
	{
	  return gres;
	}
    }
}

#endif








