/*
*************************************************************************
.NAME	     : iq_lib.c
.TYPE	     : Library code for IDL 'CALL_EXTERNAL'
.LANGUAGE    : C
.CATEGORY    : Image analysis
.ENVIRONMENT : SUN UNIX
.VERSION     : 1.2    14-09-93   Written by Olof Svensson
.COMMENTS    :
	This file contains two functions, one called 'iq_swap' and
        one called 'ii_swap'. The 'iq_swap'-function is called 
	by the IDL function 'IQ_READ'. Five arguments are passed: 
	      0. A pointer an image (array of long)
	      1. The total number of pixels in the image (long)
	      2. The filename of the .gel file (type STRING, see typedef)
	      3. The offset of the image in the image file
	      4. The correction factor
	The 'iq_swap' function reads the .gel file, swaps the bytes,
	converts them to long, squares them and multiplies them with
	the correction factor.

        The ii_swap function is wery similar to the iq_swap function,
        the main difference is that the ii_swap function does not
	take the corrction factor as an argument.

        The no_swap function does exactly the same as ii_swap but it
	is not swapping the bytes.	
*************************************************************************
*/

#include <stdio.h>
#include <math.h>

#define BLOCKSIZE 65536
#define min(a,b) ((a>b)?b:a)

/*
*************************************************************************
Type definition of strings passed as arguments to the 'CALL_EXTERNAL'
function. See the IDL User's Guide page 18-10.
*************************************************************************
*/
typedef struct {
  unsigned short length;
  short reserved;
  char *s;
} STRING;


void iq_swap(argc, argv)
  int argc;
  void *argv[];
{
  long *image, image_size, offset;
  long rest, workdata, index, block, i;
  unsigned char workblock[BLOCKSIZE*2];
  STRING filename;
  float CorrFactor;
  FILE *fopen(), *imagefile;
  

  image = (long *) argv[0];
  image_size = *(long *) argv[1];
  filename = *(STRING *) argv[2];
  offset = *(long *) argv[3];
  CorrFactor = *(float *) argv[4];

  printf("Filename = %s\n", filename.s);

  if ((imagefile = fopen(filename.s, "rb")) == NULL) {
    printf("Error in opening file %s\n", filename.s);
    exit();
  }
  else {
    fseek(imagefile, offset, 0);
    rest = image_size;
    index = 0;
    while (rest > 0) {
      block = min(BLOCKSIZE, rest);
      fread(workblock, 2*block, 1, imagefile);
      for (i = 0; i < 2*block; i += 2) {
	workdata = (long) workblock[i] + (long) 256 * (long) workblock[i + 1];
        image[index++] = (long) ((workdata * workdata) * (float) CorrFactor);
      } 
      rest -= block;
    }

    fclose(imagefile);
  }    
} /* End of iq_swap */
  
void ii_swap(argc, argv)
  int argc;
  void *argv[];
{
  long *image, image_size, offset;
  long rest, workdata, index, block, i;
  unsigned char workblock[BLOCKSIZE*2];
  STRING filename;
  FILE *fopen(), *imagefile;
  

  image = (long *) argv[0];
  image_size = *(long *) argv[1];
  filename = *(STRING *) argv[2];
  offset = *(long *) argv[3];

  printf("Filename = %s\n", filename.s);

  if ((imagefile = fopen(filename.s, "rb")) == NULL) {
    printf("Error in opening file %s\n", filename.s);
    exit();
  }
  else {
    fseek(imagefile, offset, 0);
    rest = image_size;
    index = 0;
    while (rest > 0) {
      block = min(BLOCKSIZE, rest);
      fread(workblock, 2*block, 1, imagefile);
      for (i = 0; i < 2*block; i += 2) {
	workdata = (long) workblock[i] + (long) 256 * (long) workblock[i + 1];
        image[index++] = (long) (workdata);
      } 
      rest -= block;
    }

    fclose(imagefile);
  }    
} /* End of ii_swap */
  
void no_swap(argc, argv)
  int argc;
  void *argv[];
{
  long *image, image_size, offset;
  long rest, workdata, index, block, i;
  unsigned char workblock[BLOCKSIZE*2];
  STRING filename;
  FILE *fopen(), *imagefile;
  

  image = (long *) argv[0];
  image_size = *(long *) argv[1];
  filename = *(STRING *) argv[2];
  offset = *(long *) argv[3];

  printf("Filename = %s\n", filename.s);

  if ((imagefile = fopen(filename.s, "rb")) == NULL) {
    printf("Error in opening file %s\n", filename.s);
    exit();
  }
  else {
    fseek(imagefile, offset, 0);
    rest = image_size;
    index = 0;
    while (rest > 0) {
      block = min(BLOCKSIZE, rest);
      fread(workblock, 2*block, 1, imagefile);
      for (i = 0; i < 2*block; i += 2) {
	workdata = (long) workblock[i + 1] + (long) 256 * (long) workblock[i];
        image[index++] = (long) (workdata);
      } 
      rest -= block;
    }

    fclose(imagefile);
  }    
} /* End of no_swap */
  



