PRO BATCH_PROW
;+
; NAME:
;	BATCH_PROW
;
; PURPOSE:
;	Integrates data in batch mode (no graphics), for encapsulated version.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	BATCH_PROW
;
; INPUTS:
;	The inputs are provided with ENVIRONMENT variables :
;	PROW_IDL_FILE : an idl file containing a structure integ_state as 
;		defined in the PROW GUI.
;	PROW_NUMBER_START : the first image to be integrated
;	PROW_NUMBER_END : the last image to be integrated
;	PROW_REF_FILE : ref filename of a previously integrated image.
;		can also be set to 'NONE', if not used, or to GUESS, in which case
;		the reference profile filename is derived from the generic ref 
;		filename in PROW_IDL_FILE, with a number equal to PROW_NUMBER_START-1
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	If already existing, the Prow log file will be erased !
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, August 1997.
;-

;FOR ENCAPSULATED VERSION
encapsulated=1

IF encapsulated THEN BEGIN
 SETENV,'PROW_SCR='+getenv('XOP_HOME')+'/extensions/PROW/SCR/'
 SETENV,'PROW_HELP='+getenv('XOP_HOME')+'/extensions/PROW/HELP/'
 CASE !version.os OF
  'hp-ux' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/HPUX/'
	    END
  'IRIX' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/SGI/'
	   END
  'sunos' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/SUN/'
	   END
  'linux' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/LINUX/'
	   END
  'OSF' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/DEC/'
	   END
   ELSE : MESSAGE,'Unsupported OPERATING SYSTEM !'
 ENDCASE
 RESTORE,getenv('XOP_HOME')+'/extensions/prow.sav'
ENDIF

prow_file=GETENV('PROW_IDL_FILE')
IF STRLEN(prow_file) GT 0 THEN BEGIN
 dum=FINDFILE(prow_file,COUNT=count)
 IF count EQ 0 THEN BEGIN
	PRINT,'PrOW integration parameters file does not exist : '+prow_file
	GOTO,escape
 ENDIF
ENDIF ELSE BEGIN
	PRINT ,'PrOW integration parameters file does not exist !'
	GOTO,escape
	ENDELSE

RESTORE,prow_file

integ_state.first = GETENV('PROW_NUMBER_START')
integ_state.last = GETENV('PROW_NUMBER_END')
integ_state.logfile = STR_REPLACE(integ_state.logfile,'.','_'+STRING(integ_state.first)+'_'+STRING(integ_state.last)+'.')

new_prow_file=STR_REPLACE(prow_file,'.',STRCOMPRESS('_'+STRING(integ_state.first)+'_'+STRING(integ_state.last)+'.'))
SAVE,integ_state,file=new_prow_file

ref_file=GETENV('PROW_REF_FILE')

IF STRLEN(ref_file) GT 0 THEN BEGIN
 IF ref_file NE 'NONE' AND ref_file NE 'GUESS' THEN BEGIN
 dum=FINDFILE(integ_state.prowdir+ref_file,COUNT=count)
  IF count EQ 0 THEN BEGIN
	PRINT,'Reference spots file does not exist : '+integ_state.prowdir+ref_file
	GOTO,escape
  ENDIF
 ENDIF
ENDIF ELSE BEGIN
	PRINT ,'Reference spots file does not exist !'
	GOTO,escape
	ENDELSE

IF ref_file EQ 'GUESS' THEN BEGIN
ref_number=integ_state.first-1
;try to guess the correct ref_file
 gen_ref_file=integ_state.reffile
 np1=STRPOS(gen_ref_file,'#') & np2=RSTRPOS(gen_ref_file,'#')
 CASE (np2-np1+1) OF
  1:BEGIN
   str_number=STRCOMPRESS(STRING(ref_number),/REMOVE_ALL)	
  END
  2:BEGIN
   IF ref_number LE 9 THEN $
    str_number=STRCOMPRESS('0'+STRING(ref_number),/REMOVE_ALL)	
   IF ref_number GE 10 THEN $
    str_number=STRCOMPRESS(STRING(ref_number),/REMOVE_ALL)	
  END
  3:BEGIN
   IF ref_number LE 9 THEN $
    str_number=STRCOMPRESS('00'+STRING(ref_number),/REMOVE_ALL)	
   IF ref_number GE 10 AND ref_number LT 100 THEN $
    str_number=STRCOMPRESS('0'+STRING(ref_number),/REMOVE_ALL)	
   IF ref_number GE 100 THEN $
    str_number=STRCOMPRESS(STRING(ref_number),/REMOVE_ALL)	
  END
  4:BEGIN
   IF ref_number LE 9 THEN $
    str_number=STRCOMPRESS('000'+STRING(ref_number),/REMOVE_ALL)	
   IF ref_number GE 10 AND ref_number LT 100 THEN $
    str_number=STRCOMPRESS('00'+STRING(ref_number),/REMOVE_ALL)	
   IF ref_number GE 100 AND ref_number LT 1000 THEN $
    str_number=STRCOMPRESS('0'+STRING(ref_number),/REMOVE_ALL)
   IF ref_number GE 1000 THEN $
    str_number=STRCOMPRESS(STRING(ref_number),/REMOVE_ALL)		
  END
 ENDCASE

gen_number=''
FOR loc_i=0,np2-np1 DO gen_number=STRCOMPRESS(gen_number+'#',/REMOVE_ALL)
ref_file=STR_REPLACE(gen_ref_file,gen_number,str_number)
PRINT,'Reference profile starts with : ',ref_file
ENDIF

IF ref_file EQ 'NONE' THEN $
 BATCH_INTEG,file=new_prow_file,/rm_log $
ElSE $
 BATCH_INTEG,file=new_prow_file,restart=ref_file,/rm_log

escape:
END


