PRO BATCH_CONVERT
;+
; NAME:
;	BATCH_CONVERT
;
; PURPOSE:
;	Integrates data in batch mode (no graphics), for encapsulated version.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	BATCH_CONVERT
;
; INPUTS:
;	The inputs are provided with ENVIRONMENT variables :
;	PROW_CONVERT_FILE : an idl file containing a structure denzox_state as 
;		defined in the PROW GUI.
;	PROW_NUMBER_START : the first image to be integrated
;	PROW_NUMBER_END : the last image to be integrated
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	If already existing, the Prow log file will be erased !
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, August 1997.
;-

;FOR ENCAPSULATED VERSION
encapsulated=1

IF encapsulated THEN BEGIN
 SETENV,'PROW_SCR='+getenv('XOP_HOME')+'/extensions/PROW/SCR/'
 SETENV,'PROW_HELP='+getenv('XOP_HOME')+'/extensions/PROW/HELP/'
 CASE !version.os OF
  'hp-ux' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/HPUX/'
	    END
  'IRIX' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/SGI/'
	   END
  'sunos' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/SUN/'
	   END
  'linux' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/LINUX/'
	   END
  'OSF' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/DEC/'
	   END
   ELSE : MESSAGE,'Unsupported OPERATING SYSTEM !'
 ENDCASE
 RESTORE,getenv('XOP_HOME')+'/extensions/prow.sav'
ENDIF

prow_file=GETENV('PROW_CONVERT_FILE')
IF STRLEN(prow_file) GT 0 THEN BEGIN
 dum=FINDFILE(prow_file,COUNT=count)
 IF count EQ 0 THEN BEGIN
	PRINT,'PrOW conversion parameters file does not exist : '+prow_file
	GOTO,escape
 ENDIF
ENDIF ELSE BEGIN
	PRINT ,'PrOW conversion parameters file does not exist !'
	GOTO,escape
	ENDELSE

RESTORE,prow_file

denzox_state.first = GETENV('PROW_NUMBER_START')
denzox_state.last = GETENV('PROW_NUMBER_END')
denzox_state.logfile = STR_REPLACE(denzox_state.logfile,'.','_'+STRING(denzox_state.first)+'_'+STRING(denzox_state.last)+'.')

new_prow_file=STR_REPLACE(prow_file,'.',STRCOMPRESS('_'+STRING(denzox_state.first)+'_'+STRING(denzox_state.last)+'.'))
SAVE,denzox_state,file=new_prow_file

BATCH_DENZOX,file=new_prow_file,/rm_log

escape:
END


