;batch file to convert into .ge files the idl integrated files :
;CUT2SB24_1.INTEG --> CUT2SB24_19.INTEG


;******************************************************************;
;PARAMETERS TO BE DEFINED BY USER;
;******************************************************************;

;info for log file
logdirectory = '/data/opid09/external/ls519/integ/' ; <--- HERE
logfile = 'geasc_w1.log' ; <--- HERE

;info for input files containing integrated intensities
integdir = '/data/opid09/external/ls519/integ/' ; <--- HERE
integfile_root = 'w1_' ; <--- HERE
integfile_ext = '.integ' ; <--- HERE
integnumber_start = 1 ; <--- HERE
integnumber_end = 1 ; <--- HERE
;Do you want to skip some files ?
skip_integs = 0 ; [0 : No ; 1 : Yes] <--- HERE
;If yes input here the numbers of the integ files to skip
integs_skipped = [ $
	1,	4,	76	$
		 ] ; <--- HERE


;info for input file containing original geasc file
geascdir = '/data/opid09/external/ls519/lauegen/' ; <--- HERE
geascfile = 'w1_' ; <--- HERE
geascfile_ext = '' ; <--- HERE

;info for output .ge1 and ge2 files
gedirectory = '/data/opid09/external/ls519/lauegen/' ; <--- HERE
gefile_root = 'w1_idl_' ; <--- HERE
gefile_ext = '' ; <--- HERE

;do you want to save output .geasc files
savegeasc = 1 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to remove multiples
removemultiples = 1 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to remove overlapped spots
removeovlp = 0 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to set all negative intensities to 0 ?
set_zero = 1 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to remove reflexions with intensities below a threshold ?
set_neg_thres = -1000 ; [0 : No ; Negative Number : Yes, give the value] <--- HERE

;do you want to save spots only in a limited region
savelimited = 0 ; [0 : No ; 1 : Yes] <--- HERE
;if yes enter minimum and maximum distance from beam center [mm]
rmin = 10.5
rmax = 10000.

;do you want to remove outliers
removeoutliers = 1 ; [0 : No ; 1 : Yes] <--- HERE

;if yes, do you want to keep low resolution data, even if
;they are outliers ?
keeplowres = 100 ; [100 : No ; if yes, input the low resolution limit] <--- HERE

;do you want to scale down values
scaledown = 32765. ; [0 : No ; Value : Yes, type the value] <--- HERE

;******************************************************************;
;END
;******************************************************************;

;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
rem=''
READ,'Log file exists. Remove it [y/n] ? ',rem
IF rem EQ 'y' THEN SPAWN,'rm -f '+STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)ELSE GOTO,escape
ENDIF
JOURNAL,STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)

;******************************************************************;
;FILES TO PROCESS
;******************************************************************;

integ_names = FINDFILE(STRCOMPRESS(integdir+integfile_root+ $
	'*'+integfile_ext,/REMOVE_ALL),count=count)
integ_numbers = FIX(STRMID(integ_names,STRLEN(integdir+integfile_root),3))
s = WHERE(integ_numbers GE integnumber_start AND integ_numbers LE integnumber_end)
integ_names = integ_names(s)
integ_numbers = integ_numbers(s)

IF skip_integs THEN BEGIN
FOR j=0,(SIZE(integs_skipped))(1)-1 DO BEGIN
sk = WHERE(integ_numbers NE integs_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	integ_numbers = integ_numbers(sk)
	integ_names = integ_names(sk)
ENDIF
ENDFOR
ENDIF

n_integs = (SIZE(integ_names))(1)
PRINT,'Number of integ files to process : ',(SIZE(integ_names))(1)
;******************************************************************;

;print sumup of all parameters :
PRINT,'**************************************************'
PRINT,' '
PRINT,'Name of log file : ',STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)
PRINT,'Root name of output .ge files : ',STRCOMPRESS(gedirectory+gefile_root,/REMOVE_ALL)
PRINT,'Root name of input files containing integrated intensities : ',STRCOMPRESS(integdir+integfile_root,/REMOVE_ALL)
PRINT,'Name of initial input .geasc file : ',STRCOMPRESS(geascdir+geascfile,/REMOVE_ALL)
PRINT,'First image to be integrated : ',integnumber_start
PRINT,'Last image to be integrated : ',integnumber_end
PRINT,' '

IF savegeasc EQ 1 THEN $
PRINT,'Also saving output geasc files ...' ELSE $
PRINT,'Not saving output geasc files ...'

IF removeoutliers EQ 1 THEN $
PRINT,'Removing outliers  ...' ELSE $
PRINT,'Not removing outliers ...'

IF keeplowres NE 100 THEN $
PRINT,'Keeping low resolution data even if outliers up to [A] : ',keeplowres

IF removemultiples EQ 1 THEN $
PRINT,'Removing multiples ...' ELSE $
PRINT,'Keeping multiples ...'

IF removeovlp EQ 1 THEN $
PRINT,'Removing overlapped spots ...' ELSE $
PRINT,'Keeping overlapped spots ...'

IF savelimited EQ 1 THEN $
PRINT,'Keeping spots between ',rmin,' and ',rmax,' [mm] from beam center' ELSE $
PRINT,'Keeping spots in the entire image ...'

IF set_zero EQ 1 THEN $
PRINT,'All negative intensities will be set to 0 !'

IF set_neg_thres LT 0 THEN $
PRINT,'Remove all reflections with integrated intensities lower than : ',set_neg_thres

IF scaledown GT 0 THEN $
PRINT,'Scaling down to :',scaledown ELSE $
PRINT,'Not scaling down ...'

PRINT,'**************************************************'


;for safety
CLOSE,1


;1/ Get the maximum value, and scale down to 32765
max=0.

IF scaledown GT 0 THEN BEGIN
FOR i=0,n_integs-1 DO BEGIN

integ_name=integ_names(i)
PRINT,'Opening :',integ_name
RESTORE,integ_name

IF removemultiples EQ 1 THEN  integ=integ(WHERE(integ.mul EQ 1))
IF removeovlp EQ 1 THEN  integ=integ(WHERE(integ.ovlp EQ 0))
IF savelimited EQ 1 THEN integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
IF removeoutliers EQ 1 THEN integ=integ(WHERE((integ.flag eq 0) OR (integ.flag EQ 4) OR (integ.res GE keeplowres)))
max = max>MAX(integ.intp(0))

ENDFOR
PRINT,'Maximum integrated intensity :',max

ENDIF


;2/ Write geasc files

FOR i=0,n_integs-1 DO BEGIN
;genumber = integnumber_start + i - integnumber_start

integ_name = integ_names(i)
PRINT,'Opening :',integ_name
RESTORE,integ_name

;geasc_name=STRCOMPRESS(geascdir+geascfile_root+STRING(geascnumber),/REMOVE_ALL)

geasc_name=STRCOMPRESS(geascdir+geascfile+ $
		STRMID(integ_name,STRLEN(integdir+integfile_root),3)+geascfile_ext,/REMOVE_ALL)
dummy=FINDFILE(STRCOMPRESS(geasc_name+'.geasc',/REMOVE_ALL), count=count)
IF (count eq 0) THEN MESSAGE, "Couldn't find original GEASC file."

ge_name=STRCOMPRESS(gedirectory+gefile_root+ $
		STRMID(integ_name,STRLEN(integdir+integfile_root),3)+gefile_ext,/REMOVE_ALL)

;number of initial reflections
num_refl = (SIZE(integ))(1)

IF removemultiples EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
 integ=integ(WHERE(integ.mul EQ 1))
 PRINT,'Number of rejected spots [multiples] : ', s1-(SIZE(integ))(1)
ENDIF

IF removeovlp EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
 integ=integ(WHERE(integ.ovlp EQ 0))
PRINT,'Number of rejected spots [overlaped] : ', s1-(SIZE(integ))(1)
ENDIF

IF savelimited EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
PRINT,'Number of rejected spots [outside region] : ', s1-(SIZE(integ))(1)
ENDIF

IF removeoutliers EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
integ=integ(WHERE(((integ.flag eq 0) OR (integ.flag EQ 4) OR (integ.res GE keeplowres)) AND (integ.flag NE 1)))
PRINT,'Number of rejected spots [outliers] : ', s1-(SIZE(integ))(1)
ENDIF

IF set_neg_thres LT 0 THEN BEGIN
 s1=(SIZE(integ))(1)
 w_pos_thres = WHERE(integ.intp(0) GE set_neg_thres,ct_pos_thres)
IF ct_pos_thres GT 0 THEN integ=integ(w_pos_thres)
PRINT,'Number of rejected spots [intensity below negative threshold] : ', s1-(SIZE(integ))(1)
ENDIF

;scale down to max=scaledown if necessary !
IF scaledown GT 0 THEN BEGIN
integ.intb(0) = integ.intb(0)*(scaledown/FLOAT(max))
integ.isigb(0) = integ.isigb(0)*(scaledown/FLOAT(max))
integ.intp(0) = integ.intp(0)*(scaledown/FLOAT(max))
integ.isigp(0) = integ.isigp(0)*(scaledown/FLOAT(max))
ENDIF

wz = WHERE(integ.intp(0) LE 0,nz)
PRINT,'Number of negative intensity spots : ',nz

IF set_zero EQ 1 THEN BEGIN
	IF nz GT 0 THEN integ(wz).intp(0) = 1
ENDIF

;the standard deviation should never be zero (scaling effect !)
integ.isigp(0) = integ.isigp(0) > 1

;number of kept reflections
num_kept_refl = (SIZE(integ))(1)
PRINT,'Number of kept reflexions :',num_kept_refl,' ie : ',num_kept_refl/FLOAT(num_refl)*100,' %'

WRITE_GEASC,ge_name,integ
PRINT,'Done !'

;get the geasc file with good header
SPAWN,'source ' + STRTRIM(GETENV('PROW_SCR')+'merge_geasc.scr') + ' ' + geasc_name + ' ' + ge_name

;get the .ge files
SPAWN,'source ' + STRTRIM(GETENV('PROW_SCR')+'get_ge.scr') + ' ' + ge_name

;Remove the .geasc file if necessary
IF savegeasc EQ 0 THEN BEGIN
SPAWN, 'rm -f ' + STRCOMPRESS(ge_name+'.geasc',/REMOVE_ALL) 
PRINT,'Removing ',STRCOMPRESS(ge_name+'.geasc',/REMOVE_ALL),' ...'
ENDIF
 
ENDFOR

JOURNAL
escape : 
END






