pro BATCH_ERROR, image_name
;+
; NAME:
;	BATCH_ERROR
;
; PURPOSE:
;	Print error messages to a file called BATCH.ERR and to the
;	screen.
;
; CATEGORY:
;	Error handling.
;
; CALLING SEQUENCE:
; 	BATCH_ERROR, image_name
;
; INPUTS:
;	IMAGE_NAME: Name of the current image.
;
; KEYWORDED PARAMETERS:
;	None
;
; OUTPUTS:
;	None.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	Thomas Ursby, Sep 1995
;
;-

OPENW, errfile, 'BATCH.ERR', /APPEND, ERROR=file_error, /GET_LUN
IF (file_error eq 0) THEN BEGIN
  SPAWN,'date', date
  PRINT, date+' ## NOT INTEGRATED: '+image_name
  PRINTF, errfile, date+' ## NOT INTEGRATED: '+image_name
  IF (!error ne 0) THEN BEGIN
    PRINT, ' Error code : '+STRING(!ERROR)
    PRINT, ' Error message : '+!ERR_STRING
    PRINTF, errfile, ' Error code : '+STRING(!ERROR)
    PRINTF, errfile, ' Error message : '+!ERR_STRING
  ENDIF
  IF (!syserror(0) ne 0) THEN BEGIN
    PRINT, ' System error code : '+ $
	STRING(!SYSERROR(0))+STRING(!SYSERROR(1))
    PRINT, ' System error message : '+!SYSERR_STRING
    PRINTF, errfile, ' System error code : '+ $
	STRING(!SYSERROR(0))+STRING(!SYSERROR(1))
    PRINTF, errfile, ' System error message : '+!SYSERR_STRING
  ENDIF
ENDIF
FREE_LUN, errfile

END