PRO win, xsize, ysize, title=title,free=free
;+
; NAME:
;	WIN
;
; PURPOSE:
;	Creates windows in a more convenient way than WINDOW
;
; CATEGORY:
;	Graphics
;
; CALLING SEQUENCE:
;	WIN,xsize,ysize,title='blablabla'
;
; INPUTS:
;	xsize,ysize : the sizes of the window
;	title : the title of the window
;	free : [optional] sets this keyword to get a free window
; OUTPUTS:
;	A window is diplayed.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, August  1993.
;-

on_error,2                              ;Return to caller if an error occurs

IF NOT KEYWORD_SET(free) THEN BEGIN
IF N_ELEMENTS(title) EQ 0 THEN BEGIN
	WINDOW,!D.WINDOW+1,XSIZE=xsize,YSIZE=ysize,TITLE=$
			STRCOMPRESS('#'+STRING(!D.WINDOW+1)) 
				ENDIF ELSE BEGIN
	WINDOW,!D.WINDOW+1,XSIZE=xsize,YSIZE=ysize,TITLE= $
STRCOMPRESS('# '+STRING(!D.WINDOW+1)+' '+title)
				ENDELSE
ENDIF ELSE BEGIN
IF N_ELEMENTS(title) EQ 0 THEN BEGIN
	WINDOW,/FREE,XSIZE=xsize,YSIZE=ysize,TITLE=$
			STRCOMPRESS('#???') 
				ENDIF ELSE BEGIN
	WINDOW,/FREE,XSIZE=xsize,YSIZE=ysize,TITLE= $
STRCOMPRESS(title)
				ENDELSE
ENDELSE
END